#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include "fft.h"

float lcos, lsin, lsin2, lcos_add, lsin_add;

float *do_fft(float *src, float *bb, int power, int dir)
{
	int N;
	float invNx2pi, r, i;
	float *swap;
	int x, n, maxx, maxn, z, xn, xn2;

	N = 1 << power;
	invNx2pi = 6.283185307 / N;
	for (z=0; z<power; z++) {
		maxx = 1 << (power-z-1); maxn = 1<<(z+1);
		//lsincos(invNx2pi * (float)maxx);
		//lcos_add = lcos; lsin_add = lsin;
		//asm ("fsincos" : "=t" (lcos_add), "=u" (lsin_add)
		//	: "0" (invNx2pi * (float)maxx));
		lcos_add = cos(invNx2pi * (float)maxx);
		lsin_add = sin(invNx2pi * (float)maxx);
		for (x = 0; x < maxx; x++) {
		lsin = 0.0; lcos = 1.0;
		for (n = 0; n < maxn; n++) {
			xn2 = ((x << z) | (n & ((1<<z)-1))) << 1;
			r = src[xn2]; i = src[xn2+1];
			xn2 |= 1<<power;
			//lsincos( invNx2pi*(1<<(power-z-1))*n );
			if (dir == -1) {
				r += src[xn2] * lcos + src[xn2+1] * lsin;
				i += src[xn2+1] * lcos - src[xn2] * lsin;
			} else {
				r += src[xn2] * lcos - src[xn2+1] * lsin;
				i += src[xn2] * lsin + src[xn2+1] * lcos;
			}
			xn = ((x << (z+1)) | n) << 1;
			bb[xn] = r;
			bb[xn+1] = i;
			lsin2 = (lsin * lcos_add) + (lcos * lsin_add);
			lcos  = (lcos * lcos_add) - (lsin * lsin_add);
			lsin  = lsin2;
		}
		}
		swap = src; src = bb; bb = swap;
	}
	return(src);
}

