#include <stdio.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>
#include <string.h>
#include "socket_utils.h"
#include "loop.h"
#include "main.h"

#define PO(s...)	printf(s)
#define PE(s...)	fprintf(stderr, s)

int strtoport(char *s)
{
	char *e;
	int r;

	r = strtol(s, &e, 0);
	if ((s==e)||(*e!=0)||(r<0)||(r>=65536)) {
		PO("Port should be [0;65535]\n");
		exit(1);
	}
	return(r);
}

int main(int argc, char **argv)
{
	int fd, fd2, p, p2;

	if ((argc < 3) || (argc > 5)) {
		PO("Usage: gembla <embla_addr> <video_addr> "
			"[embla_port] [video_port]\n");
		return(argc > 1);
	}
	
	if (argc >= 4) p = strtoport(argv[3]);
	else p = 18050;
	if (argc >= 5) p2 = strtoport(argv[4]);
	else p2 = 18060;

	fd = socket_connect(argv[1], p);
	if (fd<0) {
		// XXX return(1);
		PO("WARNING [embla]: Using stdio instead\n");
		fd = 0;
	}
	PO("Embla: Connected\n");
	
	fd2 = socket_connect(argv[2], p2);
	if (fd2<0) {
		// XXX return(1);
		PO("WARNING [video]: Using stdio instead\n");
		fd2 = 1;
	}
	
	PO("Video: Connected\n");
	return(mainloop(fd,fd2));
}
