#ifndef __MFORMAT_PNM_H
#define __MFORMAT_PNM_H

#define M_NONE		0
#define M_BITMAP_LE	1
#define M_BITMAP_BE	2
#define M_GRAYSCALE8	3
#define M_GRAYSCALE16	4
#define M_RGB		5
#define M_RGBA		6
#define M_RRGGBB	7
#define M_RRGGBBAA	8
#define M_RGB15		9
#define M_RGB16		10
#define M_BGR		11
#define M_BGRA		12
#define M_XXXA		13
#define M_XXXXXXAA	14

int pnm_width(char *src, int sz);
int pnm_height(char *src, int sz);
int pnm_native_csp(char *src, int sz);
int pnm_byte_align(int bytes);
int pnm_read(void *dst, int csp, char *src, int size);
int pnm_write(char *dst, int size, void *src, int w, int h, int csp);

// *******************
char *pnm_info(char *src, int *w, int *h, int *maxval, int *p, int sz);

// *******************
void pnm_fliplines(void *data, int lines, int linesize);

#endif

