#include <unistd.h>
#include <errno.h>
#include <sys/stat.h>
#include "rw.h"

int mread(int fd, void *b, int n)
{
	int r;

	while (n > 0) {
		r = read(fd, b, n);
		if (r == 0) return(-1);
		else if (r > 0) { b += r; n -= r; }
		else if ((errno!=EINTR)&&(errno!=EAGAIN)) return(-1);
	}
	return(0);
}

int mwrite(int fd, void *b, int n)
{
	int r;

	while (n > 0) {
		r = write(fd, b, n);
		if (r == 0) return(-1);
		else if (r > 0) { b += r; n -= r; }
		else if ((errno!=EINTR)&&(errno!=EAGAIN)) return(-1);
	}
	return(0);
}

int mfsize(int fd)
{
	struct stat s;

	if (fstat(fd, &s)) return(-1);
	return(s.st_size);
}

