#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <errno.h>
#include <string.h>
#include "network/ipv46.h"
#include "socket_utils.h"


#define PE(s...)	fprintf(stderr, s)

int socket_create_accept(char *name, int port)
{
	struct ip_addr a;
	int fd, peer;
	
	ip_setipv(&a, 4);
	if (ip_resolve(&a, name)) {
		PE("Can't resolve '%s'\n", name);
		return(-1);
	}
	if (ip_setport(&a, port)) {
		PE("Can't set port to %d\n", port);
		return(-1);
	}

	fd = socket(a.pf, SOCK_STREAM, 0);
	if (fd<0) {
		PE("Can't create socket: %s\n", strerror(errno));
		return(-1);
	}
	if (bind(fd, &a.addr.gen, a.addrsize)) {
		PE("Can't bind socket '%s': %s\n",
			name, strerror(errno));
		return(-1);
	}
	if (listen(fd, 16)) {
		PE("Can't put socket '%s' in listen mode: %s\n",
			name, strerror(errno));
		return(-1);
	}
	
	while (1) {
		peer = accept(fd, 0, 0);
		if (peer < 0) {
			if ((errno != EINTR) && (errno != EAGAIN)) {
				PE("accept() error: %s\n", strerror(errno));
				return(-1);
			}
		} else {
			close(fd);
			return(peer);
		}
	}
}

int socket_connect(char *name, int port)
{
	struct ip_addr a;
	int fd;

	ip_setipv(&a, 4);
	if (ip_resolve(&a, name)) return(-1);
	if (ip_setport(&a, port)) return(-1);

	fd = socket(a.pf, SOCK_STREAM, 0);
	if (fd<0) {
		PE("Can't create socket: %s\n", strerror(errno));
		return(-1);
	}
	
	if (connect(fd, &a.addr.gen, a.addrsize)) {
		PE("Can't connect to '%s': %s\n",
			name, strerror(errno));
		return(-1);
	}
	return(fd);
}


