# File free_energy.py
# Calculates the free energy and its derivatives
# Output results in different files
# Trace graphs
# Provide User Interface



# 1 Import the main libraries

from Tkinter import *
import math
import string, tempfile, os
import os.path



# 2 Define the initial prameters and  functions
listp = [" c "," sigma "," ti ","tf"," tstep ","salt" ]
param =[2.0,0.00001,40,120,0.1,0.075]

c       = param[0]
a       = param[1]
ti      = param[2]
tf      = param[3] 
step    = param[4]
salt    = param[5]



def store():
    c       = param[0]
    a       = param[1]
    ti      = param[2]
    tf      = param[3] 
    step    = param[4]
    salt    = param[5]

    pfile = open("melt_param.dat", "w")
    for i in range (0,6):
        pfile.write(listp[i]+" ")
    pfile.write("\n")
    for i in range (0,6):
        pfile.write(str(param[i])+" ")
    pfile.close()
    

def print_us():
    print "\n"
    for i in range (0,7):
        print listp[i]," = ",param[i]
    print "\n"
    store()

# 3 Define system methods

def Execute_free():
    os.system("./meltdna")
#


def print_melt():

    xrange = "set xr["+str(ti)+":"+str(tf)+"]"
    print xrange;
    gp = os.popen('gnuplot -background white','w')
    
    print >> gp, "set gr"
    print >> gp, xrange
    postscript = "set term post col; set output 'melt.eps' ;set title 'Melting curve for c="+str(param[0])+" and a="+str(param[1])+"';set xlab 'Unbound proportion'; set ylab 'Temperature (*C)' "
    print >> gp, postscript
    print >> gp, "pl 'melt.int'"
    os.popen("ghostview melt.eps&")

def save_melt():
#    save_plot()
    rep = "Datas/"
    extns= ".dat"

    base = "c"+str(param[0])+"_a"+str(param[1])

#    filename = rep+"free"+str(num)+extns
    os.system("mv melt.int "+rep+base+extns)   

# 4 Define the User Interface


# buttons for melting and drawing
class MeltBox(Frame):

    def __init__(self, master):

        Frame.__init__(self,master)
        self.grid(sticky = W)

        # drawing free energy

        self.process = Button(self, text="Melt it!",fg="red", command=Execute_free)
        self.process.grid(column=1,row = 1,sticky=EW)
       
        self.melt = Button(self, text="Melting curve",fg="blue", command=print_melt)
        self.melt.grid(column=1,row = 2,sticky=EW)

        self.save = Button(self, text="Save datas",fg="white", command=save_melt)
        self.save.grid(column=1,row = 3,sticky=EW)

        self.q = Button(self, text="QUIT", command=master.quit)
        self.q.grid(column=1,row=6, sticky=EW)


 

        
##############################################################################

class ParamBox(Frame):

    def __init__(self, master):

        Frame.__init__(self,master)
        self.grid(sticky = W)

    
        rownum = 2
        colnum = 0
        lblc = Label(self, text = " c ")
        lblc.grid(row = rownum, column = colnum,sticky = W)
        cbox = Entry(self, width = 7 ,bg="white")
        cbox.grid(row = rownum, column = colnum+1,sticky = E,pady = 2)
        
        rownum +=1
        lbla = Label(self, text = " sigma ")
        lbla.grid(row = rownum, column = colnum,sticky = W)
        abox = Entry(self, width = 7 ,bg="white")
        abox.grid(row = rownum, column = colnum+1,sticky = E,pady = 2)

        rownum +=1
        lbliter = Label(self, text = " salt ")
        lbliter.grid(row = rownum, column = colnum,sticky = W)
        iterbox = Entry(self, width = 7 ,bg="white")
        iterbox.grid(row = rownum, column = colnum+1,sticky = E,pady = 2)

        rownum = 2
        colnum = 2

        lbls = Label(self, text = " ti ")
        lbls.grid(row = rownum, column = colnum,sticky = W)
        sbox = Entry(self, width = 7 ,bg="white")
        sbox.grid(row = rownum, column = colnum+1,sticky = E,pady = 2)
        
        rownum +=1
        lblt = Label(self, text = " tf ")
        lblt.grid(row = rownum, column = colnum,sticky = W)
        tbox = Entry(self, width = 7 ,bg="white")
        tbox.grid(row = rownum, column = colnum+1,sticky = E,pady = 2)
        
        rownum +=1
        lble = Label(self, text = " step ")
        lble.grid(row = rownum, column = colnum,sticky = W)
        ebox = Entry(self, width = 7 ,bg="white")
        ebox.grid(row = rownum, column = colnum+1,sticky = E,pady = 2)
 

        # get datas and update
        def update_c(event):
            if(cbox.get()is not ""):
                param[0] = float(cbox.get())
                store()
        def update_a(event):
            if(abox.get()is not ""):
                param[1] = float(abox.get())
                store()
        def update_e(event):
            if(ebox.get()is not ""): 
                param[4] = float(ebox.get())
                store()
        def update_s(event):
            if(sbox.get()is not ""):
                param[2] = float(sbox.get())
                store()
        def update_t(event):
            if(tbox.get() is not ""):
                param[3] = float(tbox.get())
                store()

        def update_iter(event):
            if(iterbox.get() is not ""):
                param[5] = float(iterbox.get())
                store()

        cbox.bind('<KeyRelease>', update_c)
        abox.bind('<KeyRelease>', update_a)
        tbox.bind('<KeyRelease>', update_t)
        ebox.bind('<KeyRelease>', update_e)
        sbox.bind('<KeyRelease>', update_s)
        iterbox.bind('<KeyRelease>', update_iter)




root = Tk()
root.title("Meltsim")


def stop(event):
    root.destroy() 
root.bind('<Escape>', stop)

MeltBox(root).grid(row=1,column=1,pady = 2)
ParamBox(root).grid(row=1,column=0,pady = 2)


root.mainloop()

 
