/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl;

import java.util.ArrayList;
import org.metaqtl.MetaQtlResult;
import org.metaqtl.Qtl;
import org.metaqtl.adapter.QtlAdapter;
import org.metaqtl.bio.IBioLocus;
import org.metaqtl.numrec.NumericalUtilities;
import org.metaqtl.util.MappingFunction;
import org.metaqtl.util.OffspringManager;

public class Chromosome {
    public int nm;
    public int cs = 0;
    public int ct = 0;
    public int cg = 0;
    public int mfc;
    public int mut;
    public boolean skeleton;
    public double totd;
    public double[] mr = null;
    public String[] mrkNames = null;
    public String name = null;
    public String mapName = null;
    public Qtl[] qtls = null;
    public Qtl[] mqtls = null;
    public MetaQtlResult[] metaQtlAnalysis = null;
    public double[][] proba = null;

    public double getQTLInMrkIntProb(int mrkIdxL, int mrkIdxR, int qtlIdx) {
        if (this.qtls == null || this.qtls.length <= qtlIdx) {
            return 0.0;
        }
        Qtl qtl = this.qtls[qtlIdx];
        return this.getQTLInMrkIntProb(mrkIdxL, mrkIdxR, qtl);
    }

    public double getQTLInMrkIntProb(int mrkIdxL, int mrkIdxR, Qtl qtl) {
        double mu = qtl.position;
        double sigma = qtl.sd_position;
        if (sigma != 0.0) {
            double d = 0.0;
            int i = 0;
            while (i < mrkIdxL) {
                d += MappingFunction.distance(this.mr[i], this.mfc, this.mut);
                ++i;
            }
            double w = 0.0;
            while (i < mrkIdxR) {
                double h = 0.0;
                double y1 = Math.exp(-(mu - d) * (mu - d) / (2.0 * sigma * sigma)) / (Math.sqrt(Math.PI * 2) * sigma);
                if (y1 < Double.MIN_VALUE) {
                    y1 = 0.0;
                }
                h -= d;
                h += (d += MappingFunction.distance(this.mr[i], this.mfc, this.mut));
                double y2 = Math.exp(-(mu - d) * (mu - d) / (2.0 * sigma * sigma)) / (Math.sqrt(Math.PI * 2) * sigma);
                if (y2 < Double.MIN_VALUE) {
                    y2 = 0.0;
                }
                w += 0.5 * (y1 + y2) * h;
                ++i;
            }
            if (w < Double.MIN_VALUE) {
                w = 0.0;
            }
            return w;
        }
        if (mrkIdxL <= qtl.m1 && mrkIdxR >= qtl.m2) {
            return 1.0;
        }
        return 0.0;
    }

    public boolean areMarkersAroundQTL(int mrkIdxL, int mrkIdxR, int qtlIdx) {
        return mrkIdxL <= this.qtls[qtlIdx].m1 && mrkIdxR >= this.qtls[qtlIdx].m2;
    }

    public boolean hasQTL() {
        return this.qtls != null && this.qtls.length > 0;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.mapName);
        buff.append(System.getProperty("line.separator"));
        double d = 0.0;
        int i = 0;
        while (i < this.nm - 1) {
            buff.append(String.valueOf(this.mrkNames[i]) + " " + d);
            buff.append(System.getProperty("line.separator"));
            d += MappingFunction.distance(this.mr[i], 1, 2);
            ++i;
        }
        buff.append(String.valueOf(this.mrkNames[i]) + " " + d);
        buff.append(System.getProperty("line.separator"));
        return buff.toString();
    }

    public int getMarkerIdxWithName(String string) {
        if (this.mrkNames == null) {
            return -1;
        }
        int i = 0;
        while (i < this.mrkNames.length) {
            if (this.mrkNames[i].equals(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public double getDistanceBetween(int mrkIdxL, int mrkIdxR, int mapping_function, int mapping_unit) {
        if (mrkIdxL > mrkIdxR) {
            return 0.0;
        }
        double d = 0.0;
        int l = mrkIdxL;
        while (l < mrkIdxR) {
            d += MappingFunction.distance(this.mr[l], mapping_function, mapping_unit);
            ++l;
        }
        return d;
    }

    public double getDistanceBetween(int mrkIdxL, int mrkIdxR) {
        return this.getDistanceBetween(mrkIdxL, mrkIdxR, this.mfc, this.mut);
    }

    public double getDistance(int mrkIdx, int mapping_function, int mapping_unit) {
        double d;
        if (mrkIdx < 0) {
            return 0.0;
        }
        if (mrkIdx >= this.nm) {
            return 0.0;
        }
        if (mrkIdx == this.nm - 1) {
            d = MappingFunction.recombination(this.totd, this.mfc, this.mut);
            d = MappingFunction.distance(d, mapping_function, mapping_unit);
        } else {
            d = 0.0;
            int l = 0;
            while (l < mrkIdx) {
                d += MappingFunction.distance(this.mr[l], mapping_function, mapping_unit);
                ++l;
            }
        }
        return d;
    }

    public void updateMappingContext(int mapping_function, int mapping_unit) {
        boolean update;
        boolean bl = update = mapping_unit != this.mut && mapping_function != this.mfc;
        if (update) {
            if (this.qtls != null) {
                int j = 0;
                while (j < this.qtls.length) {
                    this.qtls[j].position = MappingFunction.recombination(this.qtls[j].position, this.mfc, this.mut);
                    this.qtls[j].position = MappingFunction.distance(this.qtls[j].position, mapping_function, mapping_unit);
                    if (this.qtls[j].ci != null) {
                        this.qtls[j].ci.from = this.qtls[j].position - MappingFunction.distance(this.qtls[j].ci.ic1, mapping_function, mapping_unit);
                        this.qtls[j].ci.to = this.qtls[j].position + MappingFunction.distance(this.qtls[j].ci.ic2, mapping_function, mapping_unit);
                    }
                    ++j;
                }
            }
            this.mfc = mapping_function;
            this.mut = mapping_unit;
        }
    }

    public double getDistance(int i) {
        return this.getDistance(i, this.mfc, this.mut);
    }

    public void r2R() {
        this.r2R(this.ct, this.cg);
    }

    public void r2R(int type, int gen) {
        this.totd = 0.0;
        int i = 0;
        while (i < this.nm - 1) {
            this.mr[i] = OffspringManager.r2R(this.mr[i], type, gen);
            this.totd += MappingFunction.distance(this.mr[i], this.mfc, this.mut);
            ++i;
        }
        if (this.qtls != null) {
            i = 0;
            while (i < this.qtls.length) {
                this.qtls[i].c1 = OffspringManager.r2R(this.qtls[i].c1, type, gen);
                this.qtls[i].c2 = OffspringManager.r2R(this.qtls[i].c2, type, gen);
                double tmp = MappingFunction.distance(this.qtls[i].c1, this.mfc, this.mut);
                this.qtls[i].position = tmp += this.getDistance(this.qtls[i].m1, this.mfc, this.mut);
                if (this.qtls[i].ci != null) {
                    this.qtls[i].ci.ic1 = OffspringManager.r2R(this.qtls[i].ci.ic1, type, gen);
                    this.qtls[i].ci.ic2 = OffspringManager.r2R(this.qtls[i].ci.ic2, type, gen);
                    this.qtls[i].ci.from = this.qtls[i].position - MappingFunction.distance(this.qtls[i].ci.ic1, this.mfc, this.mut);
                    this.qtls[i].ci.to = this.qtls[i].position + MappingFunction.distance(this.qtls[i].ci.ic2, this.mfc, this.mut);
                    this.qtls[i].ci.from = Math.max(0.0, this.qtls[i].ci.from);
                    this.qtls[i].ci.to = Math.min(this.qtls[i].ci.to, this.totd);
                }
                ++i;
            }
        }
    }

    public void R2r() {
        this.R2r(this.ct, this.cg);
    }

    public void R2r(int type, int gen) {
        this.totd = 0.0;
        int i = 0;
        while (i < this.nm - 1) {
            this.mr[i] = OffspringManager.R2r(this.mr[i], type, gen);
            this.totd += MappingFunction.distance(this.mr[i], this.mfc, this.mut);
            ++i;
        }
        if (this.qtls != null) {
            i = 0;
            while (i < this.qtls.length) {
                this.qtls[i].c1 = OffspringManager.R2r(this.qtls[i].c1, type, gen);
                this.qtls[i].c2 = OffspringManager.R2r(this.qtls[i].c2, type, gen);
                double tmp = MappingFunction.distance(this.qtls[i].c1, this.mfc, this.mut);
                this.qtls[i].position = tmp += this.getDistance(this.qtls[i].m1, this.mfc, this.mut);
                if (this.qtls[i].ci != null) {
                    this.qtls[i].ci.ic1 = OffspringManager.R2r(this.qtls[i].ci.ic1, type, gen);
                    this.qtls[i].ci.ic2 = OffspringManager.R2r(this.qtls[i].ci.ic2, type, gen);
                    this.qtls[i].ci.from = this.qtls[i].position - MappingFunction.distance(this.qtls[i].ci.ic1, this.mfc, this.mut);
                    this.qtls[i].ci.to = this.qtls[i].position + MappingFunction.distance(this.qtls[i].ci.ic2, this.mfc, this.mut);
                    this.qtls[i].ci.from = Math.max(0.0, this.qtls[i].ci.from);
                    this.qtls[i].ci.to = Math.min(this.qtls[i].ci.to, this.totd);
                }
                ++i;
            }
        }
    }

    public void computeQtlSD(int mode) {
        if (this.qtls == null) {
            return;
        }
        double[] sdci = null;
        double[] sdr2 = null;
        boolean max = mode == 4;
        boolean ci = mode == 2 || mode == 1;
        boolean r2 = mode == 3 || mode == 1;
        ci |= max;
        int i = 0;
        while (i < this.qtls.length) {
            this.qtls[i].sd_position = 0.0;
            ++i;
        }
        if (max) {
            sdci = new double[this.qtls.length];
            sdr2 = new double[this.qtls.length];
        }
        if (ci) {
            i = 0;
            while (i < this.qtls.length) {
                if (this.qtls[i].ci != null) {
                    this.qtls[i].sd_position = Qtl.getQTLSD(this.qtls[i].ci, this.mfc, this.mut);
                    if (max) {
                        sdci[i] = this.qtls[i].sd_position;
                    }
                }
                ++i;
            }
        }
        if (r2 |= max) {
            i = 0;
            while (i < this.qtls.length) {
                if (this.qtls[i].stats != null && (mode != 1 || this.qtls[i].sd_position == 0.0)) {
                    this.qtls[i].sd_position = Qtl.getQTLSD(this.qtls[i].stats.rsquare, this.qtls[i].cross, this.mut);
                    if (this.qtls[i].proj != null) {
                        this.qtls[i].sd_position *= this.qtls[i].proj.mapScale;
                    }
                    if (max) {
                        sdr2[i] = this.qtls[i].sd_position;
                    }
                }
                ++i;
            }
        }
        if (max) {
            i = 0;
            while (i < this.qtls.length) {
                this.qtls[i].sd_position = Math.max(sdci[i], sdr2[i]);
                ++i;
            }
        }
    }

    public Qtl[] getMetaQtls() {
        return this.mqtls;
    }

    public void setMetaQtls(Qtl[] metaQtl) {
        this.mqtls = metaQtl;
    }

    public Qtl[] getQtls() {
        if (this.qtls != null) {
            Qtl[] copy = new Qtl[this.qtls.length];
            int i = 0;
            while (i < copy.length) {
                copy[i] = this.qtls[i].getCopy();
                ++i;
            }
            return copy;
        }
        return null;
    }

    public int getQtlNumber() {
        return this.qtls == null ? 0 : this.qtls.length;
    }

    public void attachQtl(Qtl[] qtls) {
        int i;
        if (qtls == null) {
            return;
        }
        int s = 0;
        if (this.qtls != null) {
            Qtl[] tmp = new Qtl[qtls.length + this.qtls.length];
            i = 0;
            while (i < this.qtls.length) {
                tmp[i] = this.qtls[i];
                ++i;
            }
            s = this.qtls.length;
            this.qtls = tmp;
        } else {
            this.qtls = new Qtl[qtls.length];
        }
        i = s;
        while (i < this.qtls.length) {
            this.qtls[i] = qtls[i - s].getCopy();
            double qtlpos = this.qtls[i].position;
            double d = 0.0;
            int j = 0;
            while (j < this.nm - 1) {
                if ((d += MappingFunction.distance(this.mr[j], this.mfc, this.mut)) >= qtlpos) {
                    this.qtls[i].m1 = j;
                    this.qtls[i].m2 = j + 1;
                    this.qtls[i].c2 = d - qtlpos;
                    double dd = MappingFunction.distance(this.mr[j], this.mfc, this.mut);
                    this.qtls[i].c1 = dd - this.qtls[i].c2;
                    this.qtls[i].c1 = MappingFunction.recombination(this.qtls[i].c1, this.mfc, this.mut);
                    this.qtls[i].c2 = MappingFunction.recombination(this.qtls[i].c2, this.mfc, this.mut);
                    break;
                }
                ++j;
            }
            if (this.qtls[i].ci != null) {
                this.qtls[i].ci.ic1 = qtlpos - this.qtls[i].ci.from;
                if (this.qtls[i].ci.ic1 < 0.0) {
                    System.err.println("[ WARNING ]");
                    System.err.print("  In map " + this.mapName + " on chrom " + this.name + " : ");
                    System.err.println("  BAD LOD SUPPORT FOR QTL " + this.qtls[i].name);
                    this.qtls[i].ci = null;
                } else {
                    this.qtls[i].ci.ic1 = MappingFunction.recombination(this.qtls[i].ci.ic1, this.mfc, this.mut);
                    if (this.qtls[i].ci.to == 0.0) {
                        this.qtls[i].ci.to = this.totd;
                        System.err.println("[ WARNING ]");
                        System.err.print("  In map " + this.mapName + " on chrom " + this.name + " : ");
                        System.err.println("  NO UPPER LOD SUPPORT BOUNDARY FOR QTL " + this.qtls[i].name);
                    }
                    this.qtls[i].ci.ic2 = this.qtls[i].ci.to - qtlpos;
                    if (this.qtls[i].ci.ic2 < 0.0) {
                        System.err.println("[ WARNING ]");
                        System.err.print("  In map " + this.mapName + " on chrom " + this.name + " : ");
                        System.err.println("  BAD LOD SUPPORT FOR QTL " + this.qtls[i].name);
                        this.qtls[i].ci = null;
                    } else {
                        this.qtls[i].ci.ic2 = MappingFunction.recombination(this.qtls[i].ci.ic2, this.mfc, this.mut);
                    }
                }
            }
            if (this.qtls[i].cross == null) {
                this.qtls[i].cross = new Qtl.QTLCross(this.qtls[i]);
                this.qtls[i].cross.gen = this.cg;
                this.qtls[i].cross.type = this.ct;
                this.qtls[i].cross.size = this.cs;
            }
            ++i;
        }
    }

    public void attachQTL(IBioLocus[] qtls) {
        if (qtls == null) {
            return;
        }
        Qtl[] tmp = new Qtl[qtls.length];
        int i = 0;
        while (i < qtls.length) {
            tmp[i] = QtlAdapter.toQTL(qtls[i]);
            ++i;
        }
        this.attachQtl(tmp);
    }

    public String getMarkerName(int i) {
        if (i >= 0 && i < this.mrkNames.length) {
            return this.mrkNames[i];
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public static double[] getRecHeterogeneity(int ncm, int[][] mrkIdx, Chromosome chrom, Chromosome ref) {
        if (ncm <= 1) {
            return null;
        }
        double[] residuals = new double[ncm - 1];
        int mf = 1;
        int mu = 2;
        int i = 0;
        while (i < ncm - 1) {
            int mc1 = mrkIdx[0][i];
            int mc2 = mrkIdx[0][i + 1];
            int mr1 = mrkIdx[1][i];
            int mr2 = mrkIdx[1][i + 1];
            int df = 0;
            double d1 = chrom.getDistanceBetween(mc1, mc2, mf, mu);
            double r1 = MappingFunction.recombination(d1, mf, mu);
            double v1 = 0.0;
            if (chrom.ct != 0) {
                v1 = OffspringManager.fisherVariance(r1, chrom.cs, chrom.ct, chrom.cg);
                ++df;
            }
            double d2 = ref.getDistanceBetween(mr1, mr2, mf, mu);
            double r2 = MappingFunction.recombination(d2, mf, mu);
            double v2 = 0.0;
            if (ref.ct != 0) {
                v2 = OffspringManager.fisherVariance(r2, ref.cs, ref.ct, ref.cg);
                ++df;
            }
            if (df == 1) {
                residuals[i] = v1 > 0.0 ? (r1 - r2) * (r1 - r2) / v1 : (r1 - r2) * (r1 - r2) / v2;
                residuals[i] = NumericalUtilities.gammp(0.5, 0.5 * residuals[i]);
            } else if (df == 2) {
                double r = (r1 / v1 + r2 / v2) / (1.0 / v1 + 1.0 / v2);
                residuals[i] = ((r1 - r) / v1 + (r2 - r) / v2) / (1.0 / v1 + 1.0 / v2);
                residuals[i] = NumericalUtilities.gammp(0.5, 0.5 * residuals[i]);
            } else {
                residuals[i] = 0.0;
            }
            ++i;
        }
        return residuals;
    }

    public static double[] getDistHeterogeneity(int ncm, int[][] mrkIdx, Chromosome chrom, Chromosome ref) {
        if (ncm <= 1) {
            return null;
        }
        double[] residuals = new double[ncm - 1];
        int mf = 1;
        int mu = 2;
        int i = 0;
        while (i < ncm - 1) {
            int mc1 = mrkIdx[0][i];
            int mc2 = mrkIdx[0][i + 1];
            int mr1 = mrkIdx[1][i];
            int mr2 = mrkIdx[1][i + 1];
            int df = 0;
            double d1 = chrom.getDistanceBetween(mc1, mc2, mf, mu);
            double r1 = MappingFunction.recombination(d1, mf, mu);
            double v1 = 0.0;
            if (chrom.ct != 0) {
                v1 = OffspringManager.fisherVariance(r1, chrom.cs, chrom.ct, chrom.cg);
                v1 = MappingFunction.varianceDistance(r1, v1, mf, mu);
                ++df;
            }
            double d2 = ref.getDistanceBetween(mr1, mr2, mf, mu);
            double r2 = MappingFunction.recombination(d2, mf, mu);
            double v2 = 0.0;
            if (ref.ct != 0) {
                v2 = OffspringManager.fisherVariance(r2, ref.cs, ref.ct, ref.cg);
                v2 = MappingFunction.varianceDistance(r2, v2, mf, mu);
                ++df;
            }
            if (df == 1 && (v1 != 0.0 || v2 != 0.0)) {
                residuals[i] = v1 > 0.0 ? (d1 - d2) / Math.sqrt(v1) : (d1 - d2) / Math.sqrt(v2);
                int n = i;
                residuals[n] = residuals[n] * residuals[i];
                residuals[i] = NumericalUtilities.gammp(0.5, 0.5 * residuals[i]);
            } else if (df == 2 && v1 != 0.0 && v2 != 0.0) {
                double r = (d1 / v1 + d2 / v2) / (1.0 / v1 + 1.0 / v2);
                residuals[i] = ((d1 - r) / v1 + (d2 - r) / v2) / (1.0 / v1 + 1.0 / v2);
                residuals[i] = NumericalUtilities.gammp(0.5, 0.5 * residuals[i]);
            } else {
                residuals[i] = 0.0;
            }
            ++i;
        }
        return residuals;
    }

    public double[][] getProba() {
        return this.proba;
    }

    public void setProba(double[][] proba) {
        this.proba = proba;
    }

    public static int getFirstCommonMrkIdx(Chromosome chrom, Chromosome chrom2) {
        int i = 0;
        while (i < chrom2.nm) {
            int j = 0;
            while (j < chrom.nm) {
                if (chrom.mrkNames[j].equals(chrom2.mrkNames[i])) {
                    return j;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    public Chromosome getSubChromosome(String[] markerNames) {
        if (markerNames == null) {
            return null;
        }
        Chromosome sub = null;
        ArrayList<String> mrk = new ArrayList<String>();
        int i = 0;
        while (i < this.nm) {
            int j = 0;
            while (j < markerNames.length) {
                if (this.mrkNames[i].equals(markerNames[j])) {
                    mrk.add(this.mrkNames[i]);
                }
                ++j;
            }
            ++i;
        }
        if (mrk.size() > 1) {
            sub = new Chromosome();
            sub.nm = mrk.size();
            sub.cg = this.cg;
            sub.cs = this.cs;
            sub.ct = this.ct;
            sub.mfc = this.mfc;
            sub.mut = this.mut;
            sub.skeleton = this.skeleton;
            sub.mapName = new String(this.mapName);
            sub.name = new String(this.name);
            sub.mrkNames = new String[mrk.size()];
            mrk.toArray(sub.mrkNames);
            sub.mr = new double[mrk.size() - 1];
            sub.totd = 0.0;
            i = 0;
            while (i < sub.nm - 1) {
                int m1 = this.getMarkerIdxWithName(sub.mrkNames[i]);
                int m2 = this.getMarkerIdxWithName(sub.mrkNames[i + 1]);
                sub.mr[i] = this.getDistanceBetween(m1, m2, sub.mfc, sub.mut);
                sub.totd += sub.mr[i];
                sub.mr[i] = MappingFunction.recombination(sub.mr[i], sub.mfc, sub.mut);
                ++i;
            }
            if (this.qtls != null) {
                ArrayList<Qtl> qtl2Attach = new ArrayList<Qtl>();
                int i2 = 0;
                while (i2 < this.qtls.length) {
                    if (this.qtls[i2].m1 >= this.getMarkerIdxWithName(sub.mrkNames[0]) && this.qtls[i2].m2 <= this.getMarkerIdxWithName(sub.mrkNames[sub.nm - 1])) {
                        Qtl qtl = this.qtls[i2].getCopy();
                        this.updateQtlPos(qtl, this.getMarkerIdxWithName(sub.mrkNames[0]), sub.totd);
                        qtl2Attach.add(qtl);
                    }
                    ++i2;
                }
                if (qtl2Attach.size() > 0) {
                    sub.qtls = new Qtl[qtl2Attach.size()];
                    qtl2Attach.toArray(sub.qtls);
                }
            }
        }
        return sub;
    }

    private void updateQtlPos(Qtl qtl, int midx, double length) {
        double shift = this.getDistance(midx);
        qtl.position -= shift;
        if (qtl.ci != null) {
            qtl.ci.from = qtl.position - MappingFunction.distance(qtl.ci.ic1, this.mfc, this.mut);
            qtl.ci.from = qtl.ci.from >= 0.0 ? qtl.ci.from : 0.0;
            qtl.ci.to = qtl.position + MappingFunction.distance(qtl.ci.ic2, this.mfc, this.mut);
            qtl.ci.to = qtl.ci.to >= length ? qtl.ci.to : length;
        }
    }

    public String getMapName() {
        return this.mapName;
    }
}

