/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl;

import org.metaqtl.ChromCluster;
import org.metaqtl.Chromosome;
import org.metaqtl.MultiFitResult;
import org.metaqtl.numrec.NumericalUtilities;
import org.metaqtl.util.MappingFunction;

public class MetaChrom {
    public int nc;
    public int nm;
    public int ni;
    public int dof;
    public int[] nmc;
    public int[] mrkOc;
    public double chi2;
    public double pvalue;
    public double[] rsd;
    public double[] d;
    public double[] sdd;
    public String name;
    public String[] mapNames;
    public String[] mrkNames;

    public MetaChrom(MultiFitResult result, ChromCluster chromCluster) {
        Chromosome[] chromosomes = chromCluster.getClusterMembers();
        if (chromosomes != null) {
            double dd;
            boolean ref;
            int sidx;
            int k;
            this.name = chromCluster.name;
            this.nc = chromosomes.length;
            this.nmc = new int[this.nc];
            this.mapNames = new String[this.nc];
            int i = 0;
            while (i < this.nc) {
                this.nmc[i] = chromosomes[i].nm;
                this.mapNames[i] = chromosomes[i].mapName;
                ++i;
            }
            this.nm = chromCluster.getMarkerNumber();
            this.d = new double[this.nm];
            this.sdd = new double[this.nm];
            this.mrkNames = new String[this.nm];
            this.mrkOc = new int[this.nm];
            this.chi2 = result.chi2;
            this.pvalue = result.pvalue;
            this.dof = result.dof;
            this.ni = result.n;
            this.rsd = new double[this.ni];
            i = 0;
            while (i < this.ni) {
                this.rsd[i] = result.rsd[i];
                ++i;
            }
            double[] x = new double[result.m + 1];
            int[] idx = new int[result.m + 1];
            i = 0;
            while (i < result.m) {
                x[i + 1] = result.theta[i];
                ++i;
            }
            NumericalUtilities.indexx(result.m, x, idx);
            double[][] cov = result.cov;
            i = 0;
            while (i < this.nc) {
                if (chromosomes[i].skeleton) {
                    this.d[0] = 0.0;
                    double ddd = 0.0;
                    this.sdd[0] = 0.0;
                    k = 0;
                    int j = 0;
                    sidx = 0;
                    i = 1;
                    boolean notref = false;
                    ref = false;
                    if (x[idx[i]] < 0.0) {
                        dd = x[idx[i]];
                        this.sdd[0] = Math.sqrt(cov[idx[i] - 1][idx[i] - 1]);
                        ddd -= dd;
                        sidx = idx[i] - 1;
                        this.mrkNames[0] = chromCluster.getMarkerNameByIndex(sidx);
                        this.mrkOc[0] = chromCluster.getMarkerOccurence(sidx);
                        notref = true;
                        ++i;
                    } else {
                        dd = 0.0;
                        this.mrkNames[0] = chromCluster.getMarkerNameByIndex(this.nm - 1);
                        this.mrkOc[0] = chromCluster.getMarkerOccurence(this.nm - 1);
                        ref = true;
                        j = 1;
                        ddd = MappingFunction.distance(chromosomes[i].mr[0], 1, 1);
                    }
                    while (i <= result.m) {
                        double tmp = x[idx[i]] - dd;
                        if (x[idx[i]] > 0.0) {
                            while (j < chromosomes[i].nm) {
                                if (ddd < tmp) {
                                    this.d[++k] = ddd;
                                    this.sdd[k] = 0.0;
                                    this.mrkNames[k] = chromCluster.getMarkerNameByIndex(this.nm - 1);
                                    this.mrkOc[k] = chromCluster.getMarkerOccurence(this.nm - 1);
                                    ddd += MappingFunction.distance(chromosomes[i].mr[j - 1], 1, 1);
                                }
                                ++j;
                            }
                        }
                        this.d[++k] = tmp;
                        this.sdd[k] = cov[idx[i] - 1][idx[i] - 1];
                        this.sdd[k] = Math.sqrt(this.sdd[k]);
                        this.mrkNames[k] = chromCluster.getMarkerNameByIndex(idx[i] - 1);
                        this.mrkOc[k] = chromCluster.getMarkerOccurence(idx[i] - 1);
                        ++i;
                    }
                }
                ++i;
            }
            if (i == this.nc) {
                this.d[0] = 0.0;
                k = 0;
                sidx = 0;
                i = 1;
                if (x[idx[i]] < 0.0) {
                    dd = x[idx[i]];
                    this.sdd[0] = Math.sqrt(cov[idx[i] - 1][idx[i] - 1]);
                    sidx = idx[i] - 1;
                    this.mrkNames[0] = chromCluster.getMarkerNameByIndex(sidx);
                    this.mrkOc[0] = chromCluster.getMarkerOccurence(sidx);
                    ref = false;
                    ++i;
                } else {
                    dd = 0.0;
                    this.mrkNames[0] = chromCluster.getMarkerNameByIndex(this.nm - 1);
                    this.mrkOc[0] = chromCluster.getMarkerOccurence(this.nm - 1);
                    ref = true;
                }
                while (i <= result.m) {
                    if (x[idx[i]] >= 0.0 && !ref) {
                        this.d[++k] = -dd;
                        this.sdd[k] = 0.0;
                        this.mrkNames[k] = chromCluster.getMarkerNameByIndex(this.nm - 1);
                        this.mrkOc[k] = chromCluster.getMarkerOccurence(this.nm - 1);
                        ref = true;
                    }
                    this.d[++k] = x[idx[i]] - dd;
                    this.sdd[k] = cov[idx[i] - 1][idx[i] - 1];
                    this.sdd[k] = Math.sqrt(this.sdd[k]);
                    this.mrkNames[k] = chromCluster.getMarkerNameByIndex(idx[i] - 1);
                    this.mrkOc[k] = chromCluster.getMarkerOccurence(idx[i] - 1);
                    ++i;
                }
                if (!ref) {
                    this.d[++k] = -dd;
                    this.sdd[k] = 0.0;
                    this.mrkNames[k] = chromCluster.getMarkerNameByIndex(this.nm - 1);
                    this.mrkOc[k] = chromCluster.getMarkerOccurence(this.nm - 1);
                }
            }
        }
    }
}

