/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl;

import java.util.ArrayList;
import org.metaqtl.TreeNode;

public class Tree {
    public TreeNode[] nodes = null;
    public TreeNode root = null;
    private int nl = 0;
    private int nn = 0;

    public Tree() {
    }

    public Tree(TreeNode root) {
        this.root = root;
        this.nodes = this.initNodes(root, 0.0);
        this.nl = this.getLeafNumber();
        this.nn = this.nodes.length - this.nl;
    }

    private TreeNode[] initNodes(TreeNode root, double h) {
        TreeNode[] nodes = null;
        if (!root.leaf && root.children != null) {
            int nn = root.children.length;
            ArrayList<TreeNode[]> nodeList = new ArrayList<TreeNode[]>(root.children.length);
            int i = 0;
            while (i < root.children.length) {
                TreeNode[] t = this.initNodes(root.children[i], root.children[i].dist);
                if (t != null) {
                    nn += t.length;
                    nodeList.add(t);
                }
                ++i;
            }
            nodes = new TreeNode[nn];
            root.card = nn;
            i = 0;
            while (i < root.children.length) {
                nodes[i] = root.children[i];
                nodes[i].height = h + root.children[i].dist;
                ++i;
            }
            int j = root.children.length;
            int i2 = 0;
            while (i2 < nodeList.size()) {
                TreeNode[] t = (TreeNode[])nodeList.get(i2);
                int k = 0;
                while (k < t.length) {
                    t[k].height += h;
                    nodes[j++] = t[k];
                    ++k;
                }
                ++i2;
            }
        }
        return nodes;
    }

    public int getLeafNumber() {
        if (this.nodes == null) {
            return 0;
        }
        if (this.nl > 0) {
            return this.nl;
        }
        int nl = 0;
        int i = 0;
        while (i < this.nodes.length) {
            if (this.nodes[i].leaf) {
                ++nl;
            }
            ++i;
        }
        return nl;
    }

    public int getNodeNumber() {
        if (this.nodes == null) {
            return 0;
        }
        return this.nn;
    }

    public double[] getLeafHeights() {
        if (this.nl == 0) {
            return null;
        }
        double[] h = new double[this.nl];
        int j = 0;
        int i = 0;
        while (i < this.nodes.length) {
            if (this.nodes[i].leaf) {
                h[j++] = this.nodes[i].height;
            }
            ++i;
        }
        return h;
    }

    public double[] getNodeHeights() {
        if (this.nn == 0) {
            return null;
        }
        double[] h = new double[this.nn];
        int j = 0;
        int i = 0;
        while (i < this.nodes.length) {
            if (!this.nodes[i].leaf) {
                h[j++] = this.nodes[i].height;
            }
            ++i;
        }
        return h;
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public TreeNode getLeaf(int i) {
        int j = 0;
        while (j < this.nodes.length) {
            if (this.nodes[j].leaf && this.nodes[j].idx == i) {
                return this.nodes[j];
            }
            ++j;
        }
        return null;
    }

    public void initReverse() {
        this.recParent(this.root);
    }

    private void recParent(TreeNode node) {
        TreeNode[] children = node.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                children[i].parent = node;
                this.recParent(children[i]);
                ++i;
            }
        }
    }

    public void initNodeIdx() {
        this.setNodeIdx(this.root);
    }

    private void setNodeIdx(TreeNode node) {
        if (node.leaf) {
            node.nidx = new int[1];
            node.nidx[0] = node.idx;
        } else {
            TreeNode[] children = node.getChildren();
            ArrayList<Integer> nidxx = new ArrayList<Integer>();
            int i = 0;
            while (i < children.length) {
                this.setNodeIdx(children[i]);
                int j = 0;
                while (j < children[i].nidx.length) {
                    nidxx.add(new Integer(children[i].nidx[j]));
                    ++j;
                }
                ++i;
            }
            node.nidx = new int[nidxx.size()];
            i = 0;
            while (i < node.nidx.length) {
                node.nidx[i] = (Integer)nidxx.get(i);
                ++i;
            }
        }
    }

    public void updateLeafIdx(int[] nidx) {
        int i = 0;
        while (i < this.nodes.length) {
            if (this.nodes[i].leaf) {
                this.nodes[i].idx = nidx[this.nodes[i].idx];
            }
            ++i;
        }
    }
}

