/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.adapter;

import java.util.Properties;
import org.metaqtl.MetaChrom;
import org.metaqtl.MetaMap;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.entity.GeneticMap;
import org.metaqtl.bio.entity.LGroup;
import org.metaqtl.bio.entity.Marker;

public final class MetaMapAdapter {
    public static IBioGenome toIBioGenome(MetaMap metaMap) {
        GeneticMap geneticMap = null;
        if (metaMap == null) {
            return null;
        }
        geneticMap = new GeneticMap();
        Properties properties = geneticMap.getProperties();
        properties.setProperty("mapping.function", "haldane");
        properties.setProperty("mapping.unit", "cM");
        geneticMap.setProperties(properties);
        int i = 0;
        while (i < metaMap.nchr) {
            MetaChrom metaGroup = metaMap.chromosomes[i];
            LGroup group = new LGroup(metaGroup.name, geneticMap);
            int j = 0;
            while (j < metaGroup.nm) {
                Marker marker = new Marker(metaGroup.mrkNames[j], group);
                marker.setPosition(100.0 * metaGroup.d[j], 100.0 * metaGroup.sdd[j]);
                properties = marker.getProperties();
                properties.setProperty("meta.occurence", "" + metaGroup.mrkOc[j]);
                marker.setProperties(properties);
                group.addLocus(marker);
                ++j;
            }
            properties = group.getProperties();
            properties.setProperty("meta.chisquare", "" + metaGroup.chi2);
            properties.setProperty("meta.pvalue", "" + metaGroup.pvalue);
            properties.setProperty("meta.dof", "" + metaGroup.dof);
            group.setProperties(properties);
            geneticMap.addGroup(group);
            ++i;
        }
        return geneticMap;
    }
}

