/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.algo;

import org.metaqtl.CMarkerSequence;
import org.metaqtl.Chromosome;
import org.metaqtl.numrec.NumericalUtilities;

public final class CMSAlgorithm {
    public static CMarkerSequence run(Chromosome chrom1, Chromosome chrom2) {
        boolean ok;
        int id2;
        int id1;
        int j;
        CMarkerSequence cms = null;
        int[][] mcidx = new int[2][Math.min(chrom1.nm, chrom2.nm)];
        double[] tmp1 = new double[Math.min(chrom1.nm, chrom2.nm) + 1];
        int i = 0;
        int nmc = 0;
        while (i < chrom1.nm) {
            j = 0;
            while (j < chrom2.nm) {
                if (chrom1.mrkNames[i].equals(chrom2.mrkNames[j])) {
                    boolean swap;
                    id1 = i;
                    id2 = j;
                    if (nmc > 0) {
                        double d0 = chrom1.getDistanceBetween(mcidx[0][nmc - 1], i);
                        double d1 = j > mcidx[1][nmc - 1] ? chrom2.getDistanceBetween(mcidx[1][nmc - 1], j) : chrom2.getDistanceBetween(j, mcidx[1][nmc - 1]);
                        ok = d0 != 0.0 && d1 != 0.0;
                        swap = d0 == 0.0 && j < mcidx[1][nmc];
                    } else {
                        ok = true;
                        swap = false;
                    }
                    if (ok) {
                        mcidx[0][nmc] = id1;
                        mcidx[1][nmc] = id2;
                        tmp1[nmc + 1] = id2;
                        if (swap) {
                            NumericalUtilities.ISWAP(mcidx[0], nmc - 1, nmc);
                            NumericalUtilities.ISWAP(mcidx[1], nmc - 1, nmc);
                            NumericalUtilities.DSWAP(tmp1, nmc, nmc + 1);
                        }
                        ++nmc;
                    }
                }
                ++j;
            }
            ++i;
        }
        if (nmc >= 1) {
            cms = new CMarkerSequence(mcidx, nmc);
        }
        if (nmc > 2) {
            int[] idx1 = new int[nmc + 1];
            NumericalUtilities.indexx(nmc, tmp1, idx1);
            int lastIdx = -1;
            i = 0;
            id1 = mcidx[1][0];
            j = 1;
            while (j <= nmc) {
                if (idx1[j] == i + 1) break;
                ++j;
            }
            id1 = j - 1;
            boolean frame = true;
            boolean first = true;
            i = 1;
            while (i < nmc) {
                id2 = mcidx[1][i];
                j = 1;
                while (j <= nmc) {
                    if (idx1[j] == i + 1) break;
                    ++j;
                }
                id2 = j - 1;
                if (first) {
                    frame = id2 > id1;
                }
                if (ok = CMSAlgorithm.isInCMS(id1, id2, frame)) {
                    if (lastIdx == id1) {
                        int n = cms.ncs - 1;
                        int n2 = cms.css[n] + 1;
                        cms.css[n] = n2;
                        j = n2;
                    } else {
                        ++cms.ncs;
                        cms.frames[cms.ncs - 1] = frame;
                        cms.css[cms.ncs - 1] = 2;
                        j = 2;
                        cms.idx1[cms.ncs - 1][0] = mcidx[0][i - 1];
                        cms.idx2[cms.ncs - 1][0] = mcidx[1][i - 1];
                        cms.incms[i - 1] = true;
                    }
                    cms.idx1[cms.ncs - 1][j - 1] = mcidx[0][i];
                    cms.idx2[cms.ncs - 1][j - 1] = mcidx[1][i];
                    cms.incms[i] = true;
                    lastIdx = id2;
                    first = false;
                } else {
                    first = true;
                }
                id1 = id2;
                ++i;
            }
        } else if (nmc == 2 && chrom1.mrkNames[mcidx[0][0]].equals(chrom2.mrkNames[mcidx[1][0]])) {
            cms.ncs = 1;
            cms.css[0] = 2;
            j = 2;
            cms.frames[0] = true;
            cms.idx1[0][0] = mcidx[0][0];
            cms.idx2[0][0] = mcidx[1][0];
            cms.idx1[0][1] = mcidx[0][1];
            cms.idx2[0][1] = mcidx[1][1];
            cms.incms[1] = true;
            cms.incms[0] = true;
        }
        return cms;
    }

    private static boolean isInCMS(int id1, int id2, boolean frame) {
        return id2 == id1 + 1 && frame || id2 == id1 - 1 && !frame;
    }
}

