/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.algo;

import org.metaqtl.ChromCluster;
import org.metaqtl.Chromosome;
import org.metaqtl.MapCluster;
import org.metaqtl.MetaChrom;
import org.metaqtl.MetaDico;
import org.metaqtl.MetaMap;
import org.metaqtl.MultiFitResult;
import org.metaqtl.algo.MetaAlgorithm;
import org.metaqtl.algo.SVDAlgorithm;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioLocus;
import org.metaqtl.numrec.NumericalUtilities;
import org.metaqtl.util.MappingFunction;
import org.metaqtl.util.OffspringManager;

public class MetaMapAlgorithm
extends MetaAlgorithm {
    private int mrkThresh = 1;
    private MapCluster mapCluster = new MapCluster();
    private MetaMap consMap;

    public MetaMapAlgorithm(IBioGenome[] maps, IBioGenome skeleton, IBioLocus[] dubious, MetaDico mrkDico) {
        this.mapCluster.setDubiousMarker(dubious);
        this.mapCluster.setMarkerDico(mrkDico);
        int i = 0;
        while (i < maps.length) {
            this.mapCluster.addMap(maps[i], false);
            ++i;
        }
        if (skeleton != null) {
            this.mapCluster.addMap(skeleton, true);
        }
    }

    public MetaMap getResult() {
        return this.consMap;
    }

    public void run() {
        ChromCluster[] chrClusters = this.mapCluster.getClusters();
        if (chrClusters != null) {
            this.consMap = new MetaMap(chrClusters.length);
            int i = 0;
            while (i < chrClusters.length) {
                this.consMap.chromosomes[i] = this.buildMetaChrom(chrClusters[i]);
                ++i;
            }
        }
    }

    protected MetaChrom buildMetaChrom(ChromCluster cluster) {
        if (cluster == null) {
            return null;
        }
        cluster.setMrkThresh(this.mrkThresh);
        cluster.fixCluster();
        Chromosome[] chromosomes = cluster.getClusterMembers();
        if (chromosomes == null) {
            return null;
        }
        if (cluster.isConnected(2)) {
            int l;
            int xj1;
            double d;
            int j;
            int nc = chromosomes.length;
            int nm = cluster.getMarkerNumber();
            int ni = this.getMarkerIntervalNumber(chromosomes);
            double[] distances = new double[ni];
            double[] weights = new double[ni];
            double[][] X = new double[ni][nm];
            int i = 0;
            int xi = 0;
            while (i < nc) {
                if (!chromosomes[i].skeleton) {
                    int type = chromosomes[i].ct;
                    int size = chromosomes[i].cs;
                    int gen = chromosomes[i].cg;
                    j = 0;
                    while (j < chromosomes[i].nm - 1) {
                        double r = chromosomes[i].mr[j];
                        d = MappingFunction.distance(chromosomes[i].mr[j], 1, 1);
                        xj1 = j;
                        int xj2 = j + 1;
                        if (d <= 1.0E-5) {
                            l = j - 1;
                            while (l >= 0) {
                                if ((d += MappingFunction.distance(chromosomes[i].mr[l], 1, 1)) > 1.0E-5) break;
                                --l;
                            }
                            if (l >= 0) {
                                xj1 = l;
                            } else {
                                l = j + 1;
                                while (l < chromosomes[i].nm - 1) {
                                    if ((d += MappingFunction.distance(chromosomes[i].mr[l], 1, 1)) > 1.0E-5) break;
                                    ++l;
                                }
                                if (l < chromosomes[i].nm - 1) {
                                    xj2 = l + 1;
                                }
                            }
                        }
                        double x1 = NumericalUtilities.SIGN(1.0, (double)xj1 - (double)xj2);
                        double x2 = NumericalUtilities.SIGN(1.0, (double)xj2 - (double)xj1);
                        xj1 = cluster.getMarkerIndexByName(chromosomes[i].mrkNames[xj1]);
                        xj2 = cluster.getMarkerIndexByName(chromosomes[i].mrkNames[xj2]);
                        X[xi][xj1] = x1;
                        X[xi][xj2] = x2;
                        distances[xi] = d;
                        r = MappingFunction.recombination(d, 1, 1);
                        weights[xi] = OffspringManager.fisherVariance(r, size, type, gen);
                        weights[xi] = MappingFunction.varianceDistance(r, weights[xi], 1, 1);
                        weights[xi] = weights[xi] > 1.0E-32 ? 1.0 / weights[xi] : 0.0;
                        ++xi;
                        ++j;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < nc) {
                if (chromosomes[i].skeleton) {
                    d = 0.0;
                    j = 0;
                    while (j <= chromosomes[i].nm) {
                        l = xj1 = cluster.getMarkerIndexByName(chromosomes[i].mrkNames[j]);
                        while (l < nm - 1) {
                            int k = 0;
                            while (k < ni) {
                                int n = k;
                                distances[n] = distances[n] + X[k][l] * d;
                                X[k][l] = X[k][l + 1];
                                ++k;
                            }
                            ++l;
                        }
                        d += MappingFunction.distance(chromosomes[i].mr[j - 1], 1, 1);
                        ++j;
                    }
                    nm -= chromosomes[i].nm;
                    break;
                }
                ++i;
            }
            if (i == nc) {
                --nm;
            }
            double w = 0.0;
            i = 0;
            while (i < ni) {
                weights[i] = Math.sqrt(weights[i]);
                w += weights[i];
                ++i;
            }
            w /= (double)ni;
            i = 0;
            while (i < ni) {
                if (weights[i] == 0.0) {
                    weights[i] = w;
                }
                ++i;
            }
            MultiFitResult result = SVDAlgorithm.SVDMFit(X, distances, weights, ni, nm);
            return new MetaChrom(result, cluster);
        }
        this.getLogger().println("[ WARNING ] Unable to build a consensus linkage groups for chromosome " + cluster.name);
        this.getLogger().println("            => Linkage groups are deconnected");
        return null;
    }

    private int getMarkerIntervalNumber(Chromosome[] chromosomes) {
        int ni = 0;
        int i = 0;
        while (i < chromosomes.length) {
            ni += chromosomes[i].nm - 1;
            ++i;
        }
        return ni;
    }

    public void setMarkerDico(MetaDico mrkDico) {
        this.mapCluster.setMarkerDico(mrkDico);
    }

    public void setMrkThreshold(int mrkThresh) {
        this.mrkThresh = mrkThresh;
    }
}

