/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.bio.entity.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.StringTokenizer;
import org.metaqtl.bio.IBioEntity;
import org.metaqtl.bio.IBioLocus;
import org.metaqtl.bio.entity.GeneticMap;
import org.metaqtl.bio.entity.LGroup;
import org.metaqtl.bio.entity.Locus;
import org.metaqtl.bio.entity.factory.BioEntityFactory;
import org.metaqtl.bio.util.BioUtilities;
import org.metaqtl.bio.util.NumberFormat;
import org.metaqtl.bio.util.StaticLocusPosition;

public class MapChartFactory
extends BioEntityFactory {
    public IBioEntity load(Reader reader) throws IOException {
        GeneticMap map = new GeneticMap();
        BufferedReader red = new BufferedReader(reader);
        LGroup groupTemp = null;
        Locus locusTemp = null;
        boolean groupflag = false;
        boolean qtlflag = false;
        try {
            String line;
            while ((line = red.readLine()) != null) {
                double position;
                String nameLocus;
                StringTokenizer st;
                if (line.startsWith("qtls")) {
                    groupflag = false;
                    qtlflag = true;
                    continue;
                }
                if (groupflag && !line.equals("")) {
                    st = new StringTokenizer(line);
                    nameLocus = st.nextToken();
                    position = Double.parseDouble(st.nextToken());
                    locusTemp = Locus.newLocus(0);
                    locusTemp.setGroup(groupTemp);
                    locusTemp.setName(nameLocus);
                    locusTemp.setPosition(new StaticLocusPosition(position));
                    groupTemp.addLocus(locusTemp);
                    continue;
                }
                if (line.startsWith("group")) {
                    String nameGroup = line.substring(line.lastIndexOf(" ") + 1);
                    groupTemp = new LGroup(nameGroup, map);
                    map.addGroup(groupTemp);
                    groupflag = true;
                    qtlflag = false;
                    continue;
                }
                if (!qtlflag || line.equals("") || line.startsWith("qtls")) continue;
                st = new StringTokenizer(line);
                nameLocus = st.nextToken();
                double from = Double.parseDouble(st.nextToken());
                position = Double.parseDouble(st.nextToken());
                st.nextToken();
                double to = Double.parseDouble(st.nextToken());
                locusTemp = Locus.newLocus(1);
                locusTemp.setGroup(groupTemp);
                locusTemp.setName(nameLocus);
                locusTemp.setPosition(new StaticLocusPosition(position));
                locusTemp.getProperties().put("qtl.from", "" + from);
                locusTemp.getProperties().put("qtl.to", "" + to);
                groupTemp.addLocus(locusTemp);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    public IBioEntity load(InputStream stream) throws IOException {
        InputStreamReader r = new InputStreamReader(stream);
        return this.load(r);
    }

    public void unload(IBioEntity obj, Writer w) throws IOException {
        GeneticMap map = (GeneticMap)obj;
        PrintWriter writer = new PrintWriter(w);
        int i = 0;
        while (i < map.groups().length) {
            writer.println("group " + map.groups()[i].getName());
            IBioLocus[] loci = BioUtilities.sortLociByPosition(map.groups()[i].loci());
            int nqtl = 0;
            int j = 0;
            while (j < loci.length) {
                if (loci[j].getLocusType() == 0) {
                    writer.println(String.valueOf(loci[j].getName()) + " " + NumberFormat.formatDouble(loci[j].getPosition().absolute()));
                } else if (loci[j].getLocusType() == 1) {
                    ++nqtl;
                }
                ++j;
            }
            if (nqtl > 0) {
                writer.println("qtls");
                j = 0;
                while (j < loci.length) {
                    if (loci[j].getLocusType() == 1) {
                        double pos = loci[j].getPosition().absolute();
                        try {
                            double from = Double.parseDouble(loci[j].getProperties().getProperty("qtl.ic.from"));
                            double to = Double.parseDouble(loci[j].getProperties().getProperty("qtl.ic.to"));
                            writer.println(String.valueOf(loci[j].getName()) + " " + from + " " + pos + " " + pos + " " + to);
                        }
                        catch (Exception e) {
                            writer.println(String.valueOf(loci[j].getName()) + " " + pos + " " + pos + " " + pos + " " + pos);
                        }
                    }
                    ++j;
                }
            }
            writer.println();
            ++i;
        }
        try {
            w.flush();
            w.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void unload(IBioEntity obj, OutputStream stream) throws IOException {
        this.unload(obj, new OutputStreamWriter(stream));
    }
}

