/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.bio.entity.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.StringTokenizer;
import org.metaqtl.bio.IBioEntity;
import org.metaqtl.bio.entity.GeneticMap;
import org.metaqtl.bio.entity.LGroup;
import org.metaqtl.bio.entity.Marker;
import org.metaqtl.bio.entity.factory.BioEntityFactory;
import org.metaqtl.bio.util.LGroupPosition;

public class MapRawFactory
extends BioEntityFactory {
    public IBioEntity load(InputStream inputStream) throws IOException {
        GeneticMap map = new GeneticMap();
        LGroup group = null;
        Marker mrk = null;
        InputStreamReader reader = new InputStreamReader(inputStream);
        BufferedReader buffer = new BufferedReader(reader);
        try {
            String line;
            while ((line = buffer.readLine()) != null) {
                double pos;
                String name;
                StringTokenizer st;
                if (line.startsWith("chrom")) {
                    st = new StringTokenizer(line);
                    st.nextToken();
                    name = st.nextToken();
                    group = new LGroup(name, map);
                    map.addGroup(group);
                    continue;
                }
                if (group == null) continue;
                st = new StringTokenizer(line);
                name = st.nextToken();
                String posStr = st.nextToken();
                try {
                    pos = Double.parseDouble(posStr);
                }
                catch (NumberFormatException e1) {
                    try {
                        pos = Double.parseDouble(posStr.replace(',', '.'));
                    }
                    catch (NumberFormatException e2) {
                        pos = 0.0;
                    }
                }
                mrk = new Marker(name, group);
                mrk.setPosition(LGroupPosition.newStaticLocusPosition(pos));
                group.addLocus(mrk);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    public IBioEntity load(Reader reader) throws IOException {
        return null;
    }

    public void unload(IBioEntity entity, Writer writer) throws IOException {
    }

    public void unload(IBioEntity entity, OutputStream stream) throws IOException {
    }
}

