/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.bio.entity.factory;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.metaqtl.bio.IBioEntity;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioLGroup;
import org.metaqtl.bio.IBioLocus;
import org.metaqtl.bio.entity.GeneticMap;
import org.metaqtl.bio.entity.LGroup;
import org.metaqtl.bio.entity.Locus;
import org.metaqtl.bio.entity.factory.BioEntityFactory;
import org.metaqtl.bio.util.BioLocusTypes;
import org.metaqtl.bio.util.NumberFormat;
import org.metaqtl.bio.util.TabulatedReader;
import org.metaqtl.bio.util.TabulatedWriter;

public class MapTabFactory
extends BioEntityFactory {
    private void writeObject(GeneticMap map, TabulatedWriter writer) {
        String[] keys = this.getColumnNames(map);
        String[] values = new String[keys.length];
        writer.setKeys(keys);
        IBioLGroup[] groups = map.groups();
        this.sortGroup(groups);
        int i = 0;
        while (i < groups.length) {
            IBioLocus[] loci = groups[i].loci();
            this.sortPosition(loci);
            int j = 0;
            while (j < loci.length) {
                int l = 0;
                if (map.getName() != null) {
                    values[l++] = map.getName();
                }
                values[l++] = groups[i].getName();
                values[l++] = loci[j].getName();
                values[l++] = BioLocusTypes.typeToString(loci[j].getLocusType());
                values[l++] = NumberFormat.formatDouble(loci[j].getPosition().absolute());
                while (l < values.length) {
                    values[l] = "";
                    ++l;
                }
                Properties properties = loci[j].getProperties();
                if (properties != null) {
                    Enumeration<Object> e = properties.keys();
                    while (e.hasMoreElements()) {
                        int idx = this.getKeyIdx((String)e.nextElement(), keys);
                        if (idx < 0) continue;
                        values[idx] = properties.getProperty(keys[idx]);
                    }
                }
                writer.nextValues(values);
                ++j;
            }
            ++i;
        }
    }

    private int getKeyIdx(String string, String[] keys) {
        int i = 0;
        while (i < keys.length) {
            if (keys[i].equals(string)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private String[] getColumnNames(GeneticMap map) {
        Enumeration<Object> e;
        int j;
        Hashtable<String, String> keys = null;
        IBioLGroup[] groups = map.groups();
        int i = 0;
        while (i < groups.length) {
            IBioLocus[] loci = groups[i].loci();
            j = 0;
            while (j < loci.length) {
                Properties properties = loci[j].getProperties();
                if (properties != null) {
                    if (keys == null) {
                        keys = new Hashtable<String, String>();
                    }
                    e = properties.keys();
                    while (e.hasMoreElements()) {
                        keys.put((String)e.nextElement(), " ");
                    }
                }
                ++j;
            }
            ++i;
        }
        int size = 4;
        if (map.getName() != null) {
            ++size;
        }
        String[] keysStrs = new String[size += keys.size()];
        j = 0;
        if (map.getName() != null) {
            keysStrs[j++] = "map";
        }
        keysStrs[j++] = "group";
        keysStrs[j++] = "locus";
        keysStrs[j++] = "type";
        keysStrs[j++] = "position";
        e = keys.keys();
        while (e.hasMoreElements()) {
            keysStrs[j] = (String)e.nextElement();
            ++j;
        }
        return keysStrs;
    }

    private IBioGenome readObject(TabulatedReader tabReader) throws IOException {
        Hashtable<String, LGroup> groups = new Hashtable<String, LGroup>();
        Object mapName = null;
        Set keys = tabReader.getKeys();
        GeneticMap map = new GeneticMap();
        while (tabReader.hasNext()) {
            LGroup group;
            String value;
            if (mapName == null && tabReader.get("map") != null) {
                map.setName(tabReader.get("map"));
            }
            if (!groups.containsKey(value = tabReader.get("group"))) {
                group = new LGroup(value, map);
                map.addGroup(group);
                groups.put(value, group);
            } else {
                group = (LGroup)groups.get(value);
            }
            Locus locus = null;
            if (tabReader.containsKey("type")) {
                value = tabReader.get("type");
                locus = Locus.newLocus(BioLocusTypes.parseType(value));
                value = tabReader.get("locus");
                locus.setName(value);
            } else if (tabReader.containsKey("marker")) {
                locus = Locus.newLocus(0);
                value = tabReader.get("marker");
                locus.setName(value);
            } else if (tabReader.containsKey("qtl")) {
                locus = Locus.newLocus(1);
                value = tabReader.get("qtl");
                locus.setName(value);
            }
            if (locus != null) {
                value = tabReader.get("position");
                locus.setPosition(MapTabFactory.parseDouble(value));
                Properties prop = locus.getProperties();
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    if (key.compareTo("group") == 0 || key.compareTo("locus") == 0 || key.compareTo("map") == 0 || key.compareTo("type") == 0 || key.compareTo("position") == 0) continue;
                    if (tabReader.get(key) != null) {
                        prop.setProperty(key, tabReader.get(key));
                        continue;
                    }
                    prop.setProperty(key, "");
                }
                locus.setProperties(prop);
                group.addLocus(locus);
                continue;
            }
            throw new IOException("Bad Header Format");
        }
        return map;
    }

    public void unload(IBioEntity obj, Writer writer) throws IOException {
        TabulatedWriter twriter = new TabulatedWriter(writer);
        this.writeObject((GeneticMap)obj, twriter);
        writer.close();
    }

    public IBioEntity load(Reader reader) throws IOException {
        return this.readObject(new TabulatedReader(reader));
    }

    private static double parseDouble(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e1) {
            try {
                return Double.parseDouble(value.replace(',', '.'));
            }
            catch (NumberFormatException e2) {
                return 0.0;
            }
        }
    }

    private void sortPosition(IBioLocus[] loci) {
        int N = loci.length;
        int i = 0;
        while (i < N - 1) {
            int min = i;
            int j = i + 1;
            while (j < N) {
                if (loci[j].getPosition().absolute() < loci[min].getPosition().absolute()) {
                    min = j;
                }
                ++j;
            }
            IBioLocus t = loci[min];
            loci[min] = loci[i];
            loci[i] = t;
            ++i;
        }
    }

    private void sortGroup(IBioLGroup[] groups) {
        int N = groups.length;
        int i = 0;
        while (i < N - 1) {
            int min = i;
            int j = i + 1;
            while (j < N) {
                if (groups[j].getName().compareTo(groups[min].getName()) < 0) {
                    min = j;
                }
                ++j;
            }
            IBioLGroup t = groups[min];
            groups[min] = groups[i];
            groups[i] = t;
            ++i;
        }
    }

    public IBioEntity load(InputStream stream) throws IOException {
        return this.load(new InputStreamReader(stream));
    }

    public void unload(IBioEntity entity, OutputStream stream) throws IOException {
        this.unload(entity, new OutputStreamWriter(stream));
    }
}

