/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.StringTokenizer;
import org.metaqtl.EMCriteria;
import org.metaqtl.EMResult;
import org.metaqtl.bio.util.NumberFormat;

public class EMResultFactory {
    public static EMResult read(BufferedReader buffer) throws IOException {
        String line;
        if (buffer == null) {
            return null;
        }
        EMResult emResult = new EMResult();
        int n = 0;
        block8: while ((line = buffer.readLine()) != null) {
            if (line.length() < 2) continue;
            switch (line.charAt(0)) {
                case 'C': {
                    switch (line.charAt(1)) {
                        case 'L': {
                            StringTokenizer tokenizer = new StringTokenizer(line.substring(3));
                            n = Integer.parseInt(tokenizer.nextToken());
                            int k = Integer.parseInt(tokenizer.nextToken());
                            emResult = new EMResult(n, k);
                            emResult.olog = NumberFormat.parseDouble(tokenizer.nextToken());
                            emResult.clog = NumberFormat.parseDouble(tokenizer.nextToken());
                            k = 0;
                            n = 0;
                            break;
                        }
                        case 'P': {
                            int k;
                            StringTokenizer tokenizer = new StringTokenizer(line.substring(3));
                            String type = tokenizer.nextToken();
                            if (type.equals("MU")) {
                                k = 0;
                                while (k < emResult.k) {
                                    emResult.mu[k] = NumberFormat.parseDouble(tokenizer.nextToken());
                                    ++k;
                                }
                                continue block8;
                            }
                            if (type.equals("PI")) {
                                k = 0;
                                while (k < emResult.k) {
                                    emResult.pi[k] = NumberFormat.parseDouble(tokenizer.nextToken());
                                    ++k;
                                }
                                continue block8;
                            }
                            if (type.equals("CI")) {
                                k = 0;
                                while (k < emResult.k) {
                                    emResult.ocov[k][k] = NumberFormat.parseDouble(tokenizer.nextToken()) / 3.92;
                                    double[] dArray = emResult.ocov[k];
                                    int n2 = k;
                                    dArray[n2] = dArray[n2] * emResult.ocov[k][k];
                                    ++k;
                                }
                                continue block8;
                            }
                            if (!type.equals("Z")) break;
                            tokenizer.nextToken();
                            k = 0;
                            while (k < emResult.k) {
                                emResult.z[k][n] = NumberFormat.parseDouble(tokenizer.nextToken());
                                ++k;
                            }
                            if (++n != emResult.n) break;
                            return emResult;
                        }
                        case 'C': {
                            if (emResult.criteria == null) {
                                emResult.criteria = new EMCriteria();
                            }
                            StringTokenizer tokenizer = new StringTokenizer(line.substring(3));
                            String criterion = tokenizer.nextToken();
                            double value = NumberFormat.parseDouble(tokenizer.nextToken());
                            if (criterion.equals("AIC")) {
                                emResult.criteria.aic = value;
                                break;
                            }
                            if (criterion.equals("AIC3")) {
                                emResult.criteria.aic3 = value;
                                break;
                            }
                            if (criterion.equals("ICOMP")) {
                                emResult.criteria.icomp = value;
                                break;
                            }
                            if (criterion.equals("BIC")) {
                                emResult.criteria.bic = value;
                                break;
                            }
                            if (!criterion.equals("AWE")) break;
                            emResult.criteria.awe = value;
                            break;
                        }
                    }
                    continue block8;
                }
            }
        }
        return emResult;
    }

    public static void write(EMResult result, OutputStream stream) throws IOException {
        if (result == null) {
            return;
        }
        if (stream == null) {
            return;
        }
        PrintWriter writer = new PrintWriter(stream);
        EMResultFactory.write(result, writer);
    }

    public static void write(EMResult result, PrintWriter writer) {
        writer.println("CL " + result.n + " " + result.k + " " + NumberFormat.formatDouble(result.olog) + " " + NumberFormat.formatDouble(result.clog));
        writer.println("CC AIC " + NumberFormat.formatDouble(result.criteria.aic));
        writer.println("CC AIC3 " + NumberFormat.formatDouble(result.criteria.aic3));
        writer.println("CC ICOMP " + NumberFormat.formatDouble(result.criteria.icomp));
        writer.println("CC BIC " + NumberFormat.formatDouble(result.criteria.bic));
        writer.println("CC AWE " + NumberFormat.formatDouble(result.criteria.awe));
        writer.print("CP PI ");
        int k = 0;
        while (k < result.k - 1) {
            writer.print(String.valueOf(NumberFormat.formatDouble(result.pi[k])) + " ");
            ++k;
        }
        writer.println(NumberFormat.formatDouble(result.pi[k]));
        writer.print("CP MU ");
        k = 0;
        while (k < result.k - 1) {
            writer.print(String.valueOf(NumberFormat.formatDouble(result.mu[k])) + " ");
            ++k;
        }
        writer.println(NumberFormat.formatDouble(result.mu[k]));
        if (result.ocov != null) {
            writer.print("CP CI ");
            k = 0;
            while (k < result.k - 1) {
                writer.print(String.valueOf(NumberFormat.formatDouble(Math.sqrt(result.ocov[k][k]) * 3.92)) + " ");
                ++k;
            }
        }
        writer.println(NumberFormat.formatDouble(result.ocov[k][k]));
        int n = 0;
        while (n < result.n) {
            writer.print("CP Z " + n + " ");
            k = 0;
            while (k < result.k - 1) {
                writer.print(String.valueOf(NumberFormat.formatDouble(result.z[k][n])) + " ");
                ++k;
            }
            writer.println(NumberFormat.formatDouble(result.z[k][n]));
            ++n;
        }
        writer.flush();
    }
}

