/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.factory;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.StringTokenizer;
import org.metaqtl.graph.MetaGraphPar;

public final class MetaGraphParFactory {
    public static void update(Reader reader) throws IOException {
        String line;
        if (reader == null) {
            return;
        }
        int nl = 0;
        BufferedReader buffer = new BufferedReader(reader);
        while ((line = buffer.readLine()) != null) {
            ++nl;
            line.replace(" ", "");
            if (line.startsWith("#")) continue;
            StringTokenizer tokenizer = new StringTokenizer(line, "=", false);
            if (tokenizer.countTokens() == 2) {
                String parameter = tokenizer.nextToken();
                String value = tokenizer.nextToken();
                try {
                    MetaGraphPar.set(parameter, value);
                }
                catch (IllegalArgumentException e) {
                    System.out.println(e.getMessage());
                }
                continue;
            }
            throw new IOException("[ ERROR ] : Bad graphical parameter line " + nl);
        }
    }

    public static void write(OutputStream stream) {
        MetaGraphParFactory.write(new PrintWriter(stream));
    }

    public static void write(Writer writer) {
        MetaGraphParFactory.write(new PrintWriter(writer));
    }

    private static void write(PrintWriter writer) {
        writer.println("#");
        writer.println("# This file was automatically generated by MetaQTL");
        writer.println("#");
        writer.println("#");
        writer.println("# Graphical Parameters");
        writer.println("#");
        writer.println("# CHROMOSOME");
        writer.println("#");
        writer.println("CHROM_DISTANCE_SCALE=" + MetaGraphPar.CHROM_DISTANCE_SCALE);
        writer.println("CHROM_FLANKING_CEX=" + MetaGraphPar.CHROM_FLANKING_CEX);
        writer.println("CHROM_NAME_FONT=" + MetaGraphPar.font2string(MetaGraphPar.CHROM_NAME_FONT));
        writer.println("CHROM_NAME_HSPACE=" + MetaGraphPar.CHROM_NAME_HSPACE);
        writer.println("CHROM_TICK_WIDTH_1=" + MetaGraphPar.CHROM_TICK_WIDTH_1);
        writer.println("CHROM_TICK_WIDTH_2=" + MetaGraphPar.CHROM_TICK_WIDTH_2);
        writer.println("CHROM_TICK_WIDTH_3=" + MetaGraphPar.CHROM_TICK_WIDTH_3);
        writer.println("CHROM_WIDTH=" + MetaGraphPar.CHROM_WIDTH);
        writer.println("CHROM_ALIGN_MODE=" + MetaGraphPar.CHROM_ALIGN_MODE);
        writer.println("MAKER_NAME_VSPACE=" + MetaGraphPar.MAKER_NAME_VSPACE);
        writer.println("MARKER_NAME_FONT=" + MetaGraphPar.font2string(MetaGraphPar.MARKER_NAME_FONT));
        writer.println("MARKER_POSITION_FONT=" + MetaGraphPar.font2string(MetaGraphPar.MARKER_POSITION_FONT));
        writer.println("COMMON_STROKE_WIDTH=" + MetaGraphPar.COMMON_STROKE_WIDTH);
        writer.println("#");
        writer.println("# QTL");
        writer.println("#");
        writer.println("QTL_CI_WIDTH=" + MetaGraphPar.QTL_CI_WIDTH);
        writer.println("QTL_CI_WIDTH_CEX=" + MetaGraphPar.QTL_CI_WIDTH_CEX);
        writer.println("QTL_HSPACE=" + MetaGraphPar.QTL_HSPACE);
        writer.println("QTL_NAME_FONT=" + MetaGraphPar.font2string(MetaGraphPar.QTL_NAME_FONT));
        writer.println("QTL_NAME_VSPACE_CEX=" + MetaGraphPar.QTL_NAME_VSPACE_CEX);
        writer.println("QTL_POS_HEIGHT_CEX=" + MetaGraphPar.QTL_POS_HEIGHT_CEX);
        writer.println("QTL_POS_WIDTH_CEX=" + MetaGraphPar.QTL_POS_WIDTH_CEX);
        writer.println("QTL_PROB_WIDTH=" + MetaGraphPar.QTL_PROB_WIDTH);
        writer.println("QTL_TICK_WIDTH_CEX=" + MetaGraphPar.QTL_TICK_WIDTH_CEX);
        writer.println("QTL_TREE_SPACE=" + MetaGraphPar.QTL_TREE_SPACE);
        writer.println("QTL_TREE_SCALE=" + MetaGraphPar.QTL_TREE_SCALE);
        writer.println("QTL_VSPACE=" + MetaGraphPar.QTL_VSPACE);
        writer.println("#");
        writer.println("# LEGEND");
        writer.println("#");
        writer.println("LEGEND_BOX_CEX=" + MetaGraphPar.LEGEND_BOX_CEX);
        writer.println("LEGEND_FONT=" + MetaGraphPar.font2string(MetaGraphPar.LEGEND_FONT));
        writer.println("LEGEND_HSPACE=" + MetaGraphPar.LEGEND_HSPACE);
        writer.println("LEGEND_PART_HEIGHT=" + MetaGraphPar.LEGEND_PART_HEIGHT);
        writer.println("LEGEND_PART_WIDTH=" + MetaGraphPar.LEGEND_PART_WIDTH);
        writer.println("LEGEND_SCALE_UNIT=" + MetaGraphPar.LEGEND_SCALE_UNIT);
        writer.println("LEGEND_GRAD_HEIGHT=" + MetaGraphPar.LEGEND_GRAD_HEIGHT);
        writer.println("LEGEND_GRAD_WIDTH=" + MetaGraphPar.LEGEND_GRAD_WIDTH);
        writer.println("#");
        writer.println("# COLOR PALETTE");
        writer.println("#");
        if (MetaGraphPar.PROBA_PALETTE != null) {
            writer.println("PROBA_BIN=" + MetaGraphPar.PROBA_BIN);
            writer.println("PROBA_FROM_COLOR=" + MetaGraphPar.color2string(MetaGraphPar.PROBA_PALETTE[0]));
            writer.println("PROBA_TO_COLOR=" + MetaGraphPar.color2string(MetaGraphPar.PROBA_PALETTE[MetaGraphPar.PROBA_BIN - 1]));
        }
        if (MetaGraphPar.QTL_PALETTE != null) {
            int i = 0;
            while (i < MetaGraphPar.QTL_PALETTE.length) {
                writer.println("QTL_COLOR_" + (i + 1) + "=" + MetaGraphPar.color2string(MetaGraphPar.QTL_PALETTE[i]));
                ++i;
            }
        }
        writer.println("SINGLE_COMMON_COLOR=" + MetaGraphPar.color2string(MetaGraphPar.SINGLE_COMMON_COLOR));
        writer.println("POS_COMMON_COLOR=" + MetaGraphPar.color2string(MetaGraphPar.POS_COMMON_COLOR));
        writer.println("NEG_COMMON_COLOR=" + MetaGraphPar.color2string(MetaGraphPar.NEG_COMMON_COLOR));
        writer.println("#");
        writer.println("# OTHER");
        writer.println("#");
        writer.println("BACKGROUND_COLOR=" + MetaGraphPar.color2string(MetaGraphPar.BACKGROUND_COLOR));
        writer.println("LAYER_HSPACE=" + MetaGraphPar.LAYER_HSPACE);
        writer.println("LAYER_VSPACE=" + MetaGraphPar.LAYER_VSPACE);
        writer.println("WITH_CHROM_NAME=" + MetaGraphPar.WITH_CHROM_NAME);
        writer.println("WITH_COMMON_MARKER=" + MetaGraphPar.WITH_COMMON_MARKER);
        writer.println("WITH_LEGEND=" + MetaGraphPar.WITH_LEGEND);
        writer.println("WITH_MAP_NAME=" + MetaGraphPar.WITH_MAP_NAME);
        writer.println("WITH_MARKER_NAME=" + MetaGraphPar.WITH_MARKER_NAME);
        writer.println("WITH_QTL_NAME=" + MetaGraphPar.WITH_QTL_NAME);
        writer.println("WITH_MARKER_POSITION=" + MetaGraphPar.WITH_MARKER_POSITION);
        writer.println("#");
        writer.println("# AVAILABLE FONTS");
        writer.println("#");
        GraphicsEnvironment graphEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Font[] fonts = graphEnv.getAllFonts();
        int i = 0;
        while (i < fonts.length) {
            writer.println("# " + MetaGraphPar.font2string(fonts[i]));
            ++i;
        }
        writer.flush();
    }
}

