/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.metaqtl.MetaQtlModel;

public class MetaQtlModelFactory {
    public static final String SEPARATOR = "\t";

    public static MetaQtlModel read(Reader reader) throws IOException {
        int model;
        String chromName;
        String traitName;
        int i;
        if (reader == null) {
            return null;
        }
        BufferedReader buffer = null;
        StringTokenizer token = null;
        String line = null;
        String sbuff = null;
        Hashtable<String, Hashtable> chromHash = null;
        Hashtable traitHash = null;
        MetaQtlModel metaModel = null;
        buffer = new BufferedReader(reader);
        line = buffer.readLine();
        if (line == null) {
            return null;
        }
        token = new StringTokenizer(line, SEPARATOR);
        int midx = -1;
        int tidx = -1;
        int cidx = -1;
        if (token.countTokens() >= 1) {
            i = 0;
            while (token.hasMoreTokens()) {
                sbuff = token.nextToken();
                if (sbuff.equalsIgnoreCase("Chromosome")) {
                    cidx = i;
                }
                if (sbuff.equalsIgnoreCase("Trait")) {
                    tidx = i;
                }
                if (sbuff.equalsIgnoreCase("Model")) {
                    midx = i;
                }
                ++i;
            }
            if (cidx == -1 || tidx == -1 || midx == -1) {
                throw new IOException("Bad header format");
            }
        } else {
            throw new IOException("Bad header format");
        }
        int cnt = 1;
        while ((line = buffer.readLine()) != null) {
            token = new StringTokenizer(line);
            if (token.countTokens() >= 1) {
                i = 0;
                traitName = null;
                chromName = null;
                model = 0;
                while (token.hasMoreTokens()) {
                    if (i == cidx) {
                        chromName = token.nextToken();
                    } else if (i == tidx) {
                        traitName = token.nextToken();
                    } else if (i == midx) {
                        model = Integer.parseInt(token.nextToken());
                    }
                    ++i;
                }
                if (chromName == null || traitName == null || model == 0) {
                    throw new IOException("Bad line format at " + cnt);
                }
                if (chromHash == null) {
                    chromHash = new Hashtable<String, Hashtable>();
                }
                if (!chromHash.containsKey(chromName)) {
                    traitHash = new Hashtable();
                    chromHash.put(chromName, traitHash);
                } else {
                    traitHash = (Hashtable)chromHash.get(chromName);
                }
            } else {
                throw new IOException("Bad line format at " + cnt);
            }
            traitHash.put(traitName, new Integer(model));
            ++cnt;
        }
        buffer.close();
        reader.close();
        if (chromHash != null) {
            metaModel = new MetaQtlModel();
            metaModel.chromNames = new String[chromHash.size()];
            metaModel.traitNames = new String[chromHash.size()][];
            metaModel.models = new int[chromHash.size()][];
            Enumeration e = chromHash.keys();
            i = 0;
            while (e.hasMoreElements()) {
                chromName = (String)e.nextElement();
                traitHash = (Hashtable)chromHash.get(chromName);
                metaModel.chromNames[i] = chromName;
                metaModel.traitNames[i] = new String[traitHash.size()];
                metaModel.models[i] = new int[traitHash.size()];
                Enumeration e1 = traitHash.keys();
                int j = 0;
                while (e1.hasMoreElements()) {
                    traitName = (String)e1.nextElement();
                    model = (Integer)traitHash.get(traitName);
                    metaModel.traitNames[i][j] = traitName;
                    metaModel.models[i][j] = model;
                    ++j;
                }
                ++i;
            }
        }
        return metaModel;
    }

    public static void write(MetaQtlModel model, OutputStream stream) {
        if (model == null) {
            return;
        }
        if (stream == null) {
            return;
        }
        PrintWriter writer = new PrintWriter(stream);
        MetaQtlModelFactory.write(model, writer);
    }

    public static void write(MetaQtlModel model, Writer writer) {
        if (model == null) {
            return;
        }
        if (writer == null) {
            return;
        }
        PrintWriter pw = new PrintWriter(writer);
        String criterion = model.getCriterion();
        String[] chrom = model.getChromNames();
        if (criterion != null) {
            pw.print("Criterion");
            pw.print(SEPARATOR);
        }
        pw.print("Chromosome");
        pw.print(SEPARATOR);
        pw.print("Trait");
        pw.print(SEPARATOR);
        pw.print("Model");
        pw.println();
        int i = 0;
        while (i < chrom.length) {
            String[] traits = model.getTraitNames(i);
            int j = 0;
            while (j < traits.length) {
                int k = model.getModel(i, j);
                if (criterion != null) {
                    pw.print(criterion);
                    pw.print(SEPARATOR);
                }
                pw.print(chrom[i]);
                pw.print(SEPARATOR);
                pw.print(traits[j]);
                pw.print(SEPARATOR);
                pw.print(k);
                pw.println();
                pw.flush();
                ++j;
            }
            ++i;
        }
    }
}

