/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.graph;

public class ChromAxe {
    private double length = 0.0;
    private double scale = 0.0;
    private double yMin = 0.0;
    private double yMax = 0.0;
    private double x = 0.0;

    public ChromAxe(double yMin, double yMax, double length) {
        this.yMin = yMin;
        this.yMax = yMax;
        this.length = length;
        this.scale = (yMax - yMin) / length;
    }

    public double getYMax() {
        return this.yMax;
    }

    public void setYMax(double max) {
        this.yMax = max;
    }

    public double getYMin() {
        return this.yMin;
    }

    public void setYMin(double min) {
        this.yMin = min;
    }

    public double getHeight() {
        return this.yMax - this.yMin;
    }

    public double transformY(double d) {
        return this.yMin + this.scale * d;
    }

    public double scaleY(double d) {
        return this.scale * d;
    }

    public double scaleHeight(double h) {
        return h * this.scale;
    }

    public void scale(double sy) {
        this.yMin *= sy;
        this.yMax *= sy;
        this.scale = (this.yMax - this.yMin) / this.length;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }
}

