/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.metaqtl.graph.ChromGraph;
import org.metaqtl.graph.ChromLayer;
import org.metaqtl.graph.Layer;
import org.metaqtl.graph.MetaGraphPar;
import org.metaqtl.graph.QtlPartitionLayer;

public class MetaGraph {
    private double height;
    private double width;
    private double sx;
    private double sy;
    public DataLayer[] dataLayers = null;
    public CrossLayer[] crossLayers = null;
    public LegendLayer legendLayer = null;

    public void draw(Graphics2D graph, double x, double y) {
        int i;
        AffineTransform t = graph.getTransform();
        AffineTransform translate = new AffineTransform();
        translate.translate(x, y);
        graph.transform(translate);
        if (this.dataLayers != null) {
            i = 0;
            while (i < this.dataLayers.length) {
                this.dataLayers[i].draw(graph);
                ++i;
            }
        }
        if (this.crossLayers != null) {
            i = 0;
            while (i < this.crossLayers.length) {
                this.crossLayers[i].draw(graph);
                ++i;
            }
        }
        if (this.legendLayer != null) {
            this.legendLayer.draw(graph);
        }
        graph.setTransform(t);
    }

    private void initColor() {
        MetaGraphPar.initPalettes();
        int np = this.getQtlPartNames().size();
        if (MetaGraphPar.QTL_PALETTE == null || MetaGraphPar.QTL_PALETTE.length < np) {
            MetaGraphPar.initQTLPalette(np);
        }
    }

    private ArrayList getQtlPartNames() {
        int i = 0;
        while (i < this.dataLayers.length) {
            ArrayList p = this.dataLayers[i].getQtlPartNames();
            if (p != null && p.size() > 0) {
                return p;
            }
            ++i;
        }
        return new ArrayList();
    }

    public void init(Graphics2D graph, ChromGraph[] maps) {
        this.optimizeGraph(graph);
        this.initDataLayers(maps.length);
        boolean hasProba = false;
        int i = 0;
        while (i < maps.length) {
            this.dataLayers[i].attach(maps[i]);
            this.dataLayers[i].build(graph);
            hasProba |= this.dataLayers[i].hasProba();
            ++i;
        }
        this.organizeDataLayers();
        this.crossDataLayers(graph);
        this.initColor();
        if (MetaGraphPar.WITH_LEGEND) {
            this.height += MetaGraphPar.LAYER_VSPACE;
            this.legendLayer(graph, 0.0, this.height, hasProba);
        }
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    private void initDataLayers(int nlayer) {
        this.dataLayers = new DataLayer[nlayer];
        int i = 0;
        while (i < nlayer) {
            this.dataLayers[i] = new DataLayer(0.0, 0.0);
            ++i;
        }
    }

    private void organizeDataLayers() {
        double y_min = 0.0;
        this.width = 0.0;
        this.height = 0.0;
        int i = 0;
        while (i < this.dataLayers.length) {
            this.dataLayers[i].align(this.dataLayers[0], MetaGraphPar.CHROM_ALIGN_MODE);
            if (this.dataLayers[i].getYMin() < y_min) {
                y_min = this.dataLayers[i].getYMin();
            }
            ++i;
        }
        i = 0;
        while (i < this.dataLayers.length) {
            this.height = Math.max(this.height, Math.abs(this.dataLayers[i].getYMin()) + this.dataLayers[i].getHeight());
            this.dataLayers[i].position(this.width, -y_min);
            this.width += this.dataLayers[i].getWidth();
            if (i < this.dataLayers.length - 1) {
                this.width += MetaGraphPar.LAYER_VSPACE;
            }
            ++i;
        }
    }

    private void crossDataLayers(Graphics2D graph) {
        this.crossLayers = new CrossLayer[this.dataLayers.length - 1];
        int i = 0;
        while (i < this.dataLayers.length - 1) {
            this.crossLayers[i] = new CrossLayer(0.0, 0.0);
            this.crossLayers[i].attach(this.getCrossData(this.dataLayers[i], this.dataLayers[i + 1]));
            this.crossLayers[i].build(graph);
            ++i;
        }
    }

    private void legendLayer(Graphics2D graph, double xx, double yy, boolean withProba) {
        LegendData legendData = new LegendData();
        legendData.mapScale = MetaGraphPar.CHROM_DISTANCE_SCALE;
        ArrayList t = this.getQtlPartNames();
        legendData.partNames = new String[t.size()];
        int i = 0;
        while (i < t.size()) {
            legendData.partNames[i] = (String)t.get(i);
            ++i;
        }
        legendData.partColors = MetaGraphPar.QTL_PALETTE;
        if (withProba) {
            legendData.gColors = MetaGraphPar.PROBA_PALETTE;
            legendData.gmin = 0.0;
            legendData.gmax = 1.0;
        }
        this.legendLayer = new LegendLayer(xx, yy);
        this.legendLayer.attach(legendData);
        this.legendLayer.build(graph);
        this.height += this.legendLayer.getHeight();
        this.width = Math.max(this.width, this.legendLayer.getWidth());
    }

    private CrossData getCrossData(DataLayer layer1, DataLayer layer2) {
        CrossData cross = new CrossData();
        if (MetaGraphPar.WITH_COMMON_MARKER) {
            cross.cMrkPaths = layer1.getCommonMarkerPaths(layer2);
        }
        return cross;
    }

    private void optimizeGraph(Graphics2D graph) {
        graph.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graph.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graph.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graph.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    private class CrossData {
        ChromLayer.CMrkTickPath[] cMrkPaths;

        CrossData() {
        }
    }

    private class CrossLayer
    extends Layer {
        private CrossData crossData;

        public CrossLayer(double x, double y) {
            super(x, y);
        }

        public void attach(Object object) {
            if (object instanceof CrossData) {
                this.crossData = (CrossData)object;
            }
        }

        public void build(Graphics2D graph) {
        }

        public void draw(Graphics2D graph) {
            if (this.crossData != null) {
                Color c = graph.getColor();
                AffineTransform t = graph.getTransform();
                AffineTransform trans = new AffineTransform();
                trans.translate(this.x, this.y);
                graph.transform(trans);
                ChromLayer.CMrkTickPath[] paths = this.crossData.cMrkPaths;
                if (paths != null) {
                    int i = 0;
                    while (i < paths.length) {
                        graph.setStroke(new BasicStroke((float)MetaGraphPar.COMMON_STROKE_WIDTH));
                        switch (paths[i].status) {
                            case 2: {
                                graph.setColor(MetaGraphPar.SINGLE_COMMON_COLOR);
                                break;
                            }
                            case 0: {
                                graph.setColor(MetaGraphPar.POS_COMMON_COLOR);
                                break;
                            }
                            case 1: {
                                graph.setColor(MetaGraphPar.NEG_COMMON_COLOR);
                            }
                        }
                        graph.draw(paths[i].path);
                        ++i;
                    }
                }
                graph.setTransform(t);
                graph.setColor(c);
            }
        }

        public double getYMin() {
            return 0.0;
        }

        public double getYMax() {
            return 0.0;
        }
    }

    private class DataLayer
    extends Layer {
        public ChromLayer chromLayer;
        public QtlPartitionLayer qtlPartLayer;
        public QtlPartitionLayer qtlPartLayer2;

        public DataLayer(double x, double y) {
            super(x, y);
        }

        public boolean hasProba() {
            return this.chromLayer.hasProba();
        }

        public void setMrkLabelSide(int side) {
            this.chromLayer.setLabelSide(side);
        }

        public void attach(Object object) {
            if (object instanceof ChromGraph) {
                ChromGraph chromGraph = (ChromGraph)object;
                this.chromLayer = new ChromLayer(this.x, this.y);
                this.chromLayer.attach(chromGraph.chromosome);
                this.qtlPartLayer = new QtlPartitionLayer(this.x, this.y);
                this.qtlPartLayer.attach(chromGraph.qtlPart);
            }
        }

        public double getHeight() {
            return Math.max(this.chromLayer.getHeight(), this.qtlPartLayer.getHeight());
        }

        public double getWidth() {
            return this.chromLayer.getWidth() + MetaGraphPar.LAYER_VSPACE + this.qtlPartLayer.getWidth();
        }

        public double getYMin() {
            return Math.min(this.chromLayer.getYMin(), this.qtlPartLayer.getYMin());
        }

        public double getYMax() {
            return Math.min(this.chromLayer.getYMax(), this.qtlPartLayer.getYMax());
        }

        public void position(double x, double y) {
            this.chromLayer.setX(this.chromLayer.getX() + x);
            this.chromLayer.setY(this.chromLayer.getY() + y);
            this.qtlPartLayer.setX(x + this.qtlPartLayer.getX() + MetaGraphPar.LAYER_VSPACE + this.chromLayer.getWidth());
            this.qtlPartLayer.setY(this.qtlPartLayer.getY() + y);
        }

        public void align(DataLayer ref, int mode) {
            ChromLayer.alignChromLayers(ref.chromLayer, this.chromLayer, mode);
            this.qtlPartLayer.setY(this.chromLayer.getY());
        }

        public void build(Graphics2D graph) {
            this.buildChromLayer(graph);
            this.buildQtlPartLayer(graph);
        }

        public void draw(Graphics2D graph) {
            this.chromLayer.draw(graph);
            this.qtlPartLayer.draw(graph);
        }

        public ArrayList getQtlPartNames() {
            return this.qtlPartLayer.getQtlPartNames();
        }

        public ChromLayer.CMrkTickPoint[] getCommonMarkerPoints(DataLayer layer2) {
            if (this.chromLayer != null) {
                return this.chromLayer.getCommonMarkerPoints(layer2.chromLayer);
            }
            return null;
        }

        public ChromLayer.CMrkTickPath[] getCommonMarkerPaths(DataLayer layer2) {
            if (this.chromLayer != null) {
                return this.chromLayer.getCommonMarkerPaths(layer2.chromLayer);
            }
            return null;
        }

        private void buildChromLayer(Graphics2D graph) {
            if (this.chromLayer != null) {
                this.chromLayer.build(graph);
            }
        }

        private void buildQtlPartLayer(Graphics2D graph) {
            if (this.qtlPartLayer != null) {
                if (this.chromLayer != null) {
                    this.qtlPartLayer.setChromAxe(this.chromLayer.getChromAxe());
                }
                this.qtlPartLayer.build(graph);
            }
        }
    }

    private class LegendData {
        public double mapScale = 0.0;
        public String[] partNames;
        public Color[] partColors;
        public double gmin;
        public double gmax;
        public int gnc;
        public Color[] gColors;

        LegendData() {
        }
    }

    private class LegendLayer
    extends Layer {
        private LegendData legendData;
        private boolean withScale = false;
        private boolean withPart = false;
        private boolean withGrad = false;
        private double x_scale;
        private double y_scale;
        private double w_scale;
        private double h_scale;
        private double x_grad;
        private double y_grad;
        private double h_grad;
        private double w_grad;
        private double h_part;
        private double w_part;
        private double[] x_parts;
        private double[] y_parts;
        private TextLayout scaleTxt;
        private TextLayout gradMinTxt;
        private TextLayout gradMaxTxt;
        private TextLayout[] partTxts;

        public LegendLayer(double x, double y) {
            super(x, y);
        }

        public void attach(Object object) {
            if (object instanceof LegendData) {
                this.legendData = (LegendData)object;
            }
        }

        public void build(Graphics2D graph) {
            int i;
            if (this.legendData.mapScale > 0.0) {
                this.withScale = true;
                int unit = MetaGraphPar.LEGEND_SCALE_UNIT;
                String text = new String(String.valueOf(unit) + " cM");
                this.x_scale = 0.0;
                this.y_scale = 0.0;
                this.w_scale = (double)unit * this.legendData.mapScale;
                this.h_scale = MetaGraphPar.CHROM_TICK_WIDTH_1;
                this.scaleTxt = new TextLayout(text, MetaGraphPar.LEGEND_FONT, graph.getFontRenderContext());
                this.height = Math.max(this.h_scale, this.scaleTxt.getBounds().getHeight());
                this.width = this.w_scale * 1.1 + this.scaleTxt.getBounds().getWidth();
            }
            if (this.legendData.partNames != null) {
                this.height += MetaGraphPar.LEGEND_HSPACE;
                this.withPart = true;
                this.h_part = MetaGraphPar.LEGEND_PART_HEIGHT;
                this.w_part = MetaGraphPar.LEGEND_PART_WIDTH;
                this.partTxts = new TextLayout[this.legendData.partNames.length];
                this.x_parts = new double[this.partTxts.length];
                this.y_parts = new double[this.partTxts.length];
                i = 0;
                while (i < this.partTxts.length) {
                    this.y_parts[i] = this.height;
                    this.x_parts[i] = 0.0;
                    this.partTxts[i] = new TextLayout(this.legendData.partNames[i], MetaGraphPar.LEGEND_FONT, graph.getFontRenderContext());
                    this.height += Math.max(this.partTxts[i].getBounds().getHeight(), this.h_part);
                    this.height += MetaGraphPar.LEGEND_HSPACE;
                    this.width = Math.max(this.width, this.w_part * 1.1 + this.partTxts[i].getBounds().getWidth());
                    ++i;
                }
            }
            if (this.legendData.gColors != null) {
                this.height += MetaGraphPar.LEGEND_HSPACE;
                this.withGrad = true;
                this.y_grad = this.height;
                this.x_grad = 0.0;
                this.h_grad = MetaGraphPar.LEGEND_GRAD_HEIGHT;
                this.w_grad = MetaGraphPar.LEGEND_GRAD_WIDTH;
                this.gradMinTxt = new TextLayout(Double.toString(this.legendData.gmin), MetaGraphPar.LEGEND_FONT, graph.getFontRenderContext());
                this.gradMaxTxt = new TextLayout(Double.toString(this.legendData.gmax), MetaGraphPar.LEGEND_FONT, graph.getFontRenderContext());
                this.width = Math.max(this.width, this.gradMinTxt.getBounds().getWidth() + this.w_grad * 1.2 + this.gradMaxTxt.getBounds().getWidth());
                this.height += Math.max(this.h_grad, Math.max(this.gradMinTxt.getBounds().getHeight(), this.gradMaxTxt.getBounds().getHeight()));
            }
            if (this.withScale) {
                this.x_scale += this.width * MetaGraphPar.LEGEND_BOX_CEX / 2.0;
                this.y_scale += this.height * MetaGraphPar.LEGEND_BOX_CEX / 2.0;
            }
            if (this.withPart) {
                i = 0;
                while (i < this.x_parts.length) {
                    int n = i;
                    this.x_parts[n] = this.x_parts[n] + this.width * MetaGraphPar.LEGEND_BOX_CEX / 2.0;
                    int n2 = i++;
                    this.y_parts[n2] = this.y_parts[n2] + this.height * MetaGraphPar.LEGEND_BOX_CEX / 2.0;
                }
            }
            if (this.withGrad) {
                this.x_grad += this.width * MetaGraphPar.LEGEND_BOX_CEX / 2.0;
                this.y_grad += this.height * MetaGraphPar.LEGEND_BOX_CEX / 2.0;
            }
            this.width *= 1.0 + MetaGraphPar.LEGEND_BOX_CEX;
            this.height *= 1.0 + MetaGraphPar.LEGEND_BOX_CEX;
        }

        public void draw(Graphics2D graph) {
            if (this.legendData != null) {
                Color c = graph.getColor();
                AffineTransform t = graph.getTransform();
                AffineTransform trans = new AffineTransform();
                trans.translate(this.x, this.y);
                graph.transform(trans);
                graph.setStroke(new BasicStroke());
                if (this.withScale) {
                    graph.setColor(Color.BLACK);
                    Line2D.Double line = new Line2D.Double(this.x_scale, this.y_scale + this.h_scale / 2.0, this.x_scale + this.w_scale, this.y_scale + this.h_scale / 2.0);
                    graph.draw(line);
                    line.setLine(this.x_scale, this.y_scale, this.x_scale, this.y_scale + this.h_scale);
                    graph.draw(line);
                    line.setLine(this.x_scale + this.w_scale, this.y_scale, this.x_scale + this.w_scale, this.y_scale + this.h_scale);
                    graph.draw(line);
                    this.scaleTxt.draw(graph, (float)(this.x_scale + this.w_scale * 1.1), (float)(this.y_scale + this.scaleTxt.getBounds().getHeight()));
                    graph.setColor(Color.BLACK);
                }
                if (this.withPart) {
                    int i = 0;
                    while (i < this.x_parts.length) {
                        Rectangle2D.Double rect = new Rectangle2D.Double(this.x_parts[i], this.y_parts[i], this.w_part, this.h_part);
                        graph.setColor(this.legendData.partColors[i]);
                        graph.fill(rect);
                        graph.setColor(Color.BLACK);
                        this.partTxts[i].draw(graph, (float)(this.x_parts[i] + this.w_part * 1.1), (float)(this.y_parts[i] + this.h_part / 2.0 + this.partTxts[i].getBounds().getHeight() / 2.0));
                        ++i;
                    }
                }
                if (this.withGrad) {
                    this.gradMinTxt.draw(graph, (float)this.x_grad, (float)(this.y_grad + this.h_grad));
                    double xx = this.x_grad + this.gradMinTxt.getBounds().getWidth() + this.w_grad * 0.1;
                    double ww = this.w_grad / (double)this.legendData.gColors.length;
                    int i = 0;
                    while (i < this.legendData.gColors.length) {
                        Rectangle2D.Double unit = new Rectangle2D.Double(xx, this.y_grad, ww, this.h_grad);
                        graph.setColor(this.legendData.gColors[i]);
                        graph.fill(unit);
                        xx += ww;
                        ++i;
                    }
                    graph.setColor(Color.BLACK);
                    xx = this.x_grad + this.gradMinTxt.getBounds().getWidth() + this.w_grad * 0.1;
                    Rectangle2D.Double stroke = new Rectangle2D.Double(xx, this.y_grad, this.w_grad, this.h_grad);
                    graph.draw(stroke);
                    int i2 = 0;
                    while (i2 < this.legendData.gColors.length) {
                        Line2D.Double sep = new Line2D.Double(xx, this.y_grad, xx, this.y_grad + this.h_grad);
                        graph.draw(sep);
                        xx += 2.0 * ww;
                        i2 += 2;
                    }
                    this.gradMaxTxt.draw(graph, (float)(xx += this.w_grad * 0.1), (float)(this.y_grad + this.h_grad));
                    graph.setColor(Color.BLACK);
                }
                Rectangle2D.Double box = new Rectangle2D.Double(0.0, 0.0, this.width, this.height);
                graph.draw(box);
                graph.setTransform(t);
                graph.setColor(c);
            }
        }

        public double getYMin() {
            return this.y;
        }

        public double getYMax() {
            return this.y + this.height;
        }
    }
}

