/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.metaqtl.graph.Layer;
import org.metaqtl.graph.QtlLayerBuffer;
import org.metaqtl.graph.QtlShape;

public class QtlLayer
extends Layer {
    public static double CI_WIDTH = 5.0;
    public static double TICK_CEX_HEIGHT = 0.05;
    public static double TICK_CEX_WIDTH = 1.5;
    public static double TEXT_WIDTH = 10.0;
    public QtlShape[] qtlShapes = null;
    private QtlLayerBuffer qtlBuffer = null;

    public QtlLayer(double x, double y) {
        super(x, y);
    }

    public void draw(Graphics2D graph) {
        if (this.qtlShapes != null) {
            Color c = graph.getColor();
            AffineTransform t = graph.getTransform();
            AffineTransform trans = new AffineTransform();
            trans.translate(this.x, this.y);
            graph.transform(trans);
            int i = 0;
            while (i < this.qtlShapes.length) {
                this.qtlShapes[i].draw(graph);
                ++i;
            }
            graph.setTransform(t);
            graph.setColor(c);
        }
    }

    public void build(Graphics2D graph) {
        this.width = 0.0;
        this.height = 0.0;
        if (this.qtlShapes != null) {
            int i = 0;
            while (i < this.qtlShapes.length) {
                if (this.qtlShapes[i].getWidth() > this.width) {
                    this.width = this.qtlShapes[i].getWidth();
                }
                if (i == 0) {
                    this.height -= this.qtlShapes[i].getYMin();
                }
                if (i == this.qtlShapes.length - 1) {
                    this.height += this.qtlShapes[i].getYMax();
                }
                ++i;
            }
        }
    }

    public void attach(Object object) {
        if (object instanceof QtlLayerBuffer) {
            this.qtlBuffer = (QtlLayerBuffer)object;
        }
    }

    public double getYMin() {
        return this.y + this.qtlShapes[0].getYMin();
    }

    public double getYMax() {
        return this.y + this.qtlShapes[this.qtlShapes.length - 1].getYMax();
    }
}

