/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.main;

import java.io.FileOutputStream;
import java.io.IOException;
import org.metaqtl.MetaDico;
import org.metaqtl.MetaMap;
import org.metaqtl.adapter.MetaMapAdapter;
import org.metaqtl.algo.MetaMapAlgorithm;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioLocus;
import org.metaqtl.factory.MetaMapSummaryFactory;
import org.metaqtl.main.CmdLineParser;
import org.metaqtl.main.MetaMain;

public class ConsMap
extends MetaMain {
    private static final String VERSION = "1.0";
    private static final String syntax = "Syntaxe: ConsMap [{-m, --mapdir}]] [{-r, --refmap}]] [{-t, --mrkth}]] [{-o, --outstem}]] [{-d, --dubfile}]] [{--mrkdico}]] " + MetaMain.generalUsage();

    public void printUsage() {
        System.err.println(syntax);
    }

    public void printHelp() {
        System.out.println("ConsMap, 1.0");
        System.out.println("Copyright (C) 2005  Jean-Baptiste Veyrieras (INRA)");
        System.out.println("ConsMap comes with ABSOLUTELY NO WARRANTY.  ");
        System.out.println("This is free software, and you are welcome  ");
        System.out.println("to redistribute it under certain conditions.");
        System.out.println();
        System.out.println(syntax);
        System.out.println();
        MetaMain.generalHelp();
        System.out.println();
        System.out.println("-m, --mapdir  : the location of the directory of the map files");
        System.out.println("-r, --refmap  : the location of the reference map (optional)");
        System.out.println("-t, --mrkth   : threshold on the number of times a marker is observed");
        System.out.println("-o, --outstem : the stem name for output files");
        System.out.println("-d, --dubfile : the dubious markers to remove. (optional)");
        System.out.println("--mrkdico     : the marker dictionary (optional)");
    }

    public static void main(String[] args) {
        ConsMap program = new ConsMap();
        program.initCmdLineParser();
        CmdLineParser parser = program.parser;
        CmdLineParser.Option amapDir = parser.addStringOption('m', "mapdir");
        CmdLineParser.Option arefMap = parser.addStringOption('r', "refmap");
        CmdLineParser.Option amrkThresh = parser.addIntegerOption('t', "mrkthresh");
        CmdLineParser.Option aoutStem = parser.addStringOption('o', "outstem");
        CmdLineParser.Option adubFile = parser.addStringOption('d', "dubfile");
        CmdLineParser.Option amrkDicoFile = parser.addStringOption("mrkdico");
        program.parseCmdLine(args);
        String mapDir = (String)parser.getOptionValue(amapDir);
        String refMap = (String)parser.getOptionValue(arefMap);
        Integer mrkThresh = (Integer)parser.getOptionValue(amrkThresh, new Integer(1));
        String outStem = (String)parser.getOptionValue(aoutStem);
        String dubFile = (String)parser.getOptionValue(adubFile, null);
        String mrkDicoFile = (String)parser.getOptionValue(amrkDicoFile, null);
        if (mapDir == null) {
            System.err.println("No map directory defined : EXIT");
            System.exit(2);
        }
        if (outStem == null) {
            System.err.println("No output stem defined : EXIT");
            System.exit(2);
        }
        IBioGenome[] maps = null;
        IBioGenome skeleton = null;
        IBioLocus[] dubious = null;
        MetaDico mrkDico = null;
        try {
            maps = ConsMap.getMaps(mapDir);
            skeleton = ConsMap.getMap(refMap);
            dubious = ConsMap.getDubious(dubFile);
            mrkDico = ConsMap.getDico(mrkDicoFile);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(3);
        }
        if (maps == null) {
            System.err.println("Unable to read map files from " + mapDir);
            System.exit(4);
        }
        MetaMapAlgorithm algorithm = new MetaMapAlgorithm(maps, skeleton, dubious, mrkDico);
        algorithm.setMrkThreshold(mrkThresh);
        if (!program.verbose.booleanValue()) {
            algorithm.disableLogger();
        }
        algorithm.run();
        MetaMap metaMap = algorithm.getResult();
        IBioGenome consMap = MetaMapAdapter.toIBioGenome(metaMap);
        try {
            ConsMap.writeMap(consMap, String.valueOf(outStem) + "_map.xml");
            FileOutputStream stream = new FileOutputStream(String.valueOf(outStem) + "_fit.txt");
            MetaMapSummaryFactory.write(metaMap, stream);
            stream.close();
        }
        catch (IOException e) {
            System.err.println("Unable to save result");
            System.exit(5);
        }
        System.exit(0);
    }
}

