/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.main;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import org.metaqtl.ChromCluster;
import org.metaqtl.Chromosome;
import org.metaqtl.MapCluster;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioLocus;
import org.metaqtl.main.CmdLineParser;
import org.metaqtl.main.MetaMain;

public class InfoMap
extends MetaMain {
    private static final String VERSION = "1.0";
    private static final String syntax = "Syntaxe: ConsMap [{-m, --mapdir}]] [{-t, --mrkth}]] [{-o, --outfile}]] " + MetaMain.generalUsage();

    public void printUsage() {
        System.err.println(syntax);
    }

    public void printHelp() {
        System.out.println("InfoMap, 1.0");
        System.out.println("Copyright (C) 2005  Jean-Baptiste Veyrieras (INRA)");
        System.out.println("ConsMap comes with ABSOLUTELY NO WARRANTY.  ");
        System.out.println("This is free software, and you are welcome  ");
        System.out.println("to redistribute it under certain conditions.");
        System.out.println();
        System.out.println(syntax);
        System.out.println();
        MetaMain.generalHelp();
        System.out.println();
        System.out.println("-m, --mapdir  : the location of the directory of the map files");
        System.out.println("-t, --mrkth   : threshold on the number of times a marker is observed");
        System.out.println("-o, --outfile : the output file location");
    }

    public static void main(String[] args) {
        InfoMap program = new InfoMap();
        program.initCmdLineParser();
        CmdLineParser parser = program.parser;
        CmdLineParser.Option amapDir = parser.addStringOption('m', "mapdir");
        CmdLineParser.Option amrkThresh = parser.addIntegerOption('t', "mrkth");
        CmdLineParser.Option aoutFile = parser.addStringOption('o', "outfile");
        program.parseCmdLine(args);
        String mapDir = (String)parser.getOptionValue(amapDir);
        Integer mrkThresh = (Integer)parser.getOptionValue(amrkThresh, new Integer(1));
        String outFile = (String)parser.getOptionValue(aoutFile);
        if (mapDir == null) {
            System.err.println("[ ERROR ] No map directory defined : EXIT NOW");
            System.exit(2);
        }
        if (outFile == null) {
            System.err.println("[ ERROR ] No output file defined : EXIT NOW");
            System.exit(2);
        }
        IBioGenome[] maps = null;
        Object skeleton = null;
        IBioLocus[] dubious = null;
        Object mrkDico = null;
        try {
            maps = InfoMap.getMaps(mapDir);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(3);
        }
        if (maps == null) {
            System.err.println("[ ERROR ] Unable to read map files from " + mapDir);
            System.exit(4);
        }
        MapCluster mapCluster = new MapCluster();
        mapCluster.addAllMap(maps);
        ChromCluster[] chromClusters = mapCluster.getClusters();
        try {
            FileOutputStream stream = new FileOutputStream(String.valueOf(outFile) + "_cmp.txt");
            int i = 0;
            while (i < chromClusters.length) {
                chromClusters[i].setMrkThresh(mrkThresh);
                chromClusters[i].fixCluster();
                ChromCluster.ClusterGraph graph = chromClusters[i].getGraph();
                if (graph != null) {
                    graph.summarize(stream);
                }
                ++i;
            }
            stream.close();
            stream = new FileOutputStream(String.valueOf(outFile) + "_mrk.txt");
            InfoMap.dumpMarkerInfo(chromClusters, stream);
            stream.close();
        }
        catch (IOException e) {
            System.err.println("[ ERROR ] Failed to write in file " + outFile);
            System.err.println(e.getMessage());
            System.exit(5);
        }
        System.exit(0);
    }

    private static void dumpMarkerInfo(ChromCluster[] chromClusters, OutputStream stream) {
        PrintWriter writer = new PrintWriter(stream);
        int i = 0;
        while (i < chromClusters.length) {
            int k;
            int nm = chromClusters[i].getMarkerNumber();
            writer.println(">CR " + chromClusters[i].getName() + " NM=" + nm);
            Chromosome[] chroms = chromClusters[i].getClusterMembers();
            ArrayList<String> keys = new ArrayList<String>(chroms.length);
            int j = 0;
            while (j < chroms.length) {
                keys.add(chroms[j].getMapName());
                ++j;
            }
            Collections.sort(keys);
            int[] index = new int[keys.size()];
            writer.println("#");
            writer.println("# Table of the chromosomes");
            writer.println("#");
            j = 0;
            while (j < keys.size()) {
                writer.println(String.valueOf(j + 1) + "\t" + keys.get(j));
                k = 0;
                while (k < keys.size()) {
                    if (chroms[k].getMapName().equals(keys.get(j))) {
                        index[j] = k;
                        break;
                    }
                    ++k;
                }
                ++j;
            }
            writer.println("#");
            writer.println("# Table of markers");
            writer.println("#");
            writer.print("Marker\tOccurence");
            j = 0;
            while (j < keys.size()) {
                writer.print("\t" + (j + 1));
                ++j;
            }
            writer.println();
            j = 0;
            while (j < nm) {
                String mrkName = chromClusters[i].getMarkerNameByIndex(j);
                int occ = chromClusters[i].getMarkerOccurence(j);
                writer.print(String.valueOf(mrkName) + "\t" + occ);
                k = 0;
                while (k < keys.size()) {
                    writer.print("\t");
                    int id = chroms[index[k]].getMarkerIdxWithName(mrkName);
                    if (id >= 0) {
                        writer.print("x");
                    }
                    ++k;
                }
                writer.println();
                ++j;
            }
            writer.println();
            writer.println();
            ++i;
        }
        writer.close();
    }
}

