/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.main;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.metaqtl.EMResult;
import org.metaqtl.MetaQtlAnalysis;
import org.metaqtl.MetaQtlResult;
import org.metaqtl.bio.util.NumberFormat;
import org.metaqtl.main.CmdLineParser;
import org.metaqtl.main.MetaMain;
import org.metaqtl.numrec.NumericalUtilities;

public class QTLClustInfo
extends MetaMain {
    private static final String VERSION = "1.0";
    private static final String syntax = "Syntaxe: MetaQtlStat [{-r, --result}]] [{-o, --outfile}]] [{-c, --chr}]] [{-t, --trait}]] [{-b, --best}]] [{--kmin}]] [{--kmax}]] " + MetaMain.generalUsage();

    public void printUsage() {
        System.err.println(syntax);
    }

    public void printHelp() {
        MetaMain.printLicense("MetaQtlStat", VERSION);
        System.out.println();
        System.out.println(syntax);
        System.out.println();
        MetaMain.generalHelp();
        System.out.println();
        System.out.println("-r, --clust   : the clustering result file");
        System.out.println("-o, --output  : the output file");
        System.out.println("-c, --chr     : the chromosome name");
        System.out.println("-t, --trait   : the trait name");
        System.out.println("-b, --best    : the best model (number of QTL)");
        System.out.println("--kmin        : the minimal number of QTL");
        System.out.println("--kmax        : the maximal number of QTL");
    }

    public static void main(String[] args) {
        QTLClustInfo program = new QTLClustInfo();
        program.initCmdLineParser();
        CmdLineParser parser = program.parser;
        CmdLineParser.Option aresFile = parser.addStringOption('r', "clust");
        CmdLineParser.Option aoutFile = parser.addStringOption('o', "output");
        CmdLineParser.Option achrName = parser.addStringOption('c', "chr");
        CmdLineParser.Option atraitName = parser.addStringOption('t', "trait");
        CmdLineParser.Option abestK = parser.addIntegerOption('b', "best");
        CmdLineParser.Option aminK = parser.addIntegerOption("kmin");
        CmdLineParser.Option amaxK = parser.addIntegerOption("kmax");
        program.parseCmdLine(args);
        String resFile = (String)parser.getOptionValue(aresFile);
        String outFile = (String)parser.getOptionValue(aoutFile);
        String chrName = (String)parser.getOptionValue(achrName);
        String traitName = (String)parser.getOptionValue(atraitName);
        Integer bestK = (Integer)parser.getOptionValue(abestK);
        Integer minK = (Integer)parser.getOptionValue(aminK);
        Integer maxK = (Integer)parser.getOptionValue(amaxK);
        if (resFile == null) {
            System.err.println("[ ERROR ] No result file defined");
            System.exit(2);
        }
        if (outFile == null) {
            System.err.println("[ ERROR ] No output file defined");
            System.exit(2);
        }
        if (bestK == null) {
            System.err.println("[ ERROR ] No best model defined");
            System.exit(2);
        }
        if (chrName == null) {
            System.err.println("[ ERROR ] No chromosome defined");
            System.exit(2);
        }
        MetaQtlAnalysis analysis = null;
        try {
            analysis = QTLClustInfo.getResult(resFile);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(3);
        }
        if (analysis == null) {
            System.err.println("[ ERROR ] Unable to load result from " + resFile);
            System.exit(4);
        }
        int cidx = analysis.getChromIdx(chrName);
        MetaQtlResult result = analysis.getResult(chrName, traitName);
        if (result != null) {
            EMResult best = result.getClustering(bestK);
            double[] usd = result.getUSD(best, minK, maxK, "AIC");
            double[] xp = best.getXPred();
            double[] d = best.getMahalanobis(result.sd);
            double ci_b = NumericalUtilities.sd2ci(best.getSD(0));
            double ci_all = NumericalUtilities.sd2ci(usd[0]);
            double[] tmp = new double[xp.length + 1];
            int[] idx = new int[xp.length + 1];
            int i = 0;
            while (i < xp.length) {
                tmp[i + 1] = xp[i];
                ++i;
            }
            NumericalUtilities.indexx(xp.length, tmp, idx);
            try {
                FileWriter writer = new FileWriter(outFile);
                PrintWriter out = new PrintWriter(writer);
                out.println("##");
                out.println("# Meta-QTL Table");
                out.println("##");
                out.println("--");
                out.println("QTL\tPosition\tWeight\tDistance\tCI(95%)\tUCI(95%)");
                out.println("--");
                int i2 = 0;
                while (i2 < best.getK()) {
                    ci_b = NumericalUtilities.sd2ci(best.getSD(i2));
                    ci_all = NumericalUtilities.sd2ci(usd[i2]);
                    out.print(String.valueOf(i2 + 1) + "\t" + NumberFormat.formatDouble(best.getMu(i2)) + "\t" + NumberFormat.formatDouble(best.getPi(i2)) + "\t");
                    if (i2 < best.getK() - 1) {
                        out.print(NumberFormat.formatDouble(d[i2]));
                    } else {
                        out.print("-");
                    }
                    out.println("\t" + NumberFormat.formatDouble(ci_b) + "\t" + NumberFormat.formatDouble(ci_all));
                    ++i2;
                }
                out.println("--");
                out.println("##");
                out.println("# Observed QTL Table");
                out.println("##");
                out.println("--");
                out.print("QTL   Position   CI(95%)   Predicted   Memberships 1");
                if (bestK > 1) {
                    out.println(" --> " + bestK);
                } else {
                    out.println();
                }
                out.println("--");
                i2 = 1;
                while (i2 <= xp.length) {
                    String qtlName = analysis.qtlByChrom[cidx][result.qtlIdx[idx[i2] - 1]].getName();
                    out.print(String.valueOf(qtlName) + "\t" + NumberFormat.formatDouble(result.x[idx[i2] - 1]) + "\t" + NumberFormat.formatDouble(NumericalUtilities.sd2ci(result.sd[idx[i2] - 1])) + "\t" + NumberFormat.formatDouble(xp[idx[i2] - 1]));
                    double[] z = best.getZ(idx[i2] - 1);
                    int j = 0;
                    while (j < z.length) {
                        out.print("\t" + NumberFormat.formatDouble(z[j]));
                        ++j;
                    }
                    out.println();
                    ++i2;
                }
                out.println("--");
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.exit(0);
    }
}

