/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.main;

import java.io.IOException;
import org.metaqtl.Chromosome;
import org.metaqtl.adapter.ChromosomeAdapter;
import org.metaqtl.algo.QtlProjAlgorithm;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.main.CmdLineParser;
import org.metaqtl.main.MetaMain;

public class QTLProj
extends MetaMain {
    private static final String VERSION = "1.0";
    private static final String syntax = " Syntaxe: QTLProj [{-m, --map}]] [{-q, --qtl}]] [{-o, --out}]] [{-r, --ratio}]] [{-p, --pval}]] [{--rmrk}]] [{--rqtl}]] " + MetaMain.generalUsage();

    public void printUsage() {
        System.err.println(syntax);
    }

    public void printHelp() {
        System.out.println("QTLProj, 1.0");
        System.out.println("Copyright (C) 2005  Jean-Baptiste Veyrieras (INRA)");
        System.out.println("QTLProj comes with ABSOLUTELY NO WARRANTY.  ");
        System.out.println("This is free software, and you are welcome  ");
        System.out.println("to redistribute it under certain conditions.");
        System.out.println();
        System.out.println(syntax);
        System.out.println();
        MetaMain.generalHelp();
        System.out.println();
        System.out.println("-m, --map : the location of the map file");
        System.out.println("-q, --qtl : the location of the qtl map file or directory");
        System.out.println("-o, --out : the output file stem");
        System.out.println("-r, --ratio : the minimal ratio");
        System.out.println("-p, --pval : the minimal pvalue");
        System.out.println("--rmrk : remove a given list of marker");
        System.out.println("--rqtl : remove a given list of QTL");
    }

    public static void main(String[] args) {
        QTLProj program = new QTLProj();
        program.initCmdLineParser();
        CmdLineParser parser = program.parser;
        CmdLineParser.Option amapFile = parser.addStringOption('m', "map");
        CmdLineParser.Option aqtlDir = parser.addStringOption('q', "qtl");
        CmdLineParser.Option aoutFile = parser.addStringOption('o', "out");
        CmdLineParser.Option aratio = parser.addDoubleOption('r', "ratio");
        CmdLineParser.Option apval = parser.addDoubleOption('p', "pval");
        CmdLineParser.Option arMrk = parser.addStringOption("rmrk");
        CmdLineParser.Option arQtl = parser.addStringOption("rqtl");
        program.parseCmdLine(args);
        String mapFile = (String)parser.getOptionValue(amapFile);
        String qtlDir = (String)parser.getOptionValue(aqtlDir);
        String outFile = (String)parser.getOptionValue(aoutFile);
        Double ratio = (Double)parser.getOptionValue(aratio, new Double(0.5));
        Double pval = (Double)parser.getOptionValue(apval, new Double(0.01));
        String rMrkFile = (String)parser.getOptionValue(arMrk);
        String rQtlFile = (String)parser.getOptionValue(arQtl);
        if (mapFile == null) {
            System.err.println("No map location defined : EXIT");
            System.exit(2);
        }
        if (qtlDir == null) {
            System.err.println("No qtl location defined : EXIT");
            System.exit(2);
        }
        if (outFile == null) {
            System.err.println("No output location defined : EXIT");
            System.exit(2);
        }
        IBioGenome map = null;
        IBioGenome[] qtls = null;
        try {
            map = QTLProj.getMap(mapFile);
            qtls = QTLProj.getMaps(qtlDir);
            QTLProj.removeLocus(qtls, rMrkFile);
            QTLProj.removeLocus(qtls, rQtlFile);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(3);
        }
        if (map == null) {
            System.err.println("Unable to load the map from " + mapFile);
            System.exit(4);
        }
        if (qtls == null) {
            System.err.println("Unable to load the QTL from " + qtlDir);
            System.exit(5);
        }
        QtlProjAlgorithm algo = new QtlProjAlgorithm(qtls, map, null);
        if (!program.verbose.booleanValue()) {
            algo.disableLogger();
        }
        algo.setRatio(ratio);
        algo.setPvalue(pval);
        algo.run();
        Chromosome[] result = algo.getResult();
        IBioGenome pmap = ChromosomeAdapter.toIBioGenome(result, 0);
        IBioGenome pqtl = ChromosomeAdapter.toIBioGenome(result, 2);
        try {
            QTLProj.writeMap(pmap, String.valueOf(outFile) + "_map.xml");
            QTLProj.writeMap(pqtl, String.valueOf(outFile) + "_qtl.xml");
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(6);
        }
        System.exit(0);
    }
}

