/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.verifier.VerificationResult;
import org.apache.bcel.verifier.Verifier;
import org.apache.bcel.verifier.VerifierFactory;
import org.jibx.binding.Utility;
import org.jibx.binding.classes.BoundClass;
import org.jibx.binding.classes.BranchWrapper;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.MungedClass;
import org.jibx.binding.def.BindingDefinition;
import org.jibx.runtime.JiBXException;

public class Compile {
    private boolean m_verbose;
    private boolean m_load;
    private boolean m_verify;
    private boolean m_trackBranches;
    private boolean m_errorOverride;
    private boolean m_skipValidate;
    static /* synthetic */ Class class$org$jibx$binding$Compile$DirectLoader;

    public Compile() {
    }

    public Compile(boolean verbose, boolean load, boolean verify, boolean track, boolean over) {
        this.m_verbose = verbose;
        this.m_load = load;
        this.m_verify = verify;
        this.m_trackBranches = track;
        this.m_errorOverride = over;
    }

    private boolean verifyBCEL(ClassFile file) {
        try {
            Verifier verifier = VerifierFactory.getVerifier(file.getName());
            boolean verified = false;
            VerificationResult vr = verifier.doPass1();
            if (vr.getStatus() == 1) {
                vr = verifier.doPass2();
                if (vr.getStatus() == 1) {
                    Method[] methods = file.getRawClass().getMethods();
                    for (int j = 0; j < methods.length; ++j) {
                        vr = verifier.doPass3a(j);
                        if (vr.getStatus() == 1) {
                            vr = verifier.doPass3b(j);
                        }
                        if (vr.getStatus() == 1) {
                            verified = true;
                            continue;
                        }
                        System.out.println("Verification failure on method " + methods[j].getName() + " of class " + file.getName() + ":");
                        System.out.println("  " + vr.toString());
                    }
                } else {
                    System.out.println("Verification failure on class " + file.getName() + ":");
                    System.out.println("  " + vr.toString());
                }
            } else {
                System.out.println("Verification failure on class " + file.getName() + ":");
                System.out.println("  " + vr.toString());
            }
            return verified;
        }
        catch (Exception ex) {
            System.out.println("BCEL failure:");
            ex.printStackTrace();
            return false;
        }
    }

    private void handleOutput(String[] paths) throws JiBXException, IOException {
        ClassFile[][] lists = MungedClass.fixChanges(true);
        ClassFile[] files = lists[0];
        if (this.m_verbose) {
            System.out.println("\nWrote " + files.length + " files");
        }
        if (this.m_verbose || this.m_load) {
            int i;
            URL[] urls = null;
            if (this.m_load) {
                urls = new URL[paths.length];
                for (i = 0; i < urls.length; ++i) {
                    urls[i] = new File(paths[i]).toURL();
                }
            }
            for (i = 0; i < files.length; ++i) {
                ClassFile file = files[i];
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                file.writeFile(bos);
                byte[] bytes = bos.toByteArray();
                if (this.m_verbose) {
                    System.out.println("\n " + file.getName() + " output file size is " + bytes.length + " bytes");
                }
                if (this.m_verify) {
                    this.verifyBCEL(file);
                }
                if (!this.m_load) continue;
                DirectLoader cloader = new DirectLoader(urls);
                Class clas = cloader.load(file.getName(), bytes);
                if (!this.m_verbose) continue;
                java.lang.reflect.Method[] methods = clas.getDeclaredMethods();
                System.out.println(" Found " + methods.length + " methods:");
                for (int j = 0; j < methods.length; ++j) {
                    java.lang.reflect.Method method = methods[j];
                    System.out.println("  " + method.getReturnType().getName() + " " + method.getName());
                }
            }
        }
        if (this.m_verbose) {
            int i;
            files = lists[1];
            System.out.println("\nKept " + files.length + " files unchanged:");
            for (i = 0; i < files.length; ++i) {
                System.out.println(" " + files[i].getName());
            }
            files = lists[2];
            System.out.println("\nDeleted " + files.length + " files:");
            for (i = 0; i < files.length; ++i) {
                System.out.println(" " + files[i].getName());
            }
        }
    }

    public void setLoad(boolean load) {
        this.m_load = load;
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public void setVerify(boolean verify) {
        this.m_verify = verify;
    }

    public void setSkipValidate(boolean skip) {
        this.m_skipValidate = skip;
    }

    public void compile(String[] paths, String[] files) throws JiBXException {
        try {
            int i;
            if (this.m_verbose) {
                System.out.println("Running binding compiler version jibx-rc0");
            }
            ClassCache.setPaths(paths);
            ClassFile.setPaths(paths);
            BoundClass.reset();
            MungedClass.reset();
            BindingDefinition.reset();
            BranchWrapper.setTracking(this.m_trackBranches);
            BranchWrapper.setErrorOverride(this.m_errorOverride);
            BindingDefinition[] defs = new BindingDefinition[files.length];
            for (i = 0; i < files.length; ++i) {
                defs[i] = Utility.loadFileBinding(files[i], !this.m_skipValidate);
                if (!this.m_verbose) continue;
                defs[i].print();
            }
            for (i = 0; i < defs.length; ++i) {
                try {
                    defs[i].generateCode(this.m_verbose);
                    continue;
                }
                catch (RuntimeException e) {
                    throw new JiBXException("\n*** Error during code generation - please report this error on the JiBX users list so that the condition can be caught during validation ***\n", e);
                }
            }
            this.handleOutput(paths);
        }
        catch (IOException ex) {
            throw new JiBXException("IOException in compile", ex);
        }
        catch (ExceptionInInitializerError ex) {
            throw new JiBXException("Error during initialization; is jibx-run.jar in load classpath?", ex.getException());
        }
        catch (Throwable ex) {
            throw new JiBXException("Error running binding compiler", ex);
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            try {
                int offset;
                boolean verbose = false;
                boolean load = false;
                boolean verify = false;
                boolean track = false;
                boolean over = false;
                boolean skip = false;
                for (offset = 0; offset < 5 && offset < args.length; ++offset) {
                    String arg = args[offset];
                    if ("-v".equalsIgnoreCase(arg)) {
                        verbose = true;
                        continue;
                    }
                    if ("-l".equalsIgnoreCase(arg)) {
                        load = true;
                        continue;
                    }
                    if ("-b".equalsIgnoreCase(arg)) {
                        verify = true;
                        continue;
                    }
                    if ("-o".equalsIgnoreCase(arg)) {
                        over = true;
                        continue;
                    }
                    if ("-s".equalsIgnoreCase(arg)) {
                        skip = true;
                        continue;
                    }
                    if (!"-t".equalsIgnoreCase(arg)) break;
                    track = true;
                }
                String[] clsspths = Utility.getClassPaths();
                String[] bindings = new String[args.length - offset];
                System.arraycopy(args, offset, bindings, 0, bindings.length);
                if (verbose) {
                    int i;
                    System.out.println("Using paths:");
                    for (i = 0; i < clsspths.length; ++i) {
                        System.out.println(" " + clsspths[i]);
                    }
                    System.out.println("Using bindings:");
                    for (i = 0; i < bindings.length; ++i) {
                        System.out.println(" " + bindings[i]);
                    }
                }
                Compile compiler = new Compile(verbose, load, verify, track, over);
                compiler.setSkipValidate(skip);
                compiler.compile(clsspths, bindings);
            }
            catch (JiBXException ex) {
                ex.printStackTrace(System.out);
                System.exit(1);
            }
        } else {
            System.out.println("\nUsage: java org.jibx.binding.Compile [-b] [-l] [-v] binding1 binding2 ...\nwhere:\n -b  turns on BCEL verification (debug option),\n -l  turns on test loading of modified or generated classes for validation, and\n -v  turns on verbose output\nThe bindingn files are different bindings to be compiled.\n");
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DirectLoader
    extends URLClassLoader {
        protected DirectLoader(URL[] urls) {
            super(urls, (class$org$jibx$binding$Compile$DirectLoader == null ? (class$org$jibx$binding$Compile$DirectLoader = Compile.class$("org.jibx.binding.Compile$DirectLoader")) : class$org$jibx$binding$Compile$DirectLoader).getClassLoader());
        }

        protected Class load(String name, byte[] data) {
            return this.defineClass(name, data, 0, data.length);
        }
    }
}

