/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.model.ClassItemWrapper;
import org.jibx.binding.model.IClass;
import org.jibx.binding.model.IClassItem;
import org.jibx.runtime.JiBXException;

public class ClassWrapper
implements IClass {
    private final ClassFile m_class;

    public ClassWrapper(ClassFile clas) {
        this.m_class = clas;
    }

    public String getName() {
        return this.m_class.getName();
    }

    public String getSignature() {
        return this.m_class.getSignature();
    }

    public String getPackage() {
        return this.m_class.getPackage();
    }

    public IClass getSuperClass() {
        ClassFile scf = this.m_class.getSuperFile();
        if (scf == null) {
            return null;
        }
        return new ClassWrapper(this.m_class.getSuperFile());
    }

    public String[] getInterfaces() {
        return this.m_class.getInterfaces();
    }

    public String[] getInstanceSigs() {
        try {
            return this.m_class.getInstanceSigs();
        }
        catch (JiBXException e) {
            throw new IllegalStateException("Internal error: instance signatures not found for class " + this.m_class.getName());
        }
    }

    public boolean isImplements(String sig) {
        try {
            return this.m_class.isImplements(sig);
        }
        catch (JiBXException e) {
            throw new IllegalStateException("Internal error: instance signatures not found for class " + this.m_class.getName());
        }
    }

    public boolean isSuperclass(String name) {
        for (ClassFile current = this.m_class; current != null; current = current.getSuperFile()) {
            if (!current.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public IClassItem getDirectField(String name) {
        ClassItem item = this.m_class.getDirectField(name);
        if (item == null) {
            return null;
        }
        return new ClassItemWrapper(this, item);
    }

    public IClassItem getField(String name) {
        try {
            return new ClassItemWrapper(this, this.m_class.getField(name));
        }
        catch (JiBXException e) {
            return null;
        }
    }

    public IClassItem getMethod(String name, String sig) {
        ClassItem item = this.m_class.getMethod(name, sig);
        if (item == null) {
            return null;
        }
        return new ClassItemWrapper(this, item);
    }

    public IClassItem getMethod(String name, String[] sigs) {
        ClassItem item = this.m_class.getMethod(name, sigs);
        if (item == null) {
            return null;
        }
        return new ClassItemWrapper(this, item);
    }

    public IClassItem getInitializerMethod(String sig) {
        ClassItem item = this.m_class.getInitializerMethod(sig);
        if (item == null) {
            return null;
        }
        return new ClassItemWrapper(this, item);
    }

    public IClassItem getStaticMethod(String name, String sig) {
        ClassItem item = this.m_class.getStaticMethod(name, sig);
        if (item == null) {
            return null;
        }
        return new ClassItemWrapper(this, item);
    }

    public boolean isAccessible(IClassItem item) {
        return this.m_class.isAccessible(((ClassItemWrapper)item).m_item);
    }

    public boolean isAssignable(IClass other) {
        String[] sigs;
        try {
            sigs = this.m_class.getInstanceSigs();
        }
        catch (JiBXException e) {
            throw new IllegalStateException("Internal error: class information not available");
        }
        String match = other.getSignature();
        for (int i = 0; i < sigs.length; ++i) {
            if (!match.equals(sigs[i])) continue;
            return true;
        }
        return false;
    }

    public IClassItem getBestMethod(String name, String type, String[] args) {
        ClassItem item = this.m_class.getBestMethod(name, type, args);
        if (item == null) {
            return null;
        }
        return new ClassItemWrapper(this, item);
    }

    public ClassFile getClassFile() {
        return this.m_class;
    }
}

