/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.jibx.runtime.IUnmarshaller;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.runtime.Utility;
import org.jibx.runtime.impl.BackFillHolder;
import org.jibx.runtime.impl.BackFillReference;
import org.jibx.runtime.impl.ITrackSourceImpl;
import org.jibx.runtime.impl.InputStreamWrapper;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class UnmarshallingContext
implements IUnmarshallingContext {
    public static final int START_DOCUMENT = 0;
    public static final int END_DOCUMENT = 1;
    public static final int START_TAG = 2;
    public static final int END_TAG = 3;
    public static final int TEXT = 4;
    public static final int CDSECT = 5;
    public static final int ENTITY_REF = 6;
    public static final int IGNORABLE_WHITESPACE = 7;
    public static final int PROCESSING_INSTRUCTION = 8;
    public static final int COMMENT = 9;
    public static final int DOCDECL = 10;
    protected static final String DEFAULT_PARSER_NAME = "org.xmlpull.mxp1.MXParserFactory";
    protected static final int INITIAL_STACK_SIZE = 20;
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static XmlPullParserFactory s_factory;
    private InputStreamWrapper m_streamWrapper;
    protected XmlPullParser m_parser;
    protected String m_docName;
    protected String[] m_unmarshallerClasses;
    protected IUnmarshaller[] m_unmarshallers;
    protected String[] m_namespaces;
    protected String[] m_names;
    protected int m_globalCount;
    protected HashMap[] m_idMaps;
    protected String[] m_idClasses;
    protected int m_stackDepth;
    protected Object[] m_objectStack;
    protected HashMap m_unmarshalMap;
    protected Integer[] m_indexes;
    protected String m_idref;
    static /* synthetic */ Class class$org$jibx$runtime$impl$UnmarshallingContext;

    public UnmarshallingContext(int nmap, String[] umcs, String[] nss, String[] names, String[] idcs) {
        this.m_globalCount = nss.length;
        this.m_unmarshallerClasses = new String[nmap];
        System.arraycopy(umcs, 0, this.m_unmarshallerClasses, 0, umcs.length);
        this.m_unmarshallers = new IUnmarshaller[nmap];
        this.m_namespaces = new String[nmap];
        System.arraycopy(nss, 0, this.m_namespaces, 0, nss.length);
        this.m_names = new String[nmap];
        System.arraycopy(names, 0, this.m_names, 0, names.length);
        this.m_idClasses = idcs;
        int size = idcs == null ? 1 : idcs.length;
        this.m_idMaps = new HashMap[size];
        this.m_objectStack = new Object[20];
    }

    public UnmarshallingContext() {
        this(0, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY, EMPTY_STRING_ARRAY);
    }

    private void createParser(boolean nsa) throws JiBXException {
        if (this.m_parser == null) {
            try {
                if (s_factory == null) {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    if (loader == null) {
                        loader = (class$org$jibx$runtime$impl$UnmarshallingContext == null ? (class$org$jibx$runtime$impl$UnmarshallingContext = UnmarshallingContext.class$("org.jibx.runtime.impl.UnmarshallingContext")) : class$org$jibx$runtime$impl$UnmarshallingContext).getClassLoader();
                    }
                    try {
                        String name = System.getProperty("org.xmlpull.v1.XmlPullParserFactory");
                        if (name != null && (name = name.trim()).length() > 0) {
                            s_factory = XmlPullParserFactory.newInstance(name, loader.getClass());
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (s_factory == null) {
                        try {
                            s_factory = XmlPullParserFactory.newInstance();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        if (s_factory == null) {
                            try {
                                s_factory = XmlPullParserFactory.newInstance(DEFAULT_PARSER_NAME, loader.getClass());
                            }
                            catch (Exception ex) {
                                throw new JiBXException("Unable to create parser", ex);
                            }
                        }
                    }
                    s_factory.setNamespaceAware(nsa);
                }
                this.m_parser = s_factory.newPullParser();
            }
            catch (XmlPullParserException ex) {
                throw new JiBXException("Error creating parser", ex);
            }
        }
    }

    public static String buildNameString(String ns, String name) {
        if (ns == null || "".equals(ns)) {
            return "\"" + name + "\"";
        }
        return "\"{" + ns + "}" + name + "\"";
    }

    public String currentNameString() {
        return UnmarshallingContext.buildNameString(this.m_parser.getNamespace(), this.m_parser.getName());
    }

    public String buildPositionString() {
        String base = "(line " + this.m_parser.getLineNumber() + ", col " + this.m_parser.getColumnNumber();
        if (this.m_docName != null) {
            base = base + ", in " + this.m_docName;
        }
        return base + ')';
    }

    public void throwStartTagNameError(String ns, String name) throws JiBXException {
        throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(ns, name) + " start tag, found " + this.currentNameString() + " start tag " + this.buildPositionString());
    }

    public void throwEndTagNameError(String ns, String name) throws JiBXException {
        throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(ns, name) + " end tag, found " + this.currentNameString() + " end tag " + this.buildPositionString());
    }

    private void advance() throws JiBXException {
        try {
            this.m_parser.nextToken();
        }
        catch (IOException ex) {
            throw new JiBXException("Error accessing document", ex);
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
        }
    }

    private boolean verifyNamespace(String ns) {
        if (ns == null || "".equals(ns)) {
            return this.m_parser.getNamespace().length() == 0;
        }
        return ns.equals(this.m_parser.getNamespace());
    }

    private String getAttributeValue(String ns, String name) {
        if (ns == null) {
            return this.m_parser.getAttributeValue("", name);
        }
        return this.m_parser.getAttributeValue(ns, name);
    }

    public void setDocument(InputStream ins, String enc, boolean nsa) throws JiBXException {
        try {
            this.createParser(nsa);
            if (this.m_streamWrapper == null) {
                this.m_streamWrapper = new InputStreamWrapper();
            }
            this.m_streamWrapper.setInput(ins, enc);
            this.m_parser.setInput(this.m_streamWrapper.getReader());
            this.reset();
        }
        catch (XmlPullParserException e) {
            throw new JiBXException("Error setting document", e);
        }
        catch (IOException e) {
            throw new JiBXException("Error initializing input stream", e);
        }
    }

    public void setDocument(InputStream ins, String enc) throws JiBXException {
        this.setDocument(ins, enc, true);
    }

    public void setDocument(Reader rdr, boolean nsa) throws JiBXException {
        try {
            this.createParser(nsa);
            this.m_parser.setInput(rdr);
            this.reset();
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error setting document", ex);
        }
    }

    public void setDocument(Reader rdr) throws JiBXException {
        this.setDocument(rdr, true);
    }

    public void setDocument(InputStream ins, String name, String enc) throws JiBXException {
        this.setDocument(ins, enc);
        this.m_docName = name;
    }

    public void setDocument(Reader rdr, String name) throws JiBXException {
        this.setDocument(rdr);
        this.m_docName = name;
    }

    public void setFromContext(UnmarshallingContext parent) {
        this.m_parser = parent.m_parser;
        this.m_docName = parent.m_docName;
    }

    public void reset() {
        int i;
        for (i = 0; i < this.m_idMaps.length; ++i) {
            this.m_idMaps[i] = null;
        }
        for (i = this.m_globalCount; i < this.m_unmarshallers.length; ++i) {
            this.m_namespaces[i] = null;
            this.m_names[i] = null;
            this.m_unmarshallers[i] = null;
        }
        this.m_unmarshalMap = null;
        this.m_idref = null;
        for (i = 0; i < this.m_objectStack.length; ++i) {
            this.m_objectStack[i] = null;
        }
        this.m_stackDepth = 0;
    }

    public String toStart() throws JiBXException {
        try {
            if (this.m_parser.getEventType() == 2) {
                return this.m_parser.getName();
            }
            while (true) {
                this.m_parser.next();
                switch (this.m_parser.getEventType()) {
                    case 2: {
                        return this.m_parser.getName();
                    }
                    case 3: {
                        throw new JiBXException("Expected start tag, found end tag " + this.currentNameString() + " " + this.buildPositionString());
                    }
                    case 1: {
                        throw new JiBXException("Expected start tag, found end of document " + this.buildPositionString());
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new JiBXException("Error accessing document", ex);
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
        }
    }

    public String toEnd() throws JiBXException {
        try {
            if (this.m_parser.getEventType() == 3) {
                return this.m_parser.getName();
            }
            while (true) {
                this.m_parser.next();
                switch (this.m_parser.getEventType()) {
                    case 2: {
                        throw new JiBXException("Expected end tag, found start tag " + this.currentNameString() + " " + this.buildPositionString());
                    }
                    case 3: {
                        return this.m_parser.getName();
                    }
                    case 1: {
                        throw new JiBXException("Expected end tag, found end of document " + this.buildPositionString());
                    }
                }
            }
        }
        catch (IOException ex) {
            throw new JiBXException("Error accessing document", ex);
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
        }
    }

    public int toTag() throws JiBXException {
        try {
            int type = this.m_parser.getEventType();
            while (type != 2 && type != 3) {
                type = this.m_parser.next();
            }
            return this.m_parser.getEventType();
        }
        catch (IOException ex) {
            throw new JiBXException("Error accessing document", ex);
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
        }
    }

    public boolean isAt(String ns, String name) throws JiBXException {
        try {
            int type = this.m_parser.getEventType();
            while (type != 2 && type != 3) {
                type = this.m_parser.next();
            }
            return this.m_parser.getEventType() == 2 && this.m_parser.getName().equals(name) && this.verifyNamespace(ns);
        }
        catch (IOException ex) {
            throw new JiBXException("Error accessing document", ex);
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
        }
    }

    public boolean hasAttribute(String ns, String name) throws JiBXException {
        try {
            if (this.m_parser.getEventType() == 2) {
                return this.getAttributeValue(ns, name) != null;
            }
            throw new JiBXException("Error parsing document " + this.buildPositionString());
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
        }
    }

    public boolean hasAnyAttribute(String[] nss, String[] names) throws JiBXException {
        try {
            if (this.m_parser.getEventType() == 2) {
                for (int i = 0; i < names.length; ++i) {
                    if (this.getAttributeValue(nss[i], names[i]) == null) continue;
                    return true;
                }
                return false;
            }
            throw new JiBXException("Error parsing document " + this.buildPositionString());
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
        }
    }

    public void checkAllowedAttributes(String[] nss, String[] names) throws JiBXException {
        block6: {
            try {
                if (this.m_parser.getEventType() == 2) {
                    int count = this.m_parser.getAttributeCount();
                    block2: for (int i = 0; i < count; ++i) {
                        String name = this.m_parser.getAttributeName(i);
                        String ns = this.m_parser.getAttributeNamespace(i);
                        int base = 0;
                        int limit = names.length - 1;
                        while (base <= limit) {
                            String comp;
                            int cur = base + limit >> 1;
                            int diff = name.compareTo(names[cur]);
                            if (diff == 0 && (diff = (comp = nss[cur]) == null ? ns.compareTo("") : ns.compareTo(comp)) == 0) continue block2;
                            if (diff < 0) {
                                limit = cur - 1;
                                continue;
                            }
                            if (diff <= 0) continue;
                            base = cur + 1;
                        }
                        this.throwStartTagException("Illegal attribute " + UnmarshallingContext.buildNameString(ns, name));
                    }
                    break block6;
                }
                throw new JiBXException("Error parsing document " + this.buildPositionString());
            }
            catch (XmlPullParserException ex) {
                throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
            }
        }
    }

    public void parseToStartTag(String ns, String name) throws JiBXException {
        if (this.toStart().equals(name) && this.verifyNamespace(ns)) {
            return;
        }
        this.throwStartTagNameError(ns, name);
    }

    public void parsePastStartTag(String ns, String name) throws JiBXException {
        if (this.toStart().equals(name) && this.verifyNamespace(ns)) {
            this.advance();
        } else {
            this.throwStartTagNameError(ns, name);
        }
    }

    public boolean parseIfStartTag(String ns, String name) throws JiBXException {
        if (this.isAt(ns, name)) {
            this.advance();
            return true;
        }
        return false;
    }

    public void parsePastEndTag(String ns, String name) throws JiBXException {
        if (this.toEnd().equals(name) && this.verifyNamespace(ns)) {
            this.advance();
        } else {
            this.throwEndTagNameError(ns, name);
        }
    }

    public boolean isEnd() throws JiBXException {
        try {
            int type = this.m_parser.getEventType();
            while (type != 2 && type != 3) {
                type = this.m_parser.next();
            }
            return this.m_parser.getEventType() == 3;
        }
        catch (IOException ex) {
            throw new JiBXException("Error accessing document", ex);
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String accumulateText() throws JiBXException {
        try {
            String text = null;
            StringBuffer buff = null;
            block8: while (true) {
                switch (this.m_parser.getEventType()) {
                    case 6: {
                        if (this.m_parser.getText() == null) {
                            throw new JiBXException("Unexpanded entity reference in text at " + this.buildPositionString());
                        }
                    }
                    case 4: 
                    case 5: {
                        if (text == null) {
                            text = this.m_parser.getText();
                            break;
                        }
                        if (buff == null) {
                            buff = new StringBuffer(text);
                        }
                        buff.append(this.m_parser.getText());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        break block8;
                    }
                }
                this.m_parser.nextToken();
            }
            if (buff != null) return buff.toString();
            if (text == null) {
                return "";
            }
            String string = text;
            return string;
        }
        catch (IOException ex) {
            throw new JiBXException("Error accessing document", ex);
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
        }
    }

    public String parseContentText() throws JiBXException {
        return this.accumulateText();
    }

    public String parseContentText(String ns, String tag) throws JiBXException {
        try {
            String text = this.accumulateText();
            switch (this.m_parser.getEventType()) {
                case 3: {
                    if (this.m_parser.getName().equals(tag) && this.verifyNamespace(ns)) {
                        this.m_parser.nextToken();
                        return text;
                    }
                    this.throwEndTagNameError(ns, tag);
                }
                case 2: {
                    throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(ns, tag) + " end tag, " + "found " + this.currentNameString() + " start tag " + this.buildPositionString());
                }
                case 1: {
                    throw new JiBXException("Expected " + UnmarshallingContext.buildNameString(ns, tag) + " end tag, " + "found end of document " + this.buildPositionString());
                }
            }
            return null;
        }
        catch (IOException ex) {
            throw new JiBXException("Error accessing document", ex);
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
        }
    }

    public int parseContentInt(String ns, String tag) throws JiBXException {
        String text = this.parseContentText(ns, tag);
        try {
            return Utility.parseInt(text);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public String parseElementText(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.parseContentText(ns, tag);
    }

    public String parseElementText(String ns, String tag, String dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.parseContentText(ns, tag);
        }
        return dflt;
    }

    public String attributeText(String ns, String name) throws JiBXException {
        String value = this.getAttributeValue(ns, name);
        if (value == null) {
            throw new JiBXException("Missing required attribute " + UnmarshallingContext.buildNameString(ns, name) + " " + this.buildPositionString());
        }
        return value;
    }

    public String attributeText(String ns, String name, String dflt) {
        String value = this.getAttributeValue(ns, name);
        if (value == null) {
            return dflt;
        }
        return value;
    }

    public Object findID(String id, int index) throws JiBXException {
        HashMap map = this.m_idMaps[index];
        if (map != null) {
            Object obj = map.get(id);
            if (obj == null || obj instanceof BackFillHolder) {
                return null;
            }
            if (this.m_idClasses == null || this.m_idClasses[index].equals(obj.getClass().getName())) {
                return obj;
            }
            this.throwStartTagException("IDREF element content mapped to wrong type");
        }
        return null;
    }

    public Object findDefinedID(String id, int index) throws JiBXException {
        Object obj = this.findID(id, index);
        if (obj == null) {
            this.throwStartTagException("ID " + id + " not defined");
        }
        return obj;
    }

    public Object parseElementForwardIDREF(String ns, String tag, int index) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        this.m_idref = this.parseContentText(ns, tag);
        return this.findID(this.m_idref, index);
    }

    public Object attributeForwardIDREF(String ns, String name, int index) throws JiBXException {
        this.m_idref = this.attributeText(ns, name);
        return this.findID(this.m_idref, index);
    }

    public Object parseElementExistingIDREF(String ns, String tag, int index) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        this.m_idref = this.parseContentText(ns, tag);
        return this.findDefinedID(this.m_idref, index);
    }

    public Object attributeExistingIDREF(String ns, String name, int index) throws JiBXException {
        this.m_idref = this.attributeText(ns, name);
        return this.findDefinedID(this.m_idref, index);
    }

    public int attributeInt(String ns, String name) throws JiBXException {
        String text = this.attributeText(ns, name);
        try {
            return Utility.parseInt(text);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public int attributeInt(String ns, String name, int dflt) throws JiBXException {
        String value = this.getAttributeValue(ns, name);
        if (value == null) {
            return dflt;
        }
        try {
            return Utility.parseInt(value);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public int parseElementInt(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.parseContentInt(ns, tag);
    }

    public int parseElementInt(String ns, String tag, int dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.parseContentInt(ns, tag);
        }
        return dflt;
    }

    public int convertEnum(String target, String[] enums, int[] vals) throws JiBXException {
        if (target == null) {
            this.throwStartTagException("Missing required enumeration value");
        }
        try {
            return Utility.enumValue(target, enums, vals);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString());
        }
    }

    public int convertEnum(String target, String[] enums, int[] vals, int dflt) throws JiBXException {
        if (target == null) {
            return dflt;
        }
        try {
            return Utility.enumValue(target, enums, vals);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString());
        }
    }

    public int attributeEnumeration(String ns, String name, String[] enums, int[] vals) throws JiBXException {
        return this.convertEnum(this.getAttributeValue(ns, name), enums, vals);
    }

    public int attributeEnumeration(String ns, String name, String[] enums, int[] vals, int dflt) throws JiBXException {
        return this.convertEnum(this.getAttributeValue(ns, name), enums, vals, dflt);
    }

    public int parseContentEnumeration(String ns, String tag, String[] enums, int[] vals) throws JiBXException {
        return this.convertEnum(this.parseContentText(ns, tag), enums, vals);
    }

    public int parseElementEnumeration(String ns, String tag, String[] enums, int[] vals, int dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            String text = this.parseContentText(ns, tag);
            return this.convertEnum(text, enums, vals, dflt);
        }
        return dflt;
    }

    public byte convertByte(String text) throws JiBXException {
        try {
            return Utility.parseByte(text);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public byte attributeByte(String ns, String name) throws JiBXException {
        return this.convertByte(this.attributeText(ns, name));
    }

    public byte attributeByte(String ns, String name, byte dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        return this.convertByte(text);
    }

    public byte parseContentByte(String ns, String tag) throws JiBXException {
        return this.convertByte(this.parseContentText(ns, tag));
    }

    public byte parseElementByte(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.parseContentByte(ns, tag);
    }

    public byte parseElementByte(String ns, String tag, byte dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.convertByte(this.parseContentText(ns, tag));
        }
        return dflt;
    }

    public short convertShort(String text) throws JiBXException {
        try {
            return Utility.parseShort(text);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public short attributeShort(String ns, String name) throws JiBXException {
        return this.convertShort(this.attributeText(ns, name));
    }

    public short attributeShort(String ns, String name, short dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        return this.convertShort(text);
    }

    public short parseContentShort(String ns, String tag) throws JiBXException {
        return this.convertShort(this.parseContentText(ns, tag));
    }

    public short parseElementShort(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.parseContentShort(ns, tag);
    }

    public short parseElementShort(String ns, String tag, short dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.convertShort(this.parseContentText(ns, tag));
        }
        return dflt;
    }

    public char convertChar(String text) throws JiBXException {
        try {
            return Utility.parseChar(text);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public char attributeChar(String ns, String name) throws JiBXException {
        return this.convertChar(this.attributeText(ns, name));
    }

    public char attributeChar(String ns, String name, char dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        return this.convertChar(text);
    }

    public char parseContentChar(String ns, String tag) throws JiBXException {
        return this.convertChar(this.parseContentText(ns, tag));
    }

    public char parseElementChar(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.parseContentChar(ns, tag);
    }

    public char parseElementChar(String ns, String tag, char dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.convertChar(this.parseContentText(ns, tag));
        }
        return dflt;
    }

    public long convertLong(String text) throws JiBXException {
        try {
            return Utility.parseLong(text);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public long attributeLong(String ns, String name) throws JiBXException {
        return this.convertLong(this.attributeText(ns, name));
    }

    public long attributeLong(String ns, String name, long dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        return this.convertLong(text);
    }

    public long parseElementLong(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.convertLong(this.parseContentText(ns, tag));
    }

    public long parseElementLong(String ns, String tag, long dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.convertLong(this.parseContentText(ns, tag));
        }
        return dflt;
    }

    public boolean convertBoolean(String text) throws JiBXException {
        if ("true".equals(text) || "1".equals(text)) {
            return true;
        }
        if ("false".equals(text) || "0".equals(text)) {
            return false;
        }
        throw new JiBXException("Invalid boolean value " + this.buildPositionString());
    }

    public boolean attributeBoolean(String ns, String name) throws JiBXException {
        return this.convertBoolean(this.attributeText(ns, name));
    }

    public boolean attributeBoolean(String ns, String name, boolean dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        return this.convertBoolean(text);
    }

    public boolean parseElementBoolean(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.convertBoolean(this.parseContentText(ns, tag));
    }

    public boolean parseElementBoolean(String ns, String tag, boolean dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.convertBoolean(this.parseContentText(ns, tag));
        }
        return dflt;
    }

    public float convertFloat(String text) throws JiBXException {
        try {
            return Utility.parseFloat(text);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public float attributeFloat(String ns, String name) throws JiBXException {
        return this.convertFloat(this.attributeText(ns, name));
    }

    public float attributeFloat(String ns, String name, float dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        return this.convertFloat(text);
    }

    public float parseElementFloat(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.convertFloat(this.parseContentText(ns, tag));
    }

    public float parseElementFloat(String ns, String tag, float dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.convertFloat(this.parseContentText(ns, tag));
        }
        return dflt;
    }

    public double convertDouble(String text) throws JiBXException {
        try {
            return Utility.parseDouble(text);
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public double attributeDouble(String ns, String name) throws JiBXException {
        return this.convertDouble(this.attributeText(ns, name));
    }

    public double attributeDouble(String ns, String name, double dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        return this.convertDouble(text);
    }

    public double parseElementDouble(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.convertDouble(this.parseContentText(ns, tag));
    }

    public double parseElementDouble(String ns, String tag, double dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.convertDouble(this.parseContentText(ns, tag));
        }
        return dflt;
    }

    public Date convertDate(String text) throws JiBXException {
        try {
            return new Date(Utility.parseDateTime(text));
        }
        catch (JiBXException ex) {
            throw new JiBXException(ex.getMessage() + ' ' + this.buildPositionString(), ex.getRootCause());
        }
    }

    public Date attributeDate(String ns, String name) throws JiBXException {
        return this.convertDate(this.attributeText(ns, name));
    }

    public Date attributeDate(String ns, String name, Date dflt) throws JiBXException {
        String text = this.getAttributeValue(ns, name);
        if (text == null) {
            return dflt;
        }
        return this.convertDate(text);
    }

    public Date parseElementDate(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        return this.convertDate(this.parseContentText(ns, tag));
    }

    public Date parseElementDate(String ns, String tag, Date dflt) throws JiBXException {
        if (this.parseIfStartTag(ns, tag)) {
            return this.convertDate(this.parseContentText(ns, tag));
        }
        return dflt;
    }

    public void registerBackFill(String id, int index, BackFillReference fill) throws JiBXException {
        Object obj;
        HashMap<String, BackFillHolder> map = this.m_idMaps[index];
        if (map == null) {
            this.m_idMaps[index] = map = new HashMap<String, BackFillHolder>();
        }
        if ((obj = map.get(id)) == null) {
            String xclass = this.m_idClasses == null ? null : this.m_idClasses[index];
            BackFillHolder holder = new BackFillHolder(xclass);
            map.put(id, holder);
            holder.addBackFill(fill);
        } else if (obj instanceof BackFillHolder) {
            ((BackFillHolder)obj).addBackFill(fill);
        } else {
            throw new JiBXException("Internal operation error (back fill error) " + this.buildPositionString());
        }
    }

    public void registerBackFill(int index, BackFillReference fill) throws JiBXException {
        this.registerBackFill(this.m_idref, index, fill);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void defineID(String id, int index, Object obj) throws JiBXException {
        Object prior;
        HashMap<String, Object> map = this.m_idMaps[index];
        if (map == null) {
            this.m_idMaps[index] = map = new HashMap<String, Object>();
        }
        if ((prior = map.put(id, obj)) instanceof BackFillHolder) {
            BackFillHolder holder = (BackFillHolder)prior;
            String xclass = holder.getExpectedClass();
            if (xclass != null && !xclass.equals(obj.getClass().getName())) throw new JiBXException("ID object has wrong type " + this.buildPositionString());
            holder.defineValue(obj);
            return;
        } else {
            if (prior == null) return;
            throw new JiBXException("Duplicate ID definition " + this.buildPositionString());
        }
    }

    protected void mapUnmarshalling(int index) {
        Object value = this.m_unmarshalMap.get(this.m_names[index]);
        if (value instanceof Integer) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            list.add(this.m_indexes[index]);
            this.m_unmarshalMap.put(this.m_names[index], list);
        } else if (value instanceof ArrayList) {
            ArrayList list = (ArrayList)value;
            list.add(this.m_indexes[index]);
        } else {
            this.m_unmarshalMap.put(this.m_names[index], this.m_indexes[index]);
        }
    }

    public void addUnmarshalling(int index, String ns, String name, String cname) {
        this.m_namespaces[index] = ns;
        this.m_names[index] = name;
        this.m_unmarshallerClasses[index] = cname;
        if (this.m_unmarshalMap != null && name != null) {
            this.mapUnmarshalling(index);
        }
    }

    public void removeUnmarshalling(int index) {
        if (this.m_unmarshalMap != null && this.m_names[index] != null) {
            Object value = this.m_unmarshalMap.get(this.m_names[index]);
            if (value instanceof Integer) {
                this.m_unmarshalMap.remove(this.m_names[index]);
            } else if (value instanceof ArrayList) {
                ArrayList list = (ArrayList)value;
                list.remove(list.indexOf(this.m_indexes[index]));
            }
        }
        this.m_namespaces[index] = null;
        this.m_names[index] = null;
        this.m_unmarshallers[index] = null;
        this.m_unmarshallerClasses[index] = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IUnmarshaller getUnmarshaller(int index) throws JiBXException {
        if (this.m_unmarshallers[index] != null) {
            return this.m_unmarshallers[index];
        }
        Throwable throwable = null;
        try {
            try {
                IUnmarshaller um;
                Class<?> clas = null;
                String name = this.m_unmarshallerClasses[index];
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                if (loader != null) {
                    try {
                        clas = loader.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        // empty catch block
                    }
                }
                if (clas == null) {
                    clas = (class$org$jibx$runtime$impl$UnmarshallingContext == null ? (class$org$jibx$runtime$impl$UnmarshallingContext = UnmarshallingContext.class$("org.jibx.runtime.impl.UnmarshallingContext")) : class$org$jibx$runtime$impl$UnmarshallingContext).getClassLoader().loadClass(name);
                }
                this.m_unmarshallers[index] = um = (IUnmarshaller)clas.newInstance();
            }
            catch (ClassNotFoundException e) {
                ClassNotFoundException classNotFoundException = e;
                Object var8_17 = null;
                if (classNotFoundException == null) return this.m_unmarshallers[index];
                throw new JiBXException("Unable to create unmarshaller of class " + this.m_unmarshallerClasses[index] + ": " + classNotFoundException, classNotFoundException);
            }
            catch (ClassCastException e) {
                ClassCastException classCastException = e;
                Object var8_18 = null;
                if (classCastException == null) return this.m_unmarshallers[index];
                throw new JiBXException("Unable to create unmarshaller of class " + this.m_unmarshallerClasses[index] + ": " + classCastException, classCastException);
            }
            catch (InstantiationException e) {
                InstantiationException instantiationException = e;
                Object var8_19 = null;
                if (instantiationException == null) return this.m_unmarshallers[index];
                throw new JiBXException("Unable to create unmarshaller of class " + this.m_unmarshallerClasses[index] + ": " + instantiationException, instantiationException);
            }
            catch (IllegalAccessException e) {
                IllegalAccessException illegalAccessException = e;
                Object var8_20 = null;
                if (illegalAccessException == null) return this.m_unmarshallers[index];
                throw new JiBXException("Unable to create unmarshaller of class " + this.m_unmarshallerClasses[index] + ": " + illegalAccessException, illegalAccessException);
            }
            Object var8_16 = null;
            if (throwable == null) return this.m_unmarshallers[index];
            throw new JiBXException("Unable to create unmarshaller of class " + this.m_unmarshallerClasses[index] + ": " + throwable, throwable);
        }
        catch (Throwable throwable2) {
            Object var8_21 = null;
            if (throwable == null) throw throwable2;
            throw new JiBXException("Unable to create unmarshaller of class " + this.m_unmarshallerClasses[index] + ": " + throwable, throwable);
        }
    }

    public IUnmarshaller getUnmarshaller(String ns, String name) throws JiBXException {
        Object value;
        if (this.m_unmarshalMap == null) {
            this.m_unmarshalMap = new HashMap();
            this.m_indexes = new Integer[this.m_names.length];
            for (int i = 0; i < this.m_names.length; ++i) {
                this.m_indexes[i] = new Integer(i);
                if (this.m_names[i] == null) continue;
                this.mapUnmarshalling(i);
            }
        }
        if ((value = this.m_unmarshalMap.get(name)) instanceof Integer) {
            int index = (Integer)value;
            String mns = this.m_namespaces[index];
            if (ns == mns || ns == null && mns.length() == 0 || mns == null && ns.length() == 0 || ns != null && ns.equals(mns)) {
                return this.getUnmarshaller(index);
            }
        } else if (value instanceof ArrayList) {
            ArrayList list = (ArrayList)value;
            for (int i = 0; i < list.size(); ++i) {
                int index = (Integer)list.get(i);
                String mns = this.m_namespaces[index];
                if (!(ns == mns || ns == null && mns.length() == 0 || mns == null && ns.length() == 0) && (ns == null || !ns.equals(mns))) continue;
                return this.getUnmarshaller(index);
            }
        }
        return null;
    }

    public Object unmarshalOptionalElement() throws JiBXException {
        IUnmarshaller unmarshal;
        int type = this.toTag();
        if (type == 2 && (unmarshal = this.getUnmarshaller(this.m_parser.getNamespace(), this.m_parser.getName())) != null) {
            return unmarshal.unmarshal(null, this);
        }
        return null;
    }

    public Object unmarshalElement(Class clas) throws JiBXException {
        String name = this.toStart();
        IUnmarshaller unmarshal = this.getUnmarshaller(this.m_parser.getNamespace(), name);
        if (unmarshal == null) {
            throw new JiBXException("No unmarshaller for element " + this.currentNameString() + " " + this.buildPositionString());
        }
        Object obj = unmarshal.unmarshal(null, this);
        if (!clas.isInstance(obj)) {
            throw new JiBXException("Element " + name + " not compatible with expected type " + clas.getName() + " " + this.buildPositionString());
        }
        return obj;
    }

    public Object unmarshalElement() throws JiBXException {
        String name = this.toStart();
        IUnmarshaller unmarshal = this.getUnmarshaller(this.m_parser.getNamespace(), name);
        if (unmarshal == null) {
            throw new JiBXException("No unmarshaller for element " + this.currentNameString() + " " + this.buildPositionString());
        }
        return unmarshal.unmarshal(null, this);
    }

    public void parsePastElement(String ns, String tag) throws JiBXException {
        this.parsePastStartTag(ns, tag);
        int depth = 0;
        try {
            while (true) {
                switch (this.m_parser.getEventType()) {
                    case 3: {
                        if (depth == 0) {
                            if (this.m_parser.getName().equals(tag) && this.verifyNamespace(ns)) {
                                this.m_parser.nextToken();
                                return;
                            }
                            this.throwEndTagNameError(ns, tag);
                            break;
                        }
                        --depth;
                        break;
                    }
                    case 2: {
                        ++depth;
                        break;
                    }
                }
                this.m_parser.nextToken();
            }
        }
        catch (IOException ex) {
            throw new JiBXException("Error accessing document", ex);
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
        }
    }

    public String getElementName() throws JiBXException {
        try {
            int type = this.m_parser.getEventType();
            if (type == 2 || type == 3) {
                return this.m_parser.getName();
            }
            return null;
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
        }
    }

    public String getElementNamespace() throws JiBXException {
        try {
            int type = this.m_parser.getEventType();
            if (type == 2 || type == 3) {
                return this.m_parser.getNamespace();
            }
            return null;
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
        }
    }

    public void throwStartTagException(String msg) throws JiBXException {
        throw new JiBXException(msg + " at tag " + this.currentNameString() + this.buildPositionString());
    }

    public void throwStartTagException(String msg, Exception ex) throws JiBXException {
        throw new JiBXException(msg + " at tag " + this.currentNameString() + this.buildPositionString(), ex);
    }

    public void throwException(String msg) throws JiBXException {
        throw new JiBXException(msg + " " + this.buildPositionString());
    }

    public void throwException(String msg, Exception ex) throws JiBXException {
        throw new JiBXException(msg + " " + this.buildPositionString(), ex);
    }

    public Object unmarshalDocument(InputStream ins, String enc) throws JiBXException {
        this.setDocument(ins, enc);
        return this.unmarshalElement();
    }

    public Object unmarshalDocument(Reader rdr) throws JiBXException {
        this.setDocument(rdr);
        return this.unmarshalElement();
    }

    public Object unmarshalDocument(InputStream ins, String name, String enc) throws JiBXException {
        this.setDocument(ins, name, enc);
        return this.unmarshalElement();
    }

    public Object unmarshalDocument(Reader rdr, String name) throws JiBXException {
        this.setDocument(rdr, name);
        return this.unmarshalElement();
    }

    public String getDocumentName() {
        return this.m_docName;
    }

    public String getInputEncoding() {
        return this.m_streamWrapper.getEncoding();
    }

    public void pushObject(Object obj) {
        int depth = this.m_stackDepth;
        if (depth >= this.m_objectStack.length) {
            Object[] stack = new Object[depth * 2];
            System.arraycopy(this.m_objectStack, 0, stack, 0, depth);
            this.m_objectStack = stack;
        }
        this.m_objectStack[depth] = obj;
        ++this.m_stackDepth;
        if (obj instanceof ITrackSourceImpl) {
            ((ITrackSourceImpl)obj).jibx_setSource(this.m_docName, this.m_parser.getLineNumber(), this.m_parser.getColumnNumber());
        }
    }

    public void popObject() throws JiBXException {
        if (this.m_stackDepth > 0) {
            --this.m_stackDepth;
        } else {
            throw new JiBXException("No object on stack");
        }
    }

    public int getStackDepth() {
        return this.m_stackDepth;
    }

    public Object getStackObject(int depth) {
        if (depth >= 0 && depth < this.m_stackDepth) {
            return this.m_objectStack[this.m_stackDepth - depth - 1];
        }
        throw new ArrayIndexOutOfBoundsException("Depth " + depth + " is out of range");
    }

    public Object getStackTop() {
        if (this.m_stackDepth > 0) {
            return this.m_objectStack[this.m_stackDepth - 1];
        }
        return null;
    }

    public int getActiveNamespaceCount() throws JiBXException {
        try {
            return this.m_parser.getNamespaceCount(this.m_parser.getDepth());
        }
        catch (XmlPullParserException e) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), e);
        }
    }

    public String getActiveNamespaceUri(int index) throws JiBXException {
        try {
            return this.m_parser.getNamespaceUri(index);
        }
        catch (XmlPullParserException e) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), e);
        }
    }

    public String getActiveNamespacePrefix(int index) throws JiBXException {
        try {
            return this.m_parser.getNamespacePrefix(index);
        }
        catch (XmlPullParserException e) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), e);
        }
    }

    public void skipElement() throws JiBXException {
        if (!this.isEnd()) {
            this.next();
            int depth = 1;
            while (depth > 0) {
                depth = this.isEnd() ? --depth : ++depth;
                this.next();
            }
        }
    }

    public int next() throws JiBXException {
        try {
            return this.m_parser.next();
        }
        catch (IOException ex) {
            throw new JiBXException("Error accessing document", ex);
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
        }
    }

    public int nextToken() throws JiBXException {
        try {
            return this.m_parser.nextToken();
        }
        catch (IOException ex) {
            throw new JiBXException("Error accessing document", ex);
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
        }
    }

    public int currentEvent() throws JiBXException {
        try {
            return this.m_parser.getEventType();
        }
        catch (XmlPullParserException ex) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), ex);
        }
    }

    public String getName() throws JiBXException {
        return this.m_parser.getName();
    }

    public String getNamespace() throws JiBXException {
        return this.m_parser.getNamespace();
    }

    public String getPrefix() throws JiBXException {
        return this.m_parser.getPrefix();
    }

    public int getAttributeCount() throws JiBXException {
        return this.m_parser.getAttributeCount();
    }

    public String getAttributeName(int index) throws JiBXException {
        return this.m_parser.getAttributeName(index);
    }

    public String getAttributeNamespace(int index) throws JiBXException {
        return this.m_parser.getAttributeNamespace(index);
    }

    public String getAttributePrefix(int index) throws JiBXException {
        return this.m_parser.getAttributePrefix(index);
    }

    public String getAttributeValue(int index) throws JiBXException {
        return this.m_parser.getAttributeValue(index);
    }

    public int getNamespaceCount() throws JiBXException {
        try {
            int level = this.m_parser.getDepth();
            return this.m_parser.getNamespaceCount(level) - this.m_parser.getNamespaceCount(level - 1);
        }
        catch (XmlPullParserException e) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), e);
        }
    }

    public String getNamespaceUri(int index) throws JiBXException {
        try {
            int base = this.m_parser.getNamespaceCount(this.m_parser.getDepth() - 1);
            return this.m_parser.getNamespaceUri(base + index);
        }
        catch (XmlPullParserException e) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), e);
        }
    }

    public String getNamespacePrefix(int index) throws JiBXException {
        try {
            int base = this.m_parser.getNamespaceCount(this.m_parser.getDepth() - 1);
            return this.m_parser.getNamespacePrefix(base + index);
        }
        catch (XmlPullParserException e) {
            throw new JiBXException("Error parsing document " + this.buildPositionString(), e);
        }
    }

    public String getText() throws JiBXException {
        return this.m_parser.getText();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

