/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl;

public class CMarkerSequence {
    public int nmc;
    public int[][] mcidx;
    public boolean[] incms;
    public int ncs = 0;
    public int[] css;
    public boolean[] frames;
    public int[][] idx1;
    public int[][] idx2;

    public CMarkerSequence(int[][] mcidx, int nmc) {
        this.nmc = nmc;
        this.mcidx = mcidx;
        this.css = new int[nmc / 2];
        this.frames = new boolean[nmc / 2];
        this.idx1 = new int[nmc / 2][nmc];
        this.idx2 = new int[nmc / 2][nmc];
        this.incms = new boolean[nmc];
    }

    public int[] getCSIdx(int i, int m1) {
        if (i == 0 || i == 1) {
            int[] idx = new int[2];
            int j = 0;
            while (j < this.ncs) {
                int k = 0;
                while (k < this.css[j]) {
                    if (i == 0 && this.idx1[j][k] == m1) {
                        idx[0] = j;
                        idx[1] = k;
                        return idx;
                    }
                    if (i == 1 && this.idx2[j][k] == m1) {
                        idx[0] = j;
                        idx[1] = k;
                        return idx;
                    }
                    ++k;
                }
                ++j;
            }
        }
        return null;
    }

    public int[] getLeftCSMarker(int cs1, int m1x) {
        int[] idx = new int[2];
        if (m1x > 0) {
            idx[0] = cs1;
            idx[1] = m1x - 1;
        } else if (cs1 > 0) {
            idx[0] = cs1 - 1;
            idx[1] = this.css[idx[0]] - 1;
        } else {
            idx[0] = cs1;
            idx[0] = m1x;
        }
        return idx;
    }

    public int[] getRightCSMarker(int cs2, int m2x) {
        int[] idx = new int[2];
        if (m2x < this.css[cs2] - 1) {
            idx[0] = cs2;
            idx[1] = m2x + 1;
        } else if (cs2 < this.ncs - 1) {
            idx[0] = cs2 + 1;
            idx[1] = 0;
        } else {
            idx[0] = cs2;
            idx[1] = m2x;
        }
        return idx;
    }

    public int getMarkerIdx(int i, int cidx, int midx) {
        if (i == 0 || i == 1) {
            if (i == 0) {
                return this.idx1[cidx][midx];
            }
            return this.idx2[cidx][midx];
        }
        return -1;
    }

    public boolean haveSameFrame(int cs1, int cs2) {
        return this.frames[cs1] && this.frames[cs2] || !this.frames[cs1] && !this.frames[cs2];
    }
}

