/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.metaqtl.Qtl;
import org.metaqtl.bio.IBioOntology;
import org.metaqtl.bio.IBioOntologyTerm;

public class MetaQtlData {
    protected Qtl[] qtls = null;
    protected int ntg = 0;
    protected int[] ntgQtls = null;
    protected String[] tgnames = null;
    protected int[][] tgidx = null;

    public MetaQtlData(Qtl[] qtls) {
        this.qtls = qtls;
    }

    public void doTraitGroupClustering() {
        ArrayList list;
        ArrayList<Integer> undef = null;
        if (this.qtls == null) {
            return;
        }
        Hashtable<String, ArrayList> hash = new Hashtable<String, ArrayList>();
        int i = 0;
        while (i < this.qtls.length) {
            if (this.qtls[i].trait != null) {
                if (this.qtls[i].trait.group != null) {
                    if (!hash.containsKey(this.qtls[i].trait.group)) {
                        list = new ArrayList();
                        hash.put(this.qtls[i].trait.group, list);
                    } else {
                        list = (ArrayList)hash.get(this.qtls[i].trait.group);
                    }
                    list.add(new Integer(i));
                } else {
                    if (!hash.containsKey(this.qtls[i].trait.name)) {
                        list = new ArrayList();
                        hash.put(this.qtls[i].trait.name, list);
                    } else {
                        list = (ArrayList)hash.get(this.qtls[i].trait.name);
                    }
                    list.add(new Integer(i));
                }
            } else {
                if (undef == null) {
                    undef = new ArrayList<Integer>();
                }
                undef.add(new Integer(i));
            }
            ++i;
        }
        this.ntg = hash.size();
        if (this.ntg > 0) {
            this.tgnames = new String[this.ntg];
            this.ntgQtls = new int[this.ntg];
            this.tgidx = new int[this.ntg][];
            i = 0;
            Enumeration e = hash.keys();
            while (e.hasMoreElements()) {
                this.tgnames[i] = (String)e.nextElement();
                list = (ArrayList)hash.get(this.tgnames[i]);
                this.ntgQtls[i] = list.size();
                this.tgidx[i] = new int[list.size()];
                int j = 0;
                while (j < list.size()) {
                    this.tgidx[i][j] = (Integer)list.get(j);
                    ++j;
                }
                ++i;
            }
        }
        if (undef != null) {
            i = 0;
            while (i < undef.size()) {
                System.err.println("[ WARNING ]");
                System.err.println("Any Trait or Group Trait defined for QTL : " + this.qtls[((Integer)undef.get((int)i)).intValue()].name);
                ++i;
            }
        }
    }

    public Double[][] getDataPoints(int tg, boolean ignore) {
        Double[][] xy = null;
        ArrayList<Double> xl = null;
        ArrayList<Double> sdl = null;
        int j = 0;
        int n = 0;
        while (j < this.ntgQtls[tg]) {
            if (!this.qtls[this.tgidx[tg][j]].isIgnore() || !ignore) {
                ++n;
                if (xl == null) {
                    xl = new ArrayList<Double>();
                    sdl = new ArrayList<Double>();
                }
                xl.add(new Double(this.qtls[this.tgidx[tg][j]].position));
                sdl.add(new Double(this.qtls[this.tgidx[tg][j]].sd_position));
            }
            ++j;
        }
        if (n > 0) {
            xy = new Double[2][n];
            xl.toArray(xy[0]);
            sdl.toArray(xy[1]);
        }
        return xy;
    }

    public void doTraitOntologyClustering(IBioOntology ontology) {
        ArrayList clist;
        ArrayList list;
        IBioOntologyTerm term;
        if (ontology == null) {
            this.doTraitGroupClustering();
        }
        ArrayList<Integer> undef = null;
        Hashtable<IBioOntologyTerm, ArrayList> hash = new Hashtable<IBioOntologyTerm, ArrayList>();
        Hashtable<IBioOntologyTerm, ArrayList> parent = new Hashtable<IBioOntologyTerm, ArrayList>();
        Hashtable move = new Hashtable();
        IBioOntologyTerm root = ontology.getRoot();
        int i = 0;
        while (i < this.qtls.length) {
            if (this.qtls[i].trait != null) {
                String termName = this.qtls[i].trait.name;
                term = ontology.getTerm(termName);
                if (term != null) {
                    if (!hash.containsKey(term)) {
                        list = new ArrayList();
                        hash.put(term, list);
                        clist = null;
                        if (!parent.containsKey(term.getParentTerm())) {
                            if (term.getParentTerm() != root) {
                                clist = new ArrayList();
                                parent.put(term.getParentTerm(), clist);
                            }
                        } else {
                            clist = (ArrayList)parent.get(term.getParentTerm());
                        }
                        if (clist != null) {
                            clist.add(term);
                        }
                    } else {
                        list = (ArrayList)hash.get(term);
                    }
                    list.add(new Integer(i));
                } else {
                    if (undef == null) {
                        undef = new ArrayList<Integer>();
                    }
                    undef.add(new Integer(i));
                }
            }
            ++i;
        }
        Enumeration e = parent.keys();
        while (e.hasMoreElements()) {
            term = (IBioOntologyTerm)e.nextElement();
            this.moveUpParentTerm(term, parent, move);
        }
        e = parent.keys();
        this.ntg = 0;
        while (e.hasMoreElements()) {
            term = (IBioOntologyTerm)e.nextElement();
            clist = (ArrayList)parent.get(term);
            if (move.containsKey(term)) continue;
            ++this.ntg;
        }
        this.tgnames = new String[this.ntg];
        this.ntgQtls = new int[this.ntg];
        this.tgidx = new int[this.ntg][];
        e = parent.keys();
        this.ntg = 0;
        while (e.hasMoreElements()) {
            term = (IBioOntologyTerm)e.nextElement();
            clist = (ArrayList)parent.get(term);
            if (move.containsKey(term)) continue;
            this.tgnames[this.ntg] = term.getName();
            this.ntgQtls[this.ntg] = 0;
            i = 0;
            while (i < clist.size()) {
                term = (IBioOntologyTerm)clist.get(i);
                list = (ArrayList)hash.get(term);
                int n = this.ntg;
                this.ntgQtls[n] = this.ntgQtls[n] + list.size();
                ++i;
            }
            this.tgidx[this.ntg] = new int[this.ntgQtls[this.ntg]];
            i = 0;
            int j = 0;
            while (i < clist.size()) {
                term = (IBioOntologyTerm)clist.get(i);
                list = (ArrayList)hash.get(term);
                int k = 0;
                while (k < list.size()) {
                    this.tgidx[this.ntg][j] = (Integer)list.get(k);
                    ++k;
                    ++j;
                }
                ++i;
            }
            ++this.ntg;
        }
        if (undef != null) {
            i = 0;
            while (i < undef.size()) {
                ++i;
            }
        }
    }

    private void moveUpParentTerm(IBioOntologyTerm term, Hashtable parent, Hashtable move) {
        IBioOntologyTerm p = term.getParentTerm();
        if (p != null && parent.containsKey(p)) {
            if (move.containsKey(p)) {
                p = (IBioOntologyTerm)move.get(p);
            }
            ArrayList plist = (ArrayList)parent.get(p);
            ArrayList clist = (ArrayList)parent.get(term);
            int i = 0;
            while (i < clist.size()) {
                plist.add(clist.get(i));
                ++i;
            }
            move.put(term, p);
        }
    }

    public int getQtlNumber() {
        int nqtl = 0;
        if (this.ntgQtls != null) {
            int i = 0;
            while (i < this.ntg) {
                nqtl += this.ntgQtls[i];
                ++i;
            }
        }
        return nqtl;
    }

    public void manageMissingData(int opt) {
        int i = 0;
        while (i < this.ntg) {
            double sd_mean = 0.0;
            int sd_n = 0;
            int j = 0;
            while (j < this.ntgQtls[i]) {
                if (this.qtls[this.tgidx[i][j]].sd_position <= 0.0) {
                    this.qtls[this.tgidx[i][j]].setIgnore(true);
                } else {
                    sd_mean += this.qtls[this.tgidx[i][j]].sd_position;
                    ++sd_n;
                }
                ++j;
            }
            sd_mean = sd_n > 0 ? (sd_mean /= (double)sd_n) : 0.0;
            if (sd_mean > 0.0 && opt == 1) {
                j = 0;
                while (j < this.ntgQtls[i]) {
                    if (this.qtls[this.tgidx[i][j]].isIgnore()) {
                        this.qtls[this.tgidx[i][j]].setIgnore(false);
                        this.qtls[this.tgidx[i][j]].sd_position = sd_mean;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public int getTraitClusterNumber() {
        return this.ntg;
    }

    public String getTraitClusterName(int i) {
        return this.tgnames[i];
    }

    public int[] getQtlIdx(int i) {
        int[] idx = null;
        int j = 0;
        int k = 0;
        while (j < this.ntgQtls[i]) {
            if (!this.qtls[this.tgidx[i][j]].isIgnore()) {
                ++k;
            }
            ++j;
        }
        if (k > 0) {
            idx = new int[k];
            j = 0;
            k = 0;
            while (j < this.ntgQtls[i]) {
                if (!this.qtls[this.tgidx[i][j]].isIgnore()) {
                    idx[k++] = this.tgidx[i][j];
                }
                ++j;
            }
        }
        return idx;
    }

    public String[] getTraitClusterNames() {
        return this.tgnames;
    }

    public int getTraitClusterSize(int i) {
        return this.ntgQtls[i];
    }

    public Qtl getQtl(int i, int j) {
        return this.qtls[this.tgidx[i][j]];
    }
}

