/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl;

public class MetaQtlModel {
    private String criterion;
    public String[] chromNames;
    public String[][] traitNames;
    public int[][] models;

    public MetaQtlModel() {
    }

    public MetaQtlModel(int nchr) {
        this.chromNames = new String[nchr];
        this.traitNames = new String[nchr][];
        this.models = new int[nchr][];
    }

    public String[] getChromNames() {
        return this.chromNames;
    }

    public String[] getTraitNames(String chrom) {
        if (this.chromNames == null) {
            return null;
        }
        int i = 0;
        while (i < this.chromNames.length) {
            if (this.chromNames[i].equals(chrom)) {
                return this.traitNames[i];
            }
            ++i;
        }
        return null;
    }

    public String[] getTraitNames(int cidx) {
        if (this.chromNames == null) {
            return null;
        }
        return this.traitNames[cidx];
    }

    public int getModel(String chrom, String trait) {
        if (this.chromNames == null) {
            return 0;
        }
        int i = 0;
        while (i < this.chromNames.length) {
            if (this.chromNames[i].equals(chrom)) {
                int j = 0;
                while (j < this.traitNames[i].length) {
                    if (this.traitNames[i][j].equals(trait)) {
                        return this.models[i][j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        return 0;
    }

    public void setModel(int cidx, int[] models) {
        if (models == null) {
            return;
        }
        this.models[cidx] = new int[models.length];
        int i = 0;
        while (i < models.length) {
            this.models[cidx][i] = models[i];
            ++i;
        }
    }

    public void setChromName(int cidx, String name) {
        this.chromNames[cidx] = new String(name);
    }

    public void setTraitNames(int cidx, String[] traits) {
        if (traits == null) {
            return;
        }
        this.traitNames[cidx] = new String[traits.length];
        int i = 0;
        while (i < traits.length) {
            this.traitNames[cidx][i] = new String(traits[i]);
            ++i;
        }
    }

    public void setCriterion(String critName) {
        this.criterion = new String(critName);
    }

    public int getModel(int i, int j) {
        return this.models[i][j];
    }

    public String getCriterion() {
        return this.criterion;
    }
}

