/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl;

import java.util.Iterator;
import java.util.List;
import org.metaqtl.EMCriteria;
import org.metaqtl.EMResult;
import org.metaqtl.Qtl;
import org.metaqtl.Tree;
import org.metaqtl.adapter.QtlAdapter;

public class MetaQtlResult {
    public String trait = null;
    public int nqtl = 0;
    public int nmqc = 0;
    public int[] qtlIdx = null;
    public double[] x = null;
    public double[] sd = null;
    public EMResult[] clusterings = null;
    public Tree tree = null;

    public MetaQtlResult() {
    }

    public MetaQtlResult(String trait, int qtlNumber) {
        this.nqtl = qtlNumber;
        this.qtlIdx = new int[this.nqtl];
        this.x = new double[this.nqtl];
        this.sd = new double[this.nqtl];
        this.trait = trait;
    }

    public EMResult getClustering(int k) {
        if (this.clusterings == null || this.clusterings.length < k + 1 || k < 0) {
            return null;
        }
        if (k < 0) {
            return this.clusterings[0];
        }
        if (k > this.nmqc) {
            return this.clusterings[this.nmqc - 1];
        }
        return this.clusterings[k - 1];
    }

    public void setClusterings(List list) {
        if (list == null) {
            return;
        }
        this.nmqc = list.size();
        this.clusterings = new EMResult[this.nmqc];
        list.toArray(this.clusterings);
    }

    public void setClusterings(EMResult[] results) {
        if (results == null) {
            return;
        }
        this.nmqc = results.length;
        this.clusterings = results;
    }

    public void setQtlIdx(int[] qtlIdx) {
        this.qtlIdx = qtlIdx;
    }

    public void setX(Double[] xx) {
        if (xx == null) {
            return;
        }
        int i = 0;
        while (i < this.nqtl) {
            this.x[i] = xx[i];
            ++i;
        }
    }

    public void setSD(Double[] sd) {
        if (sd == null) {
            return;
        }
        int i = 0;
        while (i < this.nqtl) {
            this.sd[i] = sd[i];
            ++i;
        }
    }

    public void setTree(Tree tree) {
        this.tree = tree;
    }

    public EMResult getBestClustering(int criterion) {
        return EMCriteria.getBestResult(this.clusterings, criterion);
    }

    public String getTraitName() {
        return this.trait;
    }

    public int[] getKValues() {
        if (this.clusterings == null) {
            return null;
        }
        int nk = 0;
        int i = 0;
        while (i < this.clusterings.length) {
            if (this.clusterings[i] != null) {
                ++nk;
            }
            ++i;
        }
        int[] K = new int[nk];
        int j = 0;
        int i2 = 0;
        while (i2 < this.clusterings.length) {
            if (this.clusterings[i2] != null) {
                K[j++] = this.clusterings[i2].k;
            }
            ++i2;
        }
        return K;
    }

    public Iterator getCriteria() {
        return EMCriteria.getCriteria();
    }

    public double[] getCritValues(String criterion, int[] K) {
        if (this.clusterings == null) {
            return null;
        }
        int cidx = EMCriteria.getCriterionIdx(criterion);
        double[] values = new double[K.length];
        int i = 0;
        while (i < this.clusterings.length) {
            if (this.clusterings[i] != null) {
                int j = 0;
                while (j < K.length) {
                    if (K[j] == this.clusterings[i].k) {
                        values[j] = this.clusterings[i].getCriterion(cidx);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return values;
    }

    public double[] getCritDelta(String criterion, int[] K) {
        if (this.clusterings == null) {
            return null;
        }
        int cidx = EMCriteria.getCriterionIdx(criterion);
        double[] delta = new double[K.length];
        double best = this.getBestClustering(cidx).getCriterion(cidx);
        int i = 0;
        while (i < this.clusterings.length) {
            if (this.clusterings[i] != null) {
                int j = 0;
                while (j < K.length) {
                    if (K[j] == this.clusterings[i].k) {
                        delta[j] = this.clusterings[i].getCriterion(cidx) - best;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return delta;
    }

    public double[] getCritWeights(String criterion, int[] K) {
        if (this.clusterings == null) {
            return null;
        }
        int cidx = EMCriteria.getCriterionIdx(criterion);
        double[] weights = new double[K.length];
        double best = this.getBestClustering(cidx).getCriterion(cidx);
        double sum = 0.0;
        int i = 0;
        while (i < this.clusterings.length) {
            if (this.clusterings[i] != null) {
                int j = 0;
                while (j < K.length) {
                    if (K[j] == this.clusterings[i].k) {
                        weights[j] = Math.exp(-0.5 * (this.clusterings[i].getCriterion(cidx) - best));
                        sum += weights[j];
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < K.length) {
            int n = i++;
            weights[n] = weights[n] / sum;
        }
        return weights;
    }

    public double[] getUSD(EMResult best, int kmin, int kmax, String criterion) {
        EMResult result;
        int[] K = this.getKValues();
        int[] nsd = new int[best.k];
        double[] w = this.getCritWeights(criterion, K);
        double[] usd = new double[best.k];
        double[] xsd = new double[best.n];
        double[] wxp = new double[best.n];
        int j = 0;
        while (j < K.length) {
            if (K[j] >= kmin && K[j] <= kmax) {
                result = this.getClustering(K[j]);
                double[] xp = result.getXBestPred();
                int i = 0;
                while (i < result.n) {
                    int n = i;
                    wxp[n] = wxp[n] + w[j] * xp[i];
                    ++i;
                }
            }
            ++j;
        }
        j = 0;
        while (j < K.length) {
            if (K[j] >= kmin && K[j] <= kmax) {
                result = this.getClustering(K[j]);
                int i = 0;
                while (i < result.n) {
                    int xk = result.getXPredIdx(i);
                    double sd = wxp[i] - result.getMu(xk);
                    sd *= sd;
                    int n = i++;
                    xsd[n] = xsd[n] + w[j] * Math.sqrt(sd += result.ocov[xk][xk]);
                }
            }
            ++j;
        }
        int i = 0;
        while (i < best.n) {
            int xk;
            int n = xk = best.getXPredIdx(i);
            nsd[n] = nsd[n] + 1;
            int n2 = xk;
            usd[n2] = usd[n2] + xsd[i];
            ++i;
        }
        i = 0;
        while (i < best.k) {
            int n = i;
            usd[n] = usd[n] / (double)nsd[i];
            ++i;
        }
        return usd;
    }

    public Tree getQtlTree() {
        return this.tree;
    }

    public Qtl[] getMetaQtl(int k) {
        EMResult result = this.getClustering(k);
        if (result == null) {
            return null;
        }
        Qtl[] qtls = QtlAdapter.adapt(result);
        if (qtls != null) {
            int i = 0;
            while (i < qtls.length) {
                qtls[i].name = new String("MQTL_" + (i + 1) + "_" + this.trait);
                qtls[i].trait = new Qtl.QTLTrait(qtls[i]);
                qtls[i].trait.name = this.trait;
                ++i;
            }
        }
        return qtls;
    }
}

