/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.bio.entity.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Hashtable;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;
import org.metaqtl.bio.IBioEntity;
import org.metaqtl.bio.IBioLGroup;
import org.metaqtl.bio.IBioLocus;
import org.metaqtl.bio.entity.GeneticMap;
import org.metaqtl.bio.entity.LGroup;
import org.metaqtl.bio.entity.Marker;
import org.metaqtl.bio.entity.factory.BioEntityFactory;
import org.metaqtl.bio.util.StaticLocusPosition;

public class MapMakerFactory
extends BioEntityFactory {
    public IBioEntity load(Reader reader) throws IOException {
        GeneticMap map = new GeneticMap();
        LGroup group = null;
        boolean first = true;
        double distance = 0.0;
        RE rChr = null;
        RE rName = null;
        RE rMarker = null;
        RE rLastMarker = null;
        RE rChrMercator = null;
        try {
            rChr = new RE("^\\*\\s*(.+?)\\s*$");
            rChrMercator = new RE("^\\chromosome\\s*(.+?)\\s*$");
            rName = new RE("^mapname=(.+)$");
            rMarker = new RE("^\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s+\\cM*");
            rLastMarker = new RE("^\\s+\\S*\\s+(\\S+)\\s+\\-+");
        }
        catch (RESyntaxException re) {
            System.out.println(re);
        }
        BufferedReader red = new BufferedReader(reader);
        try {
            String line;
            while ((line = red.readLine()) != null) {
                if (rName.match(line)) {
                    map.setName(rName.getParen(1));
                }
                if (rChr.match(line) || rChrMercator.match(line)) {
                    group = new LGroup(rChr.getParen(1), null);
                }
                if (rMarker.match(line)) {
                    Marker mrk = new Marker();
                    mrk.setGroup(group);
                    mrk.setName(rMarker.getParen(2));
                    String distTemp = rMarker.getParen(3);
                    if (first) {
                        mrk.setPosition(new StaticLocusPosition(0.0));
                        distance = Double.parseDouble(distTemp);
                        first = false;
                    } else {
                        NumberFormat form = NumberFormat.getInstance();
                        form.setMaximumFractionDigits(2);
                        String temp = form.format(distance);
                        temp = temp.replace(',', '.');
                        double doudou = Double.parseDouble(temp);
                        mrk.setPosition(new StaticLocusPosition(doudou));
                        distance += Double.parseDouble(distTemp);
                    }
                    group.addLocus(mrk);
                }
                if (!rLastMarker.match(line)) continue;
                NumberFormat form = NumberFormat.getInstance();
                Marker mrk = new Marker();
                mrk.setGroup(group);
                mrk.setName(rLastMarker.getParen(1));
                String temp = form.format(distance);
                temp = temp.replace(',', '.');
                double dist = Double.parseDouble(temp);
                mrk.setPosition(new StaticLocusPosition(dist));
                group.addLocus(mrk);
                map.addGroup(group);
                distance = 0.0;
                first = true;
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return map;
    }

    public IBioEntity load(InputStream stream) throws IOException {
        InputStreamReader r = new InputStreamReader(stream);
        return this.load(r);
    }

    public void unload(IBioEntity obj, Writer w) throws IOException {
        GeneticMap map = (GeneticMap)obj;
        PrintWriter writer = new PrintWriter(w);
        writer.println("mapname=" + map.getName());
        IBioLGroup[] groups = map.groups();
        int i = 0;
        while (i < groups.length) {
            int maxName = 0;
            int maxDist = 0;
            double lastDist = 0.0;
            NumberFormat form = NumberFormat.getInstance();
            form.setMaximumFractionDigits(1);
            Hashtable<String, String> pairwiseDistance = new Hashtable<String, String>(groups[i].getLocusNumber() - 1);
            IBioLocus[] markers = groups[i].loci();
            this.sortPosition(markers);
            int j = 0;
            while (j < markers.length) {
                IBioLocus mrk = markers[j];
                if (mrk.getName().length() > maxName) {
                    maxName = mrk.getName().length();
                }
                if (j < markers.length - 1) {
                    String pwdist = form.format(markers[j + 1].getPosition().absolute() - mrk.getPosition().absolute());
                    pairwiseDistance.put(mrk.getName(), pwdist);
                    lastDist = mrk.getPosition().absolute();
                    if (pwdist.length() > maxDist) {
                        maxDist = pwdist.length();
                    }
                } else {
                    lastDist = mrk.getPosition().absolute();
                }
                ++j;
            }
            writer.println("*" + groups[i].getName());
            writer.println(">map");
            writer.println("===========================================================================");
            writer.println("Map:");
            writer.write("  Markers");
            writer.write(this._print_space(3 + maxName + 6 - new String("Markers").length()));
            writer.write("Distance\n");
            j = 0;
            while (j < markers.length) {
                writer.write("   " + (j + 1) + "  " + markers[j].getName());
                String distance = (String)pairwiseDistance.get(markers[j].getName());
                if (distance != null) {
                    distance = distance.replace(',', '.');
                }
                if (j < markers.length - 1) {
                    writer.write(this._print_space(7 + maxName - markers[j].getName().length() + maxDist - distance.length()));
                    writer.write(String.valueOf(distance) + " cM\n");
                } else {
                    writer.write(this._print_space(5 + maxName - markers[j].getName().length()));
                    writer.write("----------\n");
                }
                ++j;
            }
            writer.write(this._print_space(3 + maxName + 6));
            String position = form.format(lastDist);
            position = position.replace(',', '.');
            writer.write(String.valueOf(position) + " cM " + markers.length + " markers   log-likelihood=\n");
            writer.println("===========================================================================");
            ++i;
        }
        try {
            w.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String _print_space(int nb) {
        String toto = "";
        int i = 0;
        while (i < nb) {
            toto = String.valueOf(toto) + " ";
            ++i;
        }
        return toto;
    }

    private void sortPosition(IBioLocus[] markers) {
        int N = markers.length;
        int i = 0;
        while (i < N - 1) {
            int min = i;
            int j = i + 1;
            while (j < N) {
                if (markers[j].getPosition().absolute() < markers[min].getPosition().absolute()) {
                    min = j;
                }
                ++j;
            }
            IBioLocus t = markers[min];
            markers[min] = markers[i];
            markers[i] = t;
            ++i;
        }
    }

    public void unload(IBioEntity entity, OutputStream stream) throws IOException {
        this.unload(entity, new OutputStreamWriter(stream));
    }
}

