/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.bio.entity.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.metaqtl.bio.IBioEntity;
import org.metaqtl.bio.entity.Ontology;
import org.metaqtl.bio.entity.OntologyTerm;
import org.metaqtl.bio.entity.factory.BioEntityFactory;

public class OntologyTabFactory
extends BioEntityFactory {
    public static final String[] HEADER = new String[]{"Term_id", "Term_name", "Parent_id", "Synonyms", "Definition"};

    public IBioEntity load(InputStream inputStream) throws IOException {
        InputStreamReader reader = new InputStreamReader(inputStream);
        return this.load(reader);
    }

    public IBioEntity load(Reader reader) throws IOException {
        OntologyTerm root = null;
        Hashtable<String, ArrayList> terms = null;
        Ontology ontology = new Ontology();
        BufferedReader buffer = new BufferedReader(reader);
        try {
            int i;
            int idx;
            int[] hidx;
            String line = buffer.readLine();
            StringTokenizer token = new StringTokenizer(line, "\t");
            if (token.countTokens() == HEADER.length) {
                hidx = new int[HEADER.length];
                idx = 0;
                while (token.hasMoreTokens()) {
                    i = 0;
                    while (i < HEADER.length) {
                        if (HEADER[i].equalsIgnoreCase(token.nextToken())) {
                            hidx[i] = idx++;
                        }
                        ++i;
                    }
                }
                if (idx != HEADER.length) {
                    throw new IOException("Bad header column names");
                }
            } else {
                throw new IOException("Bad header format");
            }
            terms = new Hashtable<String, ArrayList>();
            String[] fields = new String[HEADER.length];
            int cnt = 1;
            while ((line = buffer.readLine()) != null) {
                token = new StringTokenizer(line, "\t", true);
                if (token.countTokens() >= HEADER.length) {
                    ArrayList children;
                    i = 0;
                    while (i < HEADER.length) {
                        fields[i] = "";
                        ++i;
                    }
                    idx = 0;
                    while (token.hasMoreTokens()) {
                        String sbuff = token.nextToken();
                        if (sbuff.equals("\t")) continue;
                        fields[idx++] = sbuff;
                    }
                    if (!fields[hidx[2]].equals("")) {
                        if (!terms.containsKey(fields[hidx[2]])) {
                            children = new ArrayList();
                            terms.put(fields[hidx[2]], children);
                        } else {
                            children = (ArrayList)terms.get(fields[hidx[2]]);
                        }
                    } else {
                        children = null;
                    }
                    OntologyTerm term = new OntologyTerm();
                    term.setID(Long.parseLong(fields[hidx[0]]));
                    term.setName(fields[hidx[1]]);
                    Properties prop = term.getProperties();
                    prop.setProperty("term.synonyms", fields[hidx[3]]);
                    prop.setProperty("term.definition", fields[hidx[4]]);
                    term.setProperties(prop);
                    if (!fields[hidx[2]].equals("")) {
                        children.add(term);
                    } else {
                        root = term;
                    }
                } else {
                    throw new IOException("Bad line format at " + cnt);
                }
                ++cnt;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (terms != null) {
            ontology = new Ontology();
            OntologyTerm[] tree = this.buildTree(root, terms);
            root.setChildren(tree);
            ontology.setRoot(root);
        }
        return ontology;
    }

    public void unload(IBioEntity entity, Writer writer) throws IOException {
    }

    public void unload(IBioEntity entity, OutputStream stream) throws IOException {
    }

    private OntologyTerm[] buildTree(OntologyTerm term, Hashtable termTable) {
        OntologyTerm[] children = null;
        long id = term.getID();
        if (!termTable.containsKey(Long.toString(id))) {
            return null;
        }
        ArrayList childrenList = (ArrayList)termTable.get(Long.toString(id));
        children = new OntologyTerm[childrenList.size()];
        childrenList.toArray(children);
        int i = 0;
        while (i < children.length) {
            children[i].setParentTerm(term);
            children[i].setChildren(this.buildTree(children[i], termTable));
            ++i;
        }
        return children;
    }
}

