/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.graph;

import java.awt.Graphics2D;
import java.util.ArrayList;
import org.metaqtl.graph.MetaGraphPar;
import org.metaqtl.graph.QtlLayer;
import org.metaqtl.graph.QtlShape;
import org.metaqtl.graph.QtlUnit;

public class QtlLayerBuffer {
    private ArrayList qtlShapeList;

    public boolean addQtl(Graphics2D graph, QtlUnit unit) {
        boolean add = false;
        QtlShape shape = new QtlShape();
        shape.buildShape(graph, unit);
        if (this.qtlShapeList != null) {
            QtlShape prev = (QtlShape)this.qtlShapeList.get(this.qtlShapeList.size() - 1);
            double d = QtlShape.getYDistance(shape, prev);
            if (d > MetaGraphPar.QTL_VSPACE) {
                add = true;
            }
        } else {
            add = true;
            this.qtlShapeList = new ArrayList();
        }
        if (add) {
            this.qtlShapeList.add(shape);
        }
        return add;
    }

    public boolean canAddMoreQtl(double ymax) {
        if (this.qtlShapeList != null) {
            QtlShape prev = (QtlShape)this.qtlShapeList.get(this.qtlShapeList.size() - 1);
            return prev.getYMax() < ymax;
        }
        return true;
    }

    public QtlLayer getLayer(double x, double y) {
        QtlLayer layer = null;
        if (this.qtlShapeList != null && this.qtlShapeList.size() > 0) {
            layer = new QtlLayer(x, y);
            layer.qtlShapes = new QtlShape[this.qtlShapeList.size()];
            this.qtlShapeList.toArray(layer.qtlShapes);
            layer.attach(this);
        }
        return layer;
    }
}

