/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.main;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import org.metaqtl.ChromCluster;
import org.metaqtl.Chromosome;
import org.metaqtl.MetaDico;
import org.metaqtl.MetaQtlAnalysis;
import org.metaqtl.MetaQtlData;
import org.metaqtl.MetaQtlModel;
import org.metaqtl.Qtl;
import org.metaqtl.QtlPartition;
import org.metaqtl.adapter.QtlPartitionAdapter;
import org.metaqtl.bio.IBioEntity;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioLGroup;
import org.metaqtl.bio.IBioLocus;
import org.metaqtl.bio.IBioOntology;
import org.metaqtl.bio.entity.factory.BioEntityFactory;
import org.metaqtl.bio.entity.factory.MapChartFactory;
import org.metaqtl.bio.entity.factory.MapMakerFactory;
import org.metaqtl.bio.entity.factory.MapTabFactory;
import org.metaqtl.bio.entity.factory.OntologyTabFactory;
import org.metaqtl.bio.entity.factory.XmlGeneticMapFactory;
import org.metaqtl.bio.entity.factory.XmlOntologyFactory;
import org.metaqtl.factory.DubiousLocusFactory;
import org.metaqtl.factory.MetaDicoFactory;
import org.metaqtl.factory.MetaGraphParFactory;
import org.metaqtl.factory.MetaQtlAnalysisFactory;
import org.metaqtl.factory.MetaQtlModelFactory;
import org.metaqtl.graph.ChromGraph;
import org.metaqtl.graph.GraphFactory;
import org.metaqtl.main.CmdLineParser;

public abstract class MetaMain {
    protected CmdLineParser parser;
    private CmdLineParser.Option averbose;
    private CmdLineParser.Option ahelp;
    protected Boolean verbose;
    protected Boolean help;

    public abstract void printUsage();

    public abstract void printHelp();

    public void initCmdLineParser() {
        this.parser = new CmdLineParser();
        this.averbose = this.parser.addBooleanOption('v', "verbose");
        this.ahelp = this.parser.addBooleanOption('h', "help");
    }

    public void parseCmdLine(String[] args) {
        if (args.length == 0) {
            this.printUsage();
            System.exit(1);
        }
        try {
            this.parser.parse(args);
        }
        catch (CmdLineParser.OptionException e) {
            System.err.println(e.getMessage());
            this.printUsage();
            System.exit(1);
        }
        this.verbose = (Boolean)this.parser.getOptionValue(this.averbose, new Boolean(false));
        this.help = (Boolean)this.parser.getOptionValue(this.ahelp, new Boolean(false));
        if (this.help.booleanValue()) {
            this.printHelp();
            System.exit(0);
        }
    }

    public static void generalHelp() {
        System.out.println("-v, --verbose : verbose mode");
        System.out.println("-h, --help    : display help");
    }

    public static String generalUsage() {
        return "[{-v, --verbose}]] [{-h, --help}]]";
    }

    protected static void writeMap(IBioGenome genome, String format, String outFile) throws IOException {
        FileOutputStream stream = new FileOutputStream(outFile);
        if (format.equals("tab")) {
            MapTabFactory factory = new MapTabFactory();
            factory.unload((IBioEntity)genome, stream);
        } else if (format.equals("mch")) {
            MapChartFactory factory = new MapChartFactory();
            factory.unload((IBioEntity)genome, stream);
        } else if (format.equals("mmk")) {
            MapMakerFactory factory = new MapMakerFactory();
            factory.unload((IBioEntity)genome, stream);
        }
        stream.close();
    }

    protected static void writeMap(IBioGenome map, String outFile) throws IOException {
        FileOutputStream stream = new FileOutputStream(outFile);
        XmlGeneticMapFactory xmlFactory = new XmlGeneticMapFactory();
        xmlFactory.unload((IBioEntity)map, stream);
        stream.close();
    }

    protected static MetaQtlModel getCluster(String cluFile) throws IOException {
        if (cluFile == null) {
            return null;
        }
        FileReader r = new FileReader(cluFile);
        MetaQtlModel cluster = MetaQtlModelFactory.read(r);
        r.close();
        return cluster;
    }

    protected static MetaQtlAnalysis getResult(String resFile) throws IOException {
        if (resFile == null) {
            return null;
        }
        FileReader r = new FileReader(resFile);
        MetaQtlAnalysis result = MetaQtlAnalysisFactory.read(r);
        r.close();
        return result;
    }

    protected static IBioGenome getMap(String mapFile) throws IOException {
        if (mapFile == null) {
            return null;
        }
        FileReader reader = new FileReader(mapFile);
        XmlGeneticMapFactory xmlFactory = new XmlGeneticMapFactory();
        IBioGenome map = (IBioGenome)xmlFactory.load(reader);
        reader.close();
        return map;
    }

    protected static IBioLocus[] getDubious(String dubFile) throws IOException {
        if (dubFile == null) {
            return null;
        }
        FileReader reader = new FileReader(dubFile);
        IBioLocus[] dubious = DubiousLocusFactory.read(reader);
        reader.close();
        return dubious;
    }

    protected static MetaDico getDico(String dicoFile) throws IOException {
        if (dicoFile == null) {
            return null;
        }
        FileReader reader = new FileReader(dicoFile);
        MetaDico dico = MetaDicoFactory.read(reader);
        reader.close();
        return dico;
    }

    protected static IBioGenome[] getMaps(String qtlDir) throws IOException {
        if (qtlDir == null) {
            return null;
        }
        File dir = new File(qtlDir);
        File[] files = null;
        files = dir.isDirectory() ? dir.listFiles() : new File[]{new File(qtlDir)};
        ArrayList<IBioGenome> mapList = new ArrayList<IBioGenome>();
        XmlGeneticMapFactory xmlFactory = new XmlGeneticMapFactory();
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().endsWith("xml")) {
                FileReader reader = new FileReader(files[i]);
                IBioGenome qtl = (IBioGenome)xmlFactory.load(reader);
                if (qtl != null) {
                    mapList.add(qtl);
                }
                reader.close();
            }
            ++i;
        }
        if (mapList.size() > 0) {
            IBioGenome[] qtls = new IBioGenome[mapList.size()];
            mapList.toArray(qtls);
            return qtls;
        }
        return null;
    }

    protected static IBioOntology getOntology(String ontoF, char format) throws IOException {
        if (ontoF == null) {
            return null;
        }
        BioEntityFactory factory = null;
        IBioOntology ontology = null;
        FileReader r = new FileReader(ontoF);
        if (format == 'x') {
            factory = new XmlOntologyFactory();
        } else if (format == 't') {
            factory = new OntologyTabFactory();
        } else {
            return null;
        }
        ontology = (IBioOntology)((BioEntityFactory)factory).load(r);
        r.close();
        return ontology;
    }

    public static void printLicense(String program, String version) {
        System.out.println(String.valueOf(program) + " " + version);
        System.out.println("Copyright (C) 2005  Jean-Baptiste Veyrieras (INRA)");
        System.out.println(String.valueOf(program) + " comes with ABSOLUTELY NO WARRANTY.");
        System.out.println("This is free software, and you are welcome");
        System.out.println("to redistribute it under certain conditions;");
    }

    public static QtlPartition getQtlPartition(Chromosome chromosome, IBioOntology ontology) {
        if (chromosome == null) {
            return null;
        }
        if (chromosome.getQtlNumber() == 0) {
            return null;
        }
        chromosome.computeQtlSD(1);
        MetaQtlData qtlData = new MetaQtlData(chromosome.getQtls());
        if (ontology == null) {
            qtlData.doTraitGroupClustering();
        } else {
            qtlData.doTraitOntologyClustering(ontology);
        }
        qtlData.manageMissingData(1);
        return QtlPartitionAdapter.adapt(qtlData);
    }

    public static QtlPartition getQtlPartition(Chromosome chrom, MetaQtlAnalysis analysis, String trait, int k, char tclust) {
        Qtl[] mqtls = analysis.getMetaQtl(chrom.name, trait, k);
        chrom.setMetaQtls(mqtls);
        QtlPartition qtlPart = QtlPartitionAdapter.adapt(analysis, chrom.name, trait, k);
        if (tclust == 'C') {
            int i = 0;
            while (i < qtlPart.nqtl) {
                int maxj = 0;
                double max = 0.0;
                int j = 0;
                while (j < qtlPart.np) {
                    if (qtlPart.proba[i][j] > max) {
                        max = qtlPart.proba[i][j];
                        maxj = j;
                    }
                    ++j;
                }
                j = 0;
                while (j < qtlPart.np) {
                    qtlPart.proba[i][j] = maxj == j ? 1.0 : 0.0;
                    ++j;
                }
                ++i;
            }
        }
        return qtlPart;
    }

    public static void printImgFormat(int indent) {
        String[] formatNames = ImageIO.getWriterFormatNames();
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < formatNames.length) {
            String name = formatNames[i].toLowerCase();
            set.add(name);
            ++i;
        }
        Iterator iter = set.iterator();
        while (iter.hasNext()) {
            int i2 = 0;
            while (i2 < indent) {
                System.out.println(" ");
                ++i2;
            }
            System.out.println("-" + iter.next());
        }
    }

    public static void setParameter(String parFile) throws IOException {
        if (parFile == null) {
            return;
        }
        FileReader r = new FileReader(parFile);
        MetaGraphParFactory.update(r);
        r.close();
    }

    public static String[] parseChromList(String list) {
        String[] chroms;
        if (list == null) {
            return null;
        }
        if (list.indexOf(",") > 0) {
            StringTokenizer tokenizer = new StringTokenizer(list, ",", false);
            chroms = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                chroms[i++] = tokenizer.nextToken();
            }
        } else {
            chroms = new String[]{list};
        }
        return chroms;
    }

    public static Chromosome[] getChromByNames(Chromosome[] chroms, String[] chromNames) {
        if (chromNames == null) {
            return null;
        }
        ArrayList<Chromosome> chromList = new ArrayList<Chromosome>();
        int i = 0;
        while (i < chromNames.length) {
            int j = 0;
            while (j < chroms.length) {
                if (chroms[j].getName().equals(chromNames[i])) {
                    chromList.add(chroms[j]);
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (chromList.size() > 0) {
            Chromosome[] c = new Chromosome[chromList.size()];
            chromList.toArray(c);
            return c;
        }
        return null;
    }

    public static ChromCluster[] getClusterByNames(ChromCluster[] clusters, String[] chromNames) {
        if (chromNames == null) {
            return null;
        }
        ArrayList<ChromCluster> chromList = new ArrayList<ChromCluster>();
        int i = 0;
        while (i < chromNames.length) {
            int j = 0;
            while (j < clusters.length) {
                if (clusters[j].getName().equals(chromNames[i])) {
                    chromList.add(clusters[j]);
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (chromList.size() > 0) {
            ChromCluster[] c = new ChromCluster[chromList.size()];
            chromList.toArray(c);
            return c;
        }
        return null;
    }

    public static ChromGraph[] getChromGraph(Chromosome[] chroms, boolean withQtl, int modeQtl, IBioOntology ontology, MetaQtlAnalysis treeAnalysis) {
        if (chroms == null) {
            return null;
        }
        Hashtable qtlPartNames = new Hashtable();
        ChromGraph[] chromGraphs = new ChromGraph[chroms.length];
        int i = 0;
        while (i < chroms.length) {
            chromGraphs[i] = new ChromGraph();
            chromGraphs[i].chromosome = chroms[i];
            if (withQtl) {
                chromGraphs[i].qtlPart = MetaMain.getQtlPartition(chroms[i], ontology);
                if (chromGraphs[i].qtlPart != null) {
                    chromGraphs[i].qtlPart.mode = modeQtl;
                    ArrayList pNames = chromGraphs[i].qtlPart.getPartNames();
                    int j = 0;
                    while (j < pNames.size()) {
                        qtlPartNames.put(pNames.get(j), new String(""));
                        ++j;
                    }
                    if (modeQtl == 0 && treeAnalysis != null) {
                        int cidx = treeAnalysis.getChromIdx(chroms[i].getName());
                        chromGraphs[i].qtlPart.tree = treeAnalysis.getResult(chroms[i].getName()).getQtlTree();
                        int[] nidx = new int[treeAnalysis.qtlByChrom[cidx].length];
                        int idx = 0;
                        while (idx < treeAnalysis.qtlByChrom[cidx].length) {
                            int j2 = 0;
                            while (j2 < chromGraphs[i].qtlPart.qtlNames.length) {
                                if (treeAnalysis.qtlByChrom[cidx][idx].name.equals(chromGraphs[i].qtlPart.qtlNames[j2])) {
                                    nidx[idx] = j2;
                                    break;
                                }
                                ++j2;
                            }
                            ++idx;
                        }
                        chromGraphs[i].qtlPart.tree.updateLeafIdx(nidx);
                    }
                }
            }
            ++i;
        }
        MetaMain.synchChromGraphs(chromGraphs, qtlPartNames.keySet());
        i = 0;
        while (i < chromGraphs.length) {
            if (chromGraphs[i].chromosome.skeleton) {
                int j = i - 1;
                while (j >= 0) {
                    ChromGraph tmp = chromGraphs[j + 1];
                    chromGraphs[j + 1] = chromGraphs[j];
                    chromGraphs[j] = tmp;
                    --j;
                }
                break;
            }
            ++i;
        }
        return chromGraphs;
    }

    public static void synchChromGraphs(ChromGraph[] chromGraphs, Set partNames) {
        if (partNames == null) {
            return;
        }
        if (chromGraphs == null) {
            return;
        }
        String[] pNames = new String[partNames.size()];
        Iterator iter = partNames.iterator();
        int i = 0;
        while (iter.hasNext()) {
            pNames[i++] = (String)iter.next();
        }
        i = 0;
        while (i < chromGraphs.length) {
            if (chromGraphs[i].qtlPart != null) {
                chromGraphs[i].qtlPart.rebuildPartition(pNames);
            }
            ++i;
        }
    }

    public static void writeImg(ChromGraph[] chroms, File file, String imgFormat) throws IOException {
        BufferedImage bi = GraphFactory.getImage(chroms);
        if (bi != null) {
            ImageIO.write((RenderedImage)bi, imgFormat, file);
        }
    }

    public static void writePar(File file) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        MetaGraphParFactory.write(stream);
        stream.close();
    }

    public static Hashtable getMrkToRm(File file) throws IOException {
        String line;
        int i = 0;
        Hashtable hash = null;
        ArrayList list = null;
        FileReader reader = new FileReader(file);
        if (reader == null) {
            return null;
        }
        BufferedReader buffer = new BufferedReader(reader);
        while ((line = buffer.readLine()) != null) {
            ++i;
            StringTokenizer token = new StringTokenizer(line, "\t");
            if (token.countTokens() >= 3) {
                String map = token.nextToken();
                String chrom = token.nextToken();
                String marker = token.nextToken();
                if (hash == null) {
                    hash = new Hashtable();
                }
                if ((list = (ArrayList)hash.get(map)) == null) {
                    list = new ArrayList();
                }
                ArrayList<String> tmp = new ArrayList<String>();
                tmp.add(chrom);
                tmp.add(marker);
                list.add(tmp);
                hash.put(map, list);
                continue;
            }
            throw new IOException("[ ERROR ] Unexpected line format at line " + i + " in " + file.getName());
        }
        reader.close();
        return hash;
    }

    public static void removeLocus(IBioGenome[] maps, String mrkRmFile) throws IOException {
        if (maps == null || mrkRmFile == null) {
            return;
        }
        Hashtable hash = MetaMain.getMrkToRm(new File(mrkRmFile));
        if (hash == null) {
            return;
        }
        Enumeration iter = hash.keys();
        while (iter.hasMoreElements()) {
            String mapName = (String)iter.nextElement();
            ArrayList mrkLists = (ArrayList)hash.get(mapName);
            IBioGenome map = MetaMain.getMap(maps, mapName);
            if (map != null) {
                int i = 0;
                while (i < mrkLists.size()) {
                    String chromName = (String)((ArrayList)mrkLists.get(i)).get(0);
                    String mrkName = (String)((ArrayList)mrkLists.get(i)).get(1);
                    IBioLGroup chrom = map.getGroup(chromName);
                    if (chrom != null) {
                        chrom.removeLocus(mrkName);
                    } else {
                        System.err.println("[ WARNING ] Unable to find chromosome " + chromName + " : wrong name in " + mrkRmFile);
                    }
                    ++i;
                }
                continue;
            }
            System.err.println("[ WARNING ] Unable to find map " + mapName + " : wrong name in " + mrkRmFile);
        }
    }

    public static IBioGenome getMap(IBioGenome[] maps, String mapName) {
        if (maps == null || mapName == null) {
            return null;
        }
        int i = 0;
        while (i < maps.length) {
            if (maps[i].getName().equals(mapName)) {
                return maps[i];
            }
            ++i;
        }
        return null;
    }
}

