/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.main;

import java.io.FileOutputStream;
import java.io.IOException;
import org.metaqtl.MetaQtlAnalysis;
import org.metaqtl.algo.EMAlgorithm;
import org.metaqtl.algo.QtlClustAlgorithm;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioOntology;
import org.metaqtl.factory.MetaQtlAnalysisFactory;
import org.metaqtl.factory.MetaQtlAnalysisModelFactory;
import org.metaqtl.factory.MetaQtlAnalysisSummaryFactory;
import org.metaqtl.main.CmdLineParser;
import org.metaqtl.main.MetaMain;

public final class QTLClust
extends MetaMain {
    private static final String VERSION = "1.0";
    private static final String syntax = "Syntaxe: QTLClust [{-q, --qtlmap}]] [{-o, --outstem}]] [{-t, --tonto}]] [{-k, --kmax}] [{--cimode}] [{--cimiss}] [{-c, --chr}] [{--emrs}] [{--emeps}] " + MetaMain.generalUsage();

    public void printUsage() {
        System.err.println(syntax);
    }

    public void printHelp() {
        System.out.println("QTLClust1.0, Copyright (C) 2005  Jean-Baptiste Veyrieras (INRA)");
        System.out.println("QTLClust comes with ABSOLUTELY NO WARRANTY.");
        System.out.println("This is free software, and you are welcome to redistribute it");
        System.out.println("under certain conditions;");
        System.out.println();
        System.out.println(syntax);
        System.out.println();
        MetaMain.generalHelp();
        System.out.println();
        System.out.println("-q, --qtlmap   : the file location of the qtl data base");
        System.out.println("-o, --outstem  : the stem name for output files");
        System.out.println("-t, --tonto    : the file location of the trait ontology (optional)");
        System.out.println("-c, --chr      : the chromosome to study (optional)");
        System.out.println("--cimode : the mode of computation of the QTL CI (see manual)");
        System.out.println("--cimiss : the mode of imputation for missing QTL CI (see manual)");
        System.out.println("--emrs  : the number of random starting points for the EM algorithm");
        System.out.println("--emeps : the convergence tolerance for the EM algorithm");
        System.out.println("-k, --kmax   : the maximum number of cluster partitions (optional)");
    }

    public static void main(String[] args) {
        QTLClust program = new QTLClust();
        program.initCmdLineParser();
        CmdLineParser parser = program.parser;
        CmdLineParser.Option aqtlFile = parser.addStringOption('q', "qtlmap");
        CmdLineParser.Option aoutStem = parser.addStringOption('o', "outstem");
        CmdLineParser.Option aontoFile = parser.addStringOption('t', "tonto");
        CmdLineParser.Option achrName = parser.addStringOption('c', "chr");
        CmdLineParser.Option acimode = parser.addIntegerOption("cimode");
        CmdLineParser.Option acimiss = parser.addIntegerOption("cimiss");
        CmdLineParser.Option aemrs = parser.addIntegerOption("emrs");
        CmdLineParser.Option aemeps = parser.addDoubleOption("emeps");
        CmdLineParser.Option akmax = parser.addIntegerOption('k', "kmax");
        CmdLineParser.Option ahelp = parser.addBooleanOption("help");
        program.parseCmdLine(args);
        String qtlF = (String)parser.getOptionValue(aqtlFile);
        String outF = (String)parser.getOptionValue(aoutStem);
        String chrName = (String)parser.getOptionValue(achrName);
        String ontoF = (String)parser.getOptionValue(aontoFile, null);
        Integer cimode = (Integer)parser.getOptionValue(acimode, new Integer(1));
        Integer cimiss = (Integer)parser.getOptionValue(acimiss, new Integer(1));
        Integer emrs = (Integer)parser.getOptionValue(aemrs, new Integer(EMAlgorithm.EM_START));
        Double emeps = (Double)parser.getOptionValue(aemeps, new Double(EMAlgorithm.EM_ERR));
        Integer kmax = (Integer)parser.getOptionValue(akmax, new Integer(0));
        if (qtlF == null) {
            System.err.println("No qtl data base file defined : EXIT");
            System.exit(2);
        }
        if (outF == null) {
            System.err.println("No out stem file defined : EXIT");
            System.exit(3);
        }
        IBioGenome qtldb = null;
        IBioOntology ontology = null;
        try {
            qtldb = QTLClust.getMap(qtlF);
            if (ontoF != null) {
                ontology = QTLClust.getOntology(ontoF, 'x');
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(3);
        }
        QtlClustAlgorithm algorithm = new QtlClustAlgorithm(qtldb, chrName, ontology);
        if (!program.verbose.booleanValue()) {
            algorithm.disableLogger();
        }
        if (kmax > 0) {
            algorithm.setMaxClusterNumber(kmax);
        }
        if (cimode > 0) {
            algorithm.setCIMode(cimode);
        }
        if (cimiss > 0) {
            algorithm.setCIMiss(cimiss);
        }
        if (emrs > 0) {
            algorithm.setEMRanStartNumber(emrs);
        }
        if (emeps > 0.0) {
            algorithm.setEMEps(emeps);
        }
        algorithm.run();
        MetaQtlAnalysis metaAnalysis = algorithm.getResult();
        try {
            FileOutputStream stream = new FileOutputStream(String.valueOf(outF) + "_res.txt");
            MetaQtlAnalysisFactory.write(metaAnalysis, stream);
            stream.close();
            stream = new FileOutputStream(String.valueOf(outF) + "_crit.txt");
            MetaQtlAnalysisSummaryFactory.write(metaAnalysis, stream);
            stream.close();
            stream = new FileOutputStream(String.valueOf(outF) + "_model.txt");
            MetaQtlAnalysisModelFactory.write(metaAnalysis, stream);
            stream.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(4);
        }
        System.exit(0);
    }
}

