/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.main;

import java.io.FileOutputStream;
import java.io.IOException;
import org.metaqtl.MetaQtlAnalysis;
import org.metaqtl.algo.QtlTreeAlgorithm;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioOntology;
import org.metaqtl.factory.MetaQtlAnalysisFactory;
import org.metaqtl.main.CmdLineParser;
import org.metaqtl.main.MetaMain;

public final class QTLTree
extends MetaMain {
    private static final String VERSION = "1.0";
    private static final String syntax = "Syntaxe: QTLTree [{-q, --qtlmap}]] [{-o, --outstem}]] [{-t, --tonto}]] [{-m, --mode}]] [{--cimode}] [{--cimiss}] " + MetaMain.generalUsage();

    public void printUsage() {
        System.err.println(syntax);
    }

    public void printHelp() {
        System.out.println("QTLTree1.0, Copyright (C) 2005  Jean-Baptiste Veyrieras (INRA)");
        System.out.println("QTLTree comes with ABSOLUTELY NO WARRANTY.");
        System.out.println("This is free software, and you are welcome to redistribute it");
        System.out.println("under certain conditions;");
        System.out.println();
        System.out.println(syntax);
        System.out.println();
        MetaMain.generalHelp();
        System.out.println();
        System.out.println("-q, --qtlmap   : the file location of the qtl data base");
        System.out.println("-o, --outstem  : the stem name for output files");
        System.out.println("-t, --tonto    : the file location of the trait ontology");
        System.out.println("-m, --mode     : the clustering mode (see manual)");
        System.out.println("--cimode : the mode of computation of the QTL CI (see manual)");
        System.out.println("--cimiss : the mode of imputation for missing QTL CI (see manual)");
    }

    public static void main(String[] args) {
        QTLTree program = new QTLTree();
        program.initCmdLineParser();
        CmdLineParser parser = program.parser;
        CmdLineParser.Option aqtlFile = parser.addStringOption('q', "qtlfile");
        CmdLineParser.Option aoutStem = parser.addStringOption('o', "outstem");
        CmdLineParser.Option aontoFile = parser.addStringOption('t', "ontofile");
        CmdLineParser.Option amode = parser.addIntegerOption('m', "mode");
        CmdLineParser.Option acimode = parser.addIntegerOption("cimode");
        CmdLineParser.Option acimiss = parser.addIntegerOption("cimiss");
        CmdLineParser.Option ahelp = parser.addBooleanOption("help");
        program.parseCmdLine(args);
        String qtlF = (String)parser.getOptionValue(aqtlFile);
        String outF = (String)parser.getOptionValue(aoutStem);
        String ontoF = (String)parser.getOptionValue(aontoFile, null);
        Integer cimode = (Integer)parser.getOptionValue(acimode, new Integer(1));
        Integer cimiss = (Integer)parser.getOptionValue(acimiss, new Integer(1));
        Integer mode = (Integer)parser.getOptionValue(amode, new Integer(2));
        if (qtlF == null) {
            System.err.println("No qtl data base file defined : EXIT");
            System.exit(2);
        }
        if (outF == null) {
            System.err.println("No out stem file defined : EXIT");
            System.exit(3);
        }
        IBioGenome qtldb = null;
        IBioOntology ontology = null;
        try {
            qtldb = QTLTree.getMap(qtlF);
            if (ontoF != null) {
                ontology = QTLTree.getOntology(ontoF, 'x');
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(3);
        }
        QtlTreeAlgorithm algorithm = new QtlTreeAlgorithm(qtldb, ontology);
        if (!program.verbose.booleanValue()) {
            algorithm.disableLogger();
        }
        algorithm.setTreeMethod(mode);
        algorithm.setCIMode(cimode);
        algorithm.setCIMiss(cimiss);
        algorithm.run();
        MetaQtlAnalysis metaAnalysis = algorithm.getResult();
        try {
            FileOutputStream stream = new FileOutputStream(outF);
            MetaQtlAnalysisFactory.write(metaAnalysis, stream);
            stream.close();
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            System.exit(4);
        }
        System.exit(0);
    }
}

