/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.jibx.extras.DocumentModelMapperBase;
import org.jibx.runtime.JiBXException;

public class Dom4JMapperBase
extends DocumentModelMapperBase {
    private static DocumentFactory s_factory = DocumentFactory.getInstance();
    protected String m_defaultNamespaceURI;
    protected int m_defaultNamespaceIndex;

    private int findNamespaceIndex(Namespace ns) {
        if (Namespace.NO_NAMESPACE.equals((Object)ns)) {
            return 0;
        }
        if (Namespace.XML_NAMESPACE.equals((Object)ns)) {
            return 1;
        }
        String prefix = ns.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            if (this.m_defaultNamespaceURI == null) {
                int index = this.m_xmlWriter.getPrefixIndex("");
                if (index >= 0) {
                    this.m_defaultNamespaceURI = this.getNamespaceUri(index);
                    this.m_defaultNamespaceIndex = index;
                    if (this.m_defaultNamespaceURI.equals(ns.getURI())) {
                        return index;
                    }
                    return -1;
                }
                return -1;
            }
            return this.m_defaultNamespaceURI.equals(ns.getURI()) ? this.m_defaultNamespaceIndex : -1;
        }
        int index = this.m_xmlWriter.getPrefixIndex(prefix);
        if (index >= 0) {
            return this.getNamespaceUri(index).equals(ns.getURI()) ? index : -1;
        }
        return -1;
    }

    protected void marshalContent(List content) throws JiBXException, IOException {
        int size = content.size();
        block8: for (int i = 0; i < size; ++i) {
            Node node = (Node)content.get(i);
            switch (node.getNodeType()) {
                case 4: {
                    this.m_xmlWriter.writeCData(node.getText());
                    continue block8;
                }
                case 8: {
                    this.m_xmlWriter.writeComment(node.getText());
                    continue block8;
                }
                case 1: {
                    this.marshalElement((Element)node);
                    continue block8;
                }
                case 5: {
                    this.m_xmlWriter.writeEntityRef(node.getName());
                    continue block8;
                }
                case 7: {
                    this.m_xmlWriter.writePI(((ProcessingInstruction)node).getTarget(), node.getText());
                    continue block8;
                }
                case 3: {
                    this.m_xmlWriter.writeTextContent(node.getText());
                    continue block8;
                }
            }
        }
    }

    protected void marshalElement(Element element) throws JiBXException, IOException {
        int size = element.nodeCount();
        Namespace ns = element.getNamespace();
        int nsi = this.findNamespaceIndex(ns);
        ArrayList<Namespace> nss = null;
        boolean hascontent = false;
        int defind = -1;
        String defuri = null;
        for (int i = 0; i < size; ++i) {
            Node node = element.node(i);
            if (node instanceof Namespace) {
                Namespace dns = (Namespace)node;
                if (this.findNamespaceIndex(dns) >= 0) continue;
                if (nss == null) {
                    nss = new ArrayList<Namespace>();
                }
                nss.add(dns);
                String prefix = dns.getPrefix();
                if (prefix != null && prefix.length() != 0) continue;
                defind = nss.size() - 1;
                defuri = dns.getURI();
                continue;
            }
            hascontent = true;
        }
        String[] uris = null;
        if (nss == null) {
            this.m_xmlWriter.startTagOpen(nsi, element.getName());
        } else {
            int base = this.getNextNamespaceIndex();
            if (defind >= 0) {
                this.m_defaultNamespaceIndex = base + defind;
                this.m_defaultNamespaceURI = defuri;
            }
            uris = new String[nss.size()];
            int[] nums = new int[nss.size()];
            String[] prefs = new String[nss.size()];
            for (int i = 0; i < uris.length; ++i) {
                Namespace addns = (Namespace)nss.get(i);
                uris[i] = addns.getURI();
                nums[i] = base + i;
                prefs[i] = addns.getPrefix();
                if (nsi >= 0 || !ns.equals((Object)addns)) continue;
                nsi = base + i;
            }
            this.m_xmlWriter.pushExtensionNamespaces(uris);
            this.m_xmlWriter.startTagNamespaces(nsi, element.getName(), nums, prefs);
            if (defind >= 0) {
                this.m_defaultNamespaceIndex = defind;
                this.m_defaultNamespaceURI = defuri;
            }
        }
        if (element.attributeCount() > 0) {
            for (int i = 0; i < element.attributeCount(); ++i) {
                Attribute attr = element.attribute(i);
                int index = this.findNamespaceIndex(attr.getNamespace());
                this.m_xmlWriter.addAttribute(index, attr.getName(), attr.getValue());
            }
        }
        if (hascontent) {
            this.m_xmlWriter.closeStartTag();
            this.marshalContent(element.content());
            this.m_xmlWriter.endTag(nsi, element.getName());
        } else {
            this.m_xmlWriter.closeEmptyTag();
        }
        if (nss != null) {
            this.m_xmlWriter.popExtensionNamespaces();
            if (defind >= 0) {
                this.m_defaultNamespaceURI = null;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void unmarshalContent(List content) throws JiBXException, IOException {
        block9: while (true) {
            int cev = this.m_unmarshalContext.currentEvent();
            switch (cev) {
                case 5: {
                    content.add(s_factory.createCDATA(this.m_unmarshalContext.getText()));
                    break;
                }
                case 9: {
                    content.add(s_factory.createComment(this.m_unmarshalContext.getText()));
                    break;
                }
                case 3: {
                    return;
                }
                case 6: {
                    if (this.m_unmarshalContext.getText() == null) {
                        content.add(s_factory.createEntity(this.m_unmarshalContext.getName(), null));
                        break;
                    }
                    content.add(s_factory.createText(this.accumulateText()));
                    continue block9;
                }
                case 8: {
                    String text = this.m_unmarshalContext.getText();
                    int index = 0;
                    while (++index < text.length() && !this.isWhitespace(text.charAt(index))) {
                    }
                    if (index < text.length()) {
                        String target = text.substring(0, index);
                        while (++index < text.length() && this.isWhitespace(text.charAt(index))) {
                        }
                        String data = text.substring(index);
                        content.add(s_factory.createProcessingInstruction(target, data));
                        break;
                    }
                    content.add(s_factory.createProcessingInstruction(text, ""));
                    break;
                }
                case 2: {
                    content.add(this.unmarshalElement());
                    continue block9;
                }
                case 4: {
                    content.add(s_factory.createText(this.accumulateText()));
                    continue block9;
                }
            }
            this.m_unmarshalContext.nextToken();
        }
    }

    protected Element unmarshalElement() throws JiBXException, IOException {
        QName qname = QName.get((String)this.m_unmarshalContext.getName(), (String)this.m_unmarshalContext.getPrefix(), (String)this.m_unmarshalContext.getNamespace());
        Element element = s_factory.createElement(qname);
        int ncount = this.m_unmarshalContext.getNamespaceCount();
        for (int i = 0; i < ncount; ++i) {
            String prefix = this.m_unmarshalContext.getNamespacePrefix(i);
            String uri = this.m_unmarshalContext.getNamespaceUri(i);
            element.addNamespace(prefix, uri);
        }
        int acount = this.m_unmarshalContext.getAttributeCount();
        for (int i = 0; i < acount; ++i) {
            String prefix = this.m_unmarshalContext.getAttributePrefix(i);
            String uri = this.m_unmarshalContext.getAttributeNamespace(i);
            String name = this.m_unmarshalContext.getAttributeName(i);
            String value = this.m_unmarshalContext.getAttributeValue(i);
            qname = QName.get((String)name, (String)prefix, (String)uri);
            element.addAttribute(qname, value);
        }
        int event = this.m_unmarshalContext.nextToken();
        if (event != 3) {
            this.unmarshalContent(element.content());
        }
        this.m_unmarshalContext.nextToken();
        return element;
    }
}

