/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.Type;
import org.apache.bcel.util.ClassPath;
import org.jibx.binding.classes.ClassCache;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.classes.ExceptionMethodBuilder;
import org.jibx.binding.classes.ExistingMethod;
import org.jibx.binding.classes.InstructionBuilder;
import org.jibx.runtime.JiBXException;

public class ClassFile {
    public static final int PRIVATE_ACCESS = 0;
    public static final int PACKAGE_ACCESS = 1;
    public static final int PROTECTED_ACCESS = 2;
    public static final int PUBLIC_ACCESS = 3;
    protected static final int PRIVATEFIELD_ACCESS = 2;
    protected static final ExistingMethod[] EMPTY_METHOD_ARRAY = new ExistingMethod[0];
    private static ClassPath s_loader;
    private static ClassLoader s_directLoader;
    private String m_name;
    private String m_signature;
    private Type m_type;
    private File m_root;
    private File m_file;
    private boolean m_isSamePackage;
    private boolean m_isWritable;
    protected ClassFile m_superClass;
    protected String[] m_interfaces;
    private String[] m_instanceOfs;
    private JavaClass m_curClass;
    private ClassGen m_genClass;
    private ConstantPoolGen m_genPool;
    protected InstructionBuilder m_instBuilder;
    private HashMap m_suffixMap;
    private HashMap m_itemMap;
    private boolean m_isModified;
    private int m_useCount;
    private boolean m_isHashCurrent;
    private int m_hashCode;
    private int m_inheritDepth;
    private int m_uniqueIndex;

    public ClassFile(String name, String path, InputStream ins) throws JiBXException {
        this.init(name, path, ins);
    }

    public ClassFile(String name, File root, File file) throws IOException, JiBXException {
        this.init(name, root.getPath(), new FileInputStream(file));
        this.m_root = root;
        this.m_file = file;
        this.m_isWritable = file.canWrite();
    }

    public ClassFile(String name) throws IOException, JiBXException {
        ClassPath.ClassFile cf = null;
        try {
            cf = s_loader.getClassFile(name);
        }
        catch (IOException ex) {
            try {
                cf = ClassPath.SYSTEM_CLASS_PATH.getClassFile(name);
            }
            catch (IOException ex1) {
                // empty catch block
            }
        }
        if (cf == null) {
            throw new JiBXException("Class " + name + " not found in any classpath");
        }
        this.init(name, cf.getPath(), cf.getInputStream());
    }

    public ClassFile(String name, String sig) {
        this.m_name = name;
        this.m_signature = sig;
        this.m_type = Type.getType(sig);
        this.m_interfaces = new String[0];
        this.m_itemMap = new HashMap();
    }

    public ClassFile(String name, File root, ClassFile sclas, int access, String[] impls) throws JiBXException {
        String fname = name.replace('.', File.separatorChar) + ".class";
        File file = new File(root, fname);
        this.m_name = name;
        this.m_signature = Utility.getSignature(name);
        this.m_type = ClassItem.typeFromName(name);
        this.m_root = root;
        this.m_superClass = sclas;
        this.m_interfaces = impls;
        this.m_file = file;
        this.m_isWritable = true;
        this.m_genClass = new ClassGen(name, sclas.getName(), "", access, impls);
        this.m_genPool = this.m_genClass.getConstantPool();
        this.m_instBuilder = new InstructionBuilder(this.m_genClass, this.m_genPool);
        this.m_itemMap = new HashMap();
        ClassCache.addClassFile(this);
    }

    private void init(String name, String path, InputStream ins) throws JiBXException {
        this.m_name = name;
        this.m_signature = Utility.getSignature(name);
        this.m_type = ClassItem.typeFromName(name);
        this.m_itemMap = new HashMap();
        if (path == null) {
            this.m_interfaces = new String[0];
        } else {
            String fname = name.replace('.', File.separatorChar) + ".class";
            ClassParser parser = new ClassParser(ins, fname);
            try {
                this.m_curClass = parser.parse();
                this.m_interfaces = this.m_curClass.getInterfaceNames();
            }
            catch (Exception ex) {
                throw new JiBXException("Error reading path " + path + " for class " + name);
            }
        }
    }

    public boolean isInterface() {
        return this.m_curClass != null && this.m_curClass.isInterface();
    }

    public boolean isAbstract() {
        return this.m_curClass != null && this.m_curClass.isAbstract();
    }

    public boolean isModifiable() {
        return this.m_isWritable && !this.isInterface();
    }

    public String getName() {
        return this.m_name;
    }

    public String getSignature() {
        return this.m_signature;
    }

    public Type getType() {
        return this.m_type;
    }

    public String getPackage() {
        int split = this.m_name.lastIndexOf(46);
        if (split >= 0) {
            return this.m_name.substring(0, split);
        }
        return "";
    }

    public File getRoot() {
        return this.m_root;
    }

    public File getFile() {
        return this.m_file;
    }

    public JavaClass getRawClass() {
        if (this.m_curClass == null) {
            throw new IllegalStateException("No loadable class information for " + this.m_name);
        }
        return this.m_curClass;
    }

    public String getSuperName() {
        if (this.m_curClass == null) {
            return null;
        }
        return this.m_curClass.getSuperclassName();
    }

    public void setSuperFile(ClassFile sclas) {
        this.m_superClass = sclas;
        this.m_isSamePackage = this.getPackage().equals(sclas.getPackage());
    }

    public ClassFile getSuperFile() {
        return this.m_superClass;
    }

    public String[] getInterfaces() {
        return this.m_interfaces;
    }

    public boolean addInterface(String intf) throws JiBXException {
        ClassGen gen = this.getClassGen();
        String[] intfs = gen.getInterfaceNames();
        for (int i = 0; i < intfs.length; ++i) {
            if (!intf.equals(intfs[i])) continue;
            return false;
        }
        gen.addInterface(intf);
        this.m_isModified = true;
        this.m_instanceOfs = null;
        return true;
    }

    protected void accumulateInterfaces(String[] intfs, HashMap map, ArrayList accs) throws JiBXException {
        for (int i = 0; i < intfs.length; ++i) {
            String name = intfs[i];
            if (map.get(name) != null) continue;
            ClassFile cf = ClassCache.getClassFile(name);
            String sig = cf.getSignature();
            map.put(name, sig);
            accs.add(sig);
            String[] inherits = cf.m_curClass.getInterfaceNames();
            this.accumulateInterfaces(inherits, map, accs);
        }
    }

    public String[] getInstanceSigs() throws JiBXException {
        if (this.m_instanceOfs == null) {
            String name = this.getName();
            if (name.endsWith("[]")) {
                String[] bsigs;
                String prefix = "";
                do {
                    name = name.substring(0, name.length() - 2);
                    prefix = prefix + '[';
                } while (name.endsWith("[]"));
                if (ClassItem.isPrimitive(name)) {
                    bsigs = new String[]{ClassItem.getPrimitiveSignature(name)};
                } else {
                    ClassFile bcf = ClassCache.getClassFile(name);
                    bsigs = bcf.getInstanceSigs();
                }
                String[] asigs = new String[bsigs.length];
                for (int i = 0; i < bsigs.length; ++i) {
                    asigs[i] = prefix + bsigs[i];
                }
                this.m_instanceOfs = asigs;
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                ArrayList<String> iofs = new ArrayList<String>();
                for (ClassFile cur = this; cur != null; cur = cur.getSuperFile()) {
                    String sig = cur.getSignature();
                    map.put(name, sig);
                    iofs.add(sig);
                    this.accumulateInterfaces(cur.getInterfaces(), map, iofs);
                }
                String[] sigs = new String[iofs.size()];
                this.m_instanceOfs = iofs.toArray(sigs);
            }
        }
        return this.m_instanceOfs;
    }

    public boolean isImplements(String sig) throws JiBXException {
        String[] sigs = this.getInstanceSigs();
        for (int i = 0; i < sigs.length; ++i) {
            if (!sig.equals(sigs[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isSuperclass(String name) throws JiBXException {
        for (ClassFile cur = this; cur != null; cur = cur.getSuperFile()) {
            if (!cur.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    protected Field getDefinedField(String name) {
        Field[] fields = this.m_curClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(name)) continue;
            return fields[i];
        }
        return null;
    }

    protected Field getAccessibleField(String name) {
        if (this.m_curClass == null) {
            return null;
        }
        Field field = this.getDefinedField(name);
        if (!(field != null || this.m_superClass == null || (field = this.m_superClass.getAccessibleField(name)) == null || this.m_isSamePackage && !field.isPrivate() || field.isPublic() || field.isProtected())) {
            field = null;
        }
        return field;
    }

    public ClassItem getDirectField(String name) {
        Field field = this.getAccessibleField(name);
        if (field == null) {
            return null;
        }
        ClassItem item = (ClassItem)this.m_itemMap.get(field);
        if (item == null) {
            item = new ClassItem(name, this, field);
            this.m_itemMap.put(field, item);
        }
        return item;
    }

    public ClassItem getField(String name) throws JiBXException {
        Field field = this.getAccessibleField(name);
        if (field == null) {
            throw new JiBXException("Field " + name + " not found in class " + this.m_name);
        }
        ClassItem item = (ClassItem)this.m_itemMap.get(field);
        if (item == null) {
            item = new ClassItem(name, this, field);
            this.m_itemMap.put(field, item);
        }
        return item;
    }

    protected Method getAccessibleMethod(String name, String sig) {
        if (this.m_curClass != null) {
            Method method;
            Method[] methods = this.m_curClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method2 = methods[i];
                if (!method2.getName().equals(name) || !method2.getSignature().startsWith(sig)) continue;
                return method2;
            }
            if (this.m_superClass != null && (method = this.m_superClass.getAccessibleMethod(name, sig)) != null && (this.m_isSamePackage && !method.isPrivate() || method.isPublic() || method.isProtected())) {
                return method;
            }
        }
        return null;
    }

    public ClassItem getMethod(String name, String sig) {
        Method method = this.getAccessibleMethod(name, sig);
        if (method == null) {
            return null;
        }
        ClassItem item = (ClassItem)this.m_itemMap.get(method);
        if (item == null) {
            item = new ClassItem(name, this, method);
            this.m_itemMap.put(method, item);
        }
        return item;
    }

    public ClassItem getMethod(String name, String[] sigs) {
        Method method = null;
        for (int i = 0; method == null && i < sigs.length; ++i) {
            method = this.getAccessibleMethod(name, sigs[i]);
        }
        if (method == null) {
            return null;
        }
        ClassItem item = (ClassItem)this.m_itemMap.get(method);
        if (item == null) {
            item = new ClassItem(name, this, method);
            this.m_itemMap.put(method, item);
        }
        return item;
    }

    private static boolean matchAccess(FieldOrMethod item, int access) {
        if (item.isPublic()) {
            return true;
        }
        if (item.isProtected()) {
            return access <= 2;
        }
        if (item.isPrivate()) {
            return access == 0;
        }
        return access <= 1;
    }

    private static boolean isAssignmentCompatible(Type have, Type need) {
        if (have.equals(need)) {
            return true;
        }
        try {
            return ClassItem.isAssignable(have.toString(), need.toString());
        }
        catch (JiBXException e) {
            throw new IllegalStateException("Internal error: Unable to access data for " + have.toString() + " or " + need.toString() + ":\n" + e.getMessage());
        }
    }

    private Method getBestAccessibleMethod(String name, int access, Type ret, Type[] args) {
        if (this.m_curClass == null) {
            return null;
        }
        Method[] methods = this.m_curClass.getMethods();
        Method best = null;
        int diff = Integer.MAX_VALUE;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(name) || !ClassFile.matchAccess(method, access)) continue;
            boolean match = true;
            int ndiff = 0;
            if (ret != null) {
                Type type = method.getReturnType();
                match = ClassFile.isAssignmentCompatible(ret, type);
            }
            if (match) {
                Type[] types = method.getArgumentTypes();
                if (args.length == types.length) {
                    for (int j = 0; j < args.length; ++j) {
                        Type type = types[j];
                        Type arg = args[j];
                        if (type.equals(arg)) continue;
                        ++ndiff;
                        match = ClassFile.isAssignmentCompatible(arg, type);
                        if (match) {
                            continue;
                        }
                        break;
                    }
                } else {
                    match = false;
                }
            }
            if (!match || ndiff >= diff) continue;
            best = method;
        }
        if (best != null) {
            return best;
        }
        if (this.m_superClass != null) {
            if (access < 2) {
                access = this.m_isSamePackage ? 1 : 2;
            }
            return this.m_superClass.getBestAccessibleMethod(name, access, ret, args);
        }
        return null;
    }

    public ClassItem getBestMethod(String name, String ret, String[] args) {
        Type rtype = null;
        if (ret != null) {
            rtype = ClassItem.typeFromName(ret);
        }
        Type[] atypes = new Type[args.length];
        for (int i = 0; i < args.length; ++i) {
            atypes[i] = ClassItem.typeFromName(args[i]);
        }
        Method method = this.getBestAccessibleMethod(name, 0, rtype, atypes);
        if (method == null) {
            return null;
        }
        ClassItem item = (ClassItem)this.m_itemMap.get(method);
        if (item == null) {
            item = new ClassItem(name, this, method);
            this.m_itemMap.put(method, item);
        }
        return item;
    }

    public ClassItem getInitializerMethod(String sig) {
        if (this.m_curClass != null) {
            Method[] methods = this.m_curClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals("<init>")) continue;
                String sign = method.getSignature();
                if (!method.getSignature().startsWith(sig)) continue;
                ClassItem item = (ClassItem)this.m_itemMap.get(method);
                if (item == null) {
                    item = new ClassItem("<init>", this, method);
                    this.m_itemMap.put(method, item);
                }
                return item;
            }
        }
        return null;
    }

    public ClassItem getStaticMethod(String name, String sig) {
        if (this.m_curClass != null) {
            Method[] methods = this.m_curClass.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals(name) || !method.isStatic() || !method.getSignature().startsWith(sig)) continue;
                ClassItem item = (ClassItem)this.m_itemMap.get(method);
                if (item == null) {
                    item = new ClassItem(name, this, method);
                    this.m_itemMap.put(method, item);
                }
                return item;
            }
        }
        return null;
    }

    public ExistingMethod[] getBindingMethods(String prefix, String[] matches) {
        if (this.m_curClass == null) {
            return EMPTY_METHOD_ARRAY;
        }
        Method[] methods = this.m_curClass.getMethods();
        int count = 0;
        block0: for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String name = method.getName();
            if (name.startsWith(prefix)) {
                ++count;
                continue;
            }
            String sig = method.getSignature();
            for (int j = 0; j < matches.length; j += 2) {
                if (!name.equals(matches[j]) || !sig.equals(matches[j + 1])) continue;
                ++count;
                continue block0;
            }
        }
        if (count == 0) {
            return EMPTY_METHOD_ARRAY;
        }
        ExistingMethod[] exists = new ExistingMethod[count];
        int fill = 0;
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            String name = method.getName();
            boolean match = name.startsWith(prefix);
            if (!match) {
                String sig = method.getSignature();
                for (int j = 0; j < matches.length; j += 2) {
                    if (!name.equals(matches[j]) || !sig.equals(matches[j + 1])) continue;
                    match = true;
                    break;
                }
            }
            if (!match) continue;
            ClassItem item = (ClassItem)this.m_itemMap.get(method);
            if (item == null) {
                item = new ClassItem(name, this, method);
                this.m_itemMap.put(method, item);
            }
            exists[fill++] = new ExistingMethod(method, item, this);
        }
        return exists;
    }

    public boolean isAccessible(ClassItem item) {
        if (item.getClassFile() == this) {
            return true;
        }
        int access = item.getAccessFlags();
        if ((access & 1) != 0) {
            return true;
        }
        if ((access & 2) != 0) {
            return false;
        }
        if (this.getPackage().equals(item.getClassFile().getPackage())) {
            return true;
        }
        if ((access & 4) != 0) {
            ClassFile target = item.getClassFile();
            ClassFile ancestor = this;
            while ((ancestor = ancestor.getSuperFile()) != null) {
                if (ancestor != target) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private ClassGen getClassGen() throws JiBXException {
        if (this.m_genClass == null) {
            if (this.m_isWritable) {
                this.m_genClass = new ClassGen(this.m_curClass);
                this.m_genPool = this.m_genClass.getConstantPool();
                this.m_instBuilder = new InstructionBuilder(this.m_genClass, this.m_genPool);
                this.m_isHashCurrent = false;
            } else {
                throw new JiBXException("Cannot modify class " + this.m_name);
            }
        }
        return this.m_genClass;
    }

    public ConstantPoolGen getConstPoolGen() throws JiBXException {
        if (this.m_genPool == null) {
            this.getClassGen();
        }
        return this.m_genPool;
    }

    public InstructionBuilder getInstructionBuilder() throws JiBXException {
        if (this.m_instBuilder == null) {
            this.getClassGen();
        }
        return this.m_instBuilder;
    }

    public ClassItem addMethod(Method method) throws JiBXException {
        this.getClassGen().addMethod(method);
        this.setModified();
        String mname = method.getName();
        if (this.m_suffixMap != null && ClassFile.isSuffixName(mname)) {
            this.m_suffixMap.put(mname, method);
        }
        return new ClassItem(mname, this, method);
    }

    public void removeMethod(Method method) throws JiBXException {
        this.getClassGen().removeMethod(method);
        this.setModified();
        String mname = method.getName();
        if (this.m_suffixMap != null && ClassFile.isSuffixName(mname)) {
            this.m_suffixMap.remove(mname);
        }
    }

    public ClassItem addField(String type, String name, int access, String init) throws JiBXException {
        this.deleteField(name);
        FieldGen fgen = new FieldGen(access, Type.getType(Utility.getSignature(type)), name, this.getConstPoolGen());
        fgen.setInitValue(init);
        Field field = fgen.getField();
        this.getClassGen().addField(field);
        this.m_isModified = true;
        this.m_isHashCurrent = false;
        return new ClassItem(name, this, field);
    }

    public ClassItem updateField(String type, String name, int access, String init) throws JiBXException {
        Field field;
        Field[] fields = this.m_curClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Object value;
            ConstantValue cval;
            String sig;
            field = fields[i];
            if (!field.getName().equals(name) || field.getAccessFlags() != access || !type.equals(Utility.signatureToString(sig = field.getSignature(), false)) || (cval = field.getConstantValue()) == null) continue;
            int index = cval.getConstantValueIndex();
            ConstantPool cp = this.m_curClass.getConstantPool();
            Constant cnst = cp.getConstant(index);
            if (!(cnst instanceof ConstantString) || !init.equals(value = ((ConstantString)cnst).getConstantValue(cp))) continue;
            return new ClassItem(name, this, field);
        }
        this.deleteField(name);
        FieldGen fgen = new FieldGen(access, Type.getType(Utility.getSignature(type)), name, this.getConstPoolGen());
        fgen.setInitValue(init);
        field = fgen.getField();
        this.getClassGen().addField(field);
        this.m_isModified = true;
        this.m_isHashCurrent = false;
        return new ClassItem(name, this, field);
    }

    public ClassItem addField(String type, String name, int access) throws JiBXException {
        this.deleteField(name);
        FieldGen fgen = new FieldGen(access, Type.getType(Utility.getSignature(type)), name, this.getConstPoolGen());
        Field field = fgen.getField();
        this.getClassGen().addField(field);
        this.m_isModified = true;
        this.m_isHashCurrent = false;
        return new ClassItem(name, this, field);
    }

    public ClassItem addPrivateField(String type, String name) throws JiBXException {
        return this.addField(type, name, 2);
    }

    public ClassItem addDefaultConstructor() throws JiBXException {
        ExceptionMethodBuilder mb = new ExceptionMethodBuilder("<init>", Type.VOID, new Type[0], this, 1);
        mb.appendLoadLocal(0);
        mb.appendCallInit(this.m_superClass.getName(), "()V");
        mb.appendReturn();
        mb.codeComplete(false);
        return mb.addMethod();
    }

    private static boolean isSuffixName(String name) {
        int last;
        for (int i = last = name.length() - 1; i > 0; --i) {
            char chr = name.charAt(i);
            if (chr == '_') {
                return i < last;
            }
            if (!Character.isDigit(chr)) break;
        }
        return false;
    }

    public String makeUniqueMethodName(String name) {
        if (this.m_suffixMap == null) {
            this.m_suffixMap = new HashMap();
            if (this.m_curClass != null) {
                Method[] methods = this.m_curClass.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    Method method = methods[i];
                    String mname = method.getName();
                    if (!ClassFile.isSuffixName(mname)) continue;
                    this.m_suffixMap.put(mname, method);
                }
            }
        }
        if (this.m_inheritDepth == 0) {
            ClassFile cf = this;
            while ((cf = cf.getSuperFile()) != null) {
                ++this.m_inheritDepth;
            }
        }
        String uname;
        while (this.m_suffixMap.get(uname = name + '_' + this.m_inheritDepth + '_' + this.m_uniqueIndex) != null) {
            ++this.m_uniqueIndex;
        }
        return uname;
    }

    public boolean deleteField(String name) throws JiBXException {
        ClassGen cg = this.getClassGen();
        Field field = cg.containsField(name);
        if (field == null) {
            return false;
        }
        cg.removeField(field);
        this.m_isModified = true;
        this.m_isHashCurrent = false;
        return true;
    }

    public int getUseCount() {
        return this.m_useCount;
    }

    public int incrementUseCount() {
        return ++this.m_useCount;
    }

    public boolean isModified() {
        return this.m_isModified;
    }

    public void setModified() {
        this.m_isModified = true;
    }

    public boolean isComplete() {
        return this.m_genClass == null;
    }

    protected int computeHashCode() {
        int hash = this.getPackage().hashCode();
        ClassFile sfile = this.getSuperFile();
        if (sfile != null) {
            hash += sfile.getName().hashCode();
        }
        String[] intfs = this.getInterfaces();
        for (int i = 0; i < intfs.length; ++i) {
            hash += intfs[i].hashCode();
        }
        hash += this.m_curClass.getAccessFlags();
        Field[] fields = this.m_curClass.getFields();
        for (int i = 0; i < fields.length; ++i) {
            hash = hash * 49 + fields[i].getName().hashCode();
        }
        Method[] methods = this.m_curClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            hash = hash * 49 + methods[i].getName().hashCode();
        }
        Constant[] cnsts = this.m_curClass.getConstantPool().getConstantPool();
        for (int i = this.m_curClass.getClassNameIndex() + 1; i < cnsts.length; ++i) {
            Constant cnst = cnsts[i];
            if (cnst == null) continue;
            int value = 0;
            switch (cnst.getTag()) {
                case 6: {
                    value = (int)Double.doubleToRawLongBits(((ConstantDouble)cnst).getBytes());
                    break;
                }
                case 4: {
                    value = Float.floatToRawIntBits(((ConstantFloat)cnst).getBytes());
                    break;
                }
                case 3: {
                    value = ((ConstantInteger)cnst).getBytes();
                    break;
                }
                case 5: {
                    value = (int)((ConstantLong)cnst).getBytes();
                    break;
                }
                case 1: {
                    String text = ((ConstantUtf8)cnst).getBytes();
                    if (text.equals(this.m_signature)) break;
                    value = text.hashCode();
                    break;
                }
            }
            hash = hash * 49 + value;
        }
        return hash;
    }

    public void codeComplete() {
        if (this.m_genClass != null) {
            this.m_curClass = this.m_genClass.getJavaClass();
            this.m_interfaces = this.m_curClass.getInterfaceNames();
            this.m_genClass = null;
        }
    }

    public int hashCode() {
        if (!this.m_isHashCurrent) {
            if (this.m_genClass != null) {
                throw new IllegalStateException("Class still being constructed");
            }
            this.m_hashCode = this.computeHashCode();
            this.m_isHashCurrent = true;
        }
        return this.m_hashCode;
    }

    public static boolean equalFieldOrMethods(FieldOrMethod a, FieldOrMethod b) {
        return a.getName().equals(b.getName()) && a.getSignature().equals(b.getSignature());
    }

    public static boolean equalMethods(Method a, Method b) {
        CodeException[] bcexs;
        Object[] bexcepts;
        Object[] aexcepts;
        ExceptionTable etaba = a.getExceptionTable();
        ExceptionTable etabb = b.getExceptionTable();
        if (etaba != null && etabb != null ? !Arrays.equals(aexcepts = etaba.getExceptionNames(), bexcepts = etabb.getExceptionNames()) : etaba != null || etabb != null) {
            return false;
        }
        Code acode = a.getCode();
        Code bcode = b.getCode();
        CodeException[] acexs = acode.getExceptionTable();
        if (acexs.length == (bcexs = bcode.getExceptionTable()).length) {
            for (int i = 0; i < acexs.length; ++i) {
                CodeException acex = acexs[i];
                CodeException bcex = bcexs[i];
                if (acex.getCatchType() == bcex.getCatchType() && acex.getStartPC() == bcex.getStartPC() && acex.getEndPC() == bcex.getEndPC() && acex.getHandlerPC() == bcex.getHandlerPC()) continue;
                return false;
            }
        }
        return Arrays.equals(acode.getCode(), bcode.getCode());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassFile && obj.hashCode() == this.hashCode()) {
            Constant[] ccnsts;
            Method[] cmethods;
            Field[] cfields;
            ClassFile comp = (ClassFile)obj;
            if (!org.jibx.runtime.Utility.isEqual(this.getPackage(), comp.getPackage()) || this.getSuperFile() != comp.getSuperFile() || !Arrays.equals(this.getInterfaces(), comp.getInterfaces())) {
                return false;
            }
            JavaClass tjc = this.m_curClass;
            JavaClass cjc = comp.m_curClass;
            if (tjc.getAccessFlags() != cjc.getAccessFlags()) {
                return false;
            }
            Field[] tfields = tjc.getFields();
            if (tfields.length != (cfields = cjc.getFields()).length) {
                return false;
            }
            for (int i = 0; i < tfields.length; ++i) {
                if (ClassFile.equalFieldOrMethods(tfields[i], cfields[i])) continue;
                return false;
            }
            Method[] tmethods = tjc.getMethods();
            if (tmethods.length != (cmethods = cjc.getMethods()).length) {
                return false;
            }
            for (int i = 0; i < tmethods.length; ++i) {
                Method tmethod = tmethods[i];
                Method cmethod = cmethods[i];
                if (ClassFile.equalFieldOrMethods(tmethod, cmethod) && ClassFile.equalMethods(tmethod, cmethod)) continue;
                return false;
            }
            Constant[] tcnsts = tjc.getConstantPool().getConstantPool();
            if (tcnsts.length != (ccnsts = cjc.getConstantPool().getConstantPool()).length) {
                return false;
            }
            for (int i = tjc.getClassNameIndex() + 1; i < tcnsts.length; ++i) {
                Constant tcnst = tcnsts[i];
                Constant ccnst = ccnsts[i];
                if (tcnst != null && ccnst != null) {
                    byte tag = tcnst.getTag();
                    if (tag != ccnst.getTag()) {
                        return false;
                    }
                    boolean equal = true;
                    switch (tag) {
                        case 6: {
                            equal = ((ConstantDouble)tcnst).getBytes() == ((ConstantDouble)ccnst).getBytes();
                            break;
                        }
                        case 4: {
                            equal = ((ConstantFloat)tcnst).getBytes() == ((ConstantFloat)ccnst).getBytes();
                            break;
                        }
                        case 3: {
                            equal = ((ConstantInteger)tcnst).getBytes() == ((ConstantInteger)ccnst).getBytes();
                            break;
                        }
                        case 5: {
                            equal = ((ConstantLong)tcnst).getBytes() == ((ConstantLong)ccnst).getBytes();
                            break;
                        }
                        case 1: {
                            String ttext = ((ConstantUtf8)tcnst).getBytes();
                            String ctext = ((ConstantUtf8)ccnst).getBytes();
                            if (ttext.equals(this.m_signature)) {
                                equal = ctext.equals(comp.m_signature);
                                break;
                            }
                            equal = ttext.equals(ctext);
                            break;
                        }
                    }
                    if (equal) continue;
                    return false;
                }
                if (tcnst == null && ccnst == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void delete() throws IOException {
        if (this.m_file.exists()) {
            this.m_file.delete();
        }
    }

    public void writeFile(OutputStream os) throws IOException {
        this.codeComplete();
        this.m_curClass.dump(os);
        os.close();
    }

    public void writeFile() throws IOException {
        if (this.m_isModified) {
            FileOutputStream os = new FileOutputStream(this.m_file);
            this.writeFile(os);
        }
    }

    public String deriveClassName(String prefix, String suffix) {
        String pack = "";
        String tname = this.m_name;
        int split = tname.lastIndexOf(46);
        if (split >= 0) {
            pack = tname.substring(0, split + 1);
            tname = tname.substring(split + 1);
        }
        return pack + prefix + tname + suffix;
    }

    public static void setPaths(String[] paths) {
        StringBuffer full = new StringBuffer();
        for (int i = 0; i < paths.length; ++i) {
            if (i > 0) {
                full.append(File.pathSeparatorChar);
            }
            full.append(paths[i]);
        }
        s_loader = new ClassPath(full.toString());
        URL[] urls = new URL[paths.length];
        try {
            for (int i = 0; i < urls.length; ++i) {
                String path = paths[i];
                int mark = path.lastIndexOf(47);
                if (path.indexOf(46, mark) < 0) {
                    path = path + '/';
                }
                urls[i] = new URL("file:" + path);
            }
            s_directLoader = new URLClassLoader(urls);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Error initializing classloading: " + ex.getMessage());
        }
    }

    public static Class loadClass(String name) {
        try {
            return s_directLoader.loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }
}

