/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.jibx.binding.model.ClassHierarchyContext;
import org.jibx.binding.model.FormatElement;
import org.jibx.binding.model.IClass;
import org.jibx.binding.model.NameAttributes;
import org.jibx.binding.model.NamespaceElement;
import org.jibx.binding.model.StructureElementBase;
import org.jibx.binding.model.TemplateElement;
import org.jibx.binding.model.TemplateElementBase;
import org.jibx.binding.model.ValidationContext;
import org.jibx.binding.model.ValidationProblem;

public class DefinitionContext {
    private final DefinitionContext m_outerContext;
    private NamespaceElement m_attributeDefault;
    private NamespaceElement m_elementDefault;
    private ArrayList m_namespaces;
    private HashMap m_prefixMap;
    private HashMap m_uriMap;
    private ClassHierarchyContext m_formatContext;
    private ClassHierarchyContext m_templateContext;
    private HashMap m_namedStructureMap;

    protected DefinitionContext(DefinitionContext outer) {
        this.m_outerContext = outer;
    }

    public DefinitionContext getContaining() {
        return this.m_outerContext;
    }

    private ClassHierarchyContext getContainingFormatContext() {
        if (this.m_outerContext == null) {
            return null;
        }
        return this.m_outerContext.getFormatContext();
    }

    private ClassHierarchyContext getFormatContext() {
        if (this.m_formatContext == null) {
            return this.getContainingFormatContext();
        }
        return this.m_formatContext;
    }

    private ClassHierarchyContext getContainingTemplateContext() {
        if (this.m_outerContext == null) {
            return null;
        }
        return this.m_outerContext.getTemplateContext();
    }

    private ClassHierarchyContext getTemplateContext() {
        if (this.m_templateContext == null) {
            return this.getContainingTemplateContext();
        }
        return this.m_templateContext;
    }

    public ValidationProblem addNamespace(NamespaceElement def) {
        String prefix;
        if (this.m_namespaces == null) {
            this.m_namespaces = new ArrayList();
            this.m_prefixMap = new HashMap();
            this.m_uriMap = new HashMap();
        }
        if (def.isAttributeDefault()) {
            if (this.m_attributeDefault == null) {
                this.m_attributeDefault = def;
            } else {
                return new ValidationProblem("Conflicting attribute namespaces", def);
            }
        }
        if (def.isElementDefault()) {
            if (this.m_elementDefault == null) {
                this.m_elementDefault = def;
            } else {
                return new ValidationProblem("Conflicting element namespaces", def);
            }
        }
        if (this.m_prefixMap.get(prefix = def.getPrefix()) != null) {
            return new ValidationProblem("Namespace prefix conflict", def);
        }
        String uri = def.getUri();
        Object prior = this.m_uriMap.get(uri);
        if (prior != null && ((NamespaceElement)prior).getPrefix() != null) {
            return null;
        }
        this.m_namespaces.add(def);
        this.m_prefixMap.put(prefix, def);
        this.m_uriMap.put(uri, def);
        return null;
    }

    public NamespaceElement getElementNamespace(NameAttributes name) {
        String uri = name.getUri();
        String prefix = name.getPrefix();
        NamespaceElement ns = null;
        if (uri != null) {
            if (this.m_uriMap != null && (ns = (NamespaceElement)this.m_uriMap.get(uri)) != null && prefix != null && !prefix.equals(ns.getPrefix())) {
                ns = null;
            }
        } else if (prefix != null) {
            if (this.m_prefixMap != null) {
                ns = (NamespaceElement)this.m_prefixMap.get(prefix);
            }
        } else {
            ns = this.m_elementDefault;
        }
        if (ns == null && this.m_outerContext != null) {
            ns = this.m_outerContext.getElementNamespace(name);
        }
        return ns;
    }

    public NamespaceElement getAttributeNamespace(NameAttributes name) {
        String uri = name.getUri();
        String prefix = name.getPrefix();
        NamespaceElement ns = null;
        if (uri != null) {
            if (this.m_uriMap != null && (ns = (NamespaceElement)this.m_uriMap.get(uri)) != null && prefix != null && !prefix.equals(ns.getPrefix())) {
                ns = null;
            }
        } else if (prefix != null) {
            if (this.m_prefixMap != null) {
                ns = (NamespaceElement)this.m_prefixMap.get(prefix);
            }
        } else {
            ns = this.m_attributeDefault;
        }
        if (ns == null && this.m_outerContext != null) {
            ns = this.m_outerContext.getAttributeNamespace(name);
        }
        return ns;
    }

    public void addFormat(FormatElement def, ValidationContext vctx) {
        if (this.m_formatContext == null) {
            this.m_formatContext = new ClassHierarchyContext(this.getContainingFormatContext());
        }
        if (def.isDefaultFormat()) {
            IClass clas = def.getType();
            this.m_formatContext.addTypedComponent(clas, def, vctx);
        }
        if (def.getLabel() != null) {
            this.m_formatContext.addNamedComponent(def.getLabel(), def, vctx);
        }
    }

    public FormatElement getSpecificFormat(String type) {
        ClassHierarchyContext ctx = this.getFormatContext();
        if (ctx == null) {
            return null;
        }
        return (FormatElement)ctx.getSpecificComponent(type);
    }

    public FormatElement getNamedFormat(String name) {
        ClassHierarchyContext ctx = this.getFormatContext();
        if (ctx == null) {
            return null;
        }
        return (FormatElement)ctx.getNamedComponent(name);
    }

    public FormatElement getBestFormat(IClass clas) {
        ClassHierarchyContext ctx = this.getFormatContext();
        if (ctx == null) {
            return null;
        }
        return (FormatElement)ctx.getBestComponent(clas);
    }

    public void addTemplate(TemplateElementBase def, ValidationContext vctx) {
        TemplateElement tdef;
        if (this.m_templateContext == null) {
            this.m_templateContext = new ClassHierarchyContext(this.getContainingTemplateContext());
        }
        if (def.isDefaultTemplate()) {
            IClass clas = def.getHandledClass();
            this.m_templateContext.addTypedComponent(clas, def, vctx);
        }
        if (def instanceof TemplateElement && (tdef = (TemplateElement)def).getLabel() != null) {
            this.m_templateContext.addNamedComponent(tdef.getLabel(), def, vctx);
        }
    }

    public TemplateElementBase getSpecificTemplate(String type) {
        ClassHierarchyContext ctx = this.getTemplateContext();
        if (ctx == null) {
            return null;
        }
        return (TemplateElementBase)ctx.getSpecificComponent(type);
    }

    public TemplateElement getNamedTemplate(String name) {
        ClassHierarchyContext ctx = this.getTemplateContext();
        if (ctx == null) {
            return null;
        }
        return (TemplateElement)ctx.getNamedComponent(name);
    }

    public TemplateElementBase getBestTemplate(IClass clas) {
        ClassHierarchyContext ctx = this.getTemplateContext();
        if (ctx == null) {
            return null;
        }
        return (TemplateElementBase)ctx.getBestComponent(clas);
    }

    public boolean isCompatibleTemplateType(IClass clas) {
        ClassHierarchyContext chctx = this.getTemplateContext();
        if (chctx == null) {
            return false;
        }
        return chctx.isCompatibleType(clas);
    }

    public ValidationProblem addNamedStructure(StructureElementBase def) {
        String label;
        if (this.m_namedStructureMap == null) {
            this.m_namedStructureMap = new HashMap();
        }
        if (this.m_namedStructureMap.get(label = def.getLabel()) == null) {
            this.m_namedStructureMap.put(label, def);
            return null;
        }
        return new ValidationProblem("Duplicate label " + label, def);
    }

    public StructureElementBase getNamedStructure(String label) {
        if (this.m_namedStructureMap == null) {
            return null;
        }
        return (StructureElementBase)this.m_namedStructureMap.get(label);
    }
}

