/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.extras;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class DocumentComparator {
    protected XmlPullParser m_parserA;
    protected XmlPullParser m_parserB;
    protected PrintStream m_differencePrint;

    public DocumentComparator(PrintStream print) throws XmlPullParserException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance();
        factory.setNamespaceAware(true);
        this.m_parserA = factory.newPullParser();
        this.m_parserB = factory.newPullParser();
        this.m_differencePrint = print;
    }

    protected String buildPositionString(XmlPullParser parser) {
        return " line " + parser.getLineNumber() + ", col " + parser.getColumnNumber();
    }

    protected void printError(String msg) {
        if (this.m_differencePrint != null) {
            this.m_differencePrint.println(msg + " - from " + this.buildPositionString(this.m_parserA) + " to " + this.buildPositionString(this.m_parserB));
        }
    }

    protected boolean matchAttributes() {
        int count = this.m_parserA.getAttributeCount();
        if (this.m_parserB.getAttributeCount() != count) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            String name = this.m_parserA.getAttributeName(i);
            String ns = this.m_parserA.getAttributeNamespace(i);
            String value = this.m_parserA.getAttributeValue(i);
            if (value.equals(this.m_parserB.getAttributeValue(ns, name))) continue;
            return false;
        }
        return true;
    }

    protected boolean matchNames() {
        return this.m_parserA.getName().equals(this.m_parserB.getName()) && this.m_parserA.getNamespace().equals(this.m_parserB.getNamespace());
    }

    public boolean compare(Reader rdra, Reader rdrb) {
        try {
            this.m_parserA.setInput(rdra);
            this.m_parserB.setInput(rdrb);
            boolean content = false;
            String texta = "";
            String textb = "";
            while (true) {
                int typeb;
                int typea;
                if (this.m_parserA.getEventType() == 4) {
                    texta = this.m_parserA.getText();
                    this.m_parserA.next();
                }
                if (this.m_parserB.getEventType() == 4) {
                    textb = this.m_parserB.getText();
                    this.m_parserB.next();
                }
                if ((typea = this.m_parserA.getEventType()) != (typeb = this.m_parserB.getEventType())) {
                    this.printError("Different document structure");
                    return false;
                }
                if (typea == 2) {
                    content = true;
                    if (!this.matchNames()) {
                        this.printError("Different start tags");
                        return false;
                    }
                    if (!this.matchAttributes()) {
                        this.printError("Different attributes");
                        return false;
                    }
                    if (!texta.trim().equals(textb.trim())) {
                        this.printError("Different text content between elements");
                        return false;
                    }
                    textb = "";
                    texta = "";
                } else if (typea == 3) {
                    if (!this.matchNames()) {
                        this.printError("Different end tags");
                        return false;
                    }
                    if (content) {
                        if (!texta.equals(textb)) {
                            this.printError("Different text content");
                            if (this.m_differencePrint != null) {
                                this.m_differencePrint.println(" \"" + texta + "\" (length " + texta.length() + " vs. \"" + textb + "\" (length " + textb.length() + ')');
                            }
                            return false;
                        }
                        content = false;
                    } else if (!texta.trim().equals(textb.trim())) {
                        this.printError("Different text content between elements");
                        return false;
                    }
                    textb = "";
                    texta = "";
                } else if (typea == 1) {
                    return true;
                }
                this.m_parserA.next();
                this.m_parserB.next();
            }
        }
        catch (IOException ex) {
            if (this.m_differencePrint != null) {
                ex.printStackTrace(this.m_differencePrint);
            }
            return false;
        }
        catch (XmlPullParserException ex) {
            if (this.m_differencePrint != null) {
                ex.printStackTrace(this.m_differencePrint);
            }
            return false;
        }
    }
}

