/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import org.metaqtl.CMarkerSequence;
import org.metaqtl.Chromosome;
import org.metaqtl.MetaDico;
import org.metaqtl.algo.CMSAlgorithm;
import org.metaqtl.bio.IBioCross;
import org.metaqtl.bio.IBioLGroup;
import org.metaqtl.bio.IBioLocus;
import org.metaqtl.numrec.NumericalUtilities;
import org.metaqtl.util.LocusProperties;
import org.metaqtl.util.MappingFunction;

public class ChromCluster {
    private int mrkThresh = 1;
    public int nmc = 0;
    public int ni = 0;
    public String name;
    public Hashtable locusNames;
    public ArrayList clusters = new ArrayList();
    private String[] _nameIdx;
    private IBioLocus[] dubious = null;
    private MetaDico mrkDico = null;

    public ChromCluster() {
        this.locusNames = new Hashtable();
    }

    public void addChromosome(IBioLGroup group, IBioCross crossDesign, int mappingFunction, int mappingUnit, boolean rescale, boolean skeleton) {
        ArrayList<IBioLocus> qtls = null;
        IBioLocus[] loci = group.loci();
        int[] oidx = new int[loci.length];
        int[] idx = new int[loci.length + 1];
        double[] positions = new double[loci.length + 1];
        double[] mr = new double[loci.length - 1];
        String[] names = new String[loci.length];
        double start = Double.POSITIVE_INFINITY;
        double end = Double.NEGATIVE_INFINITY;
        int i = 0;
        int nm = 0;
        while (i < loci.length) {
            if (loci[i].getLocusType() == 0) {
                if (loci[i].getPosition().absolute() < start) {
                    start = loci[i].getPosition().absolute();
                } else if (loci[i].getPosition().absolute() > end) {
                    end = loci[i].getPosition().absolute();
                }
            }
            ++i;
        }
        i = 0;
        nm = 0;
        while (i < loci.length) {
            boolean status;
            boolean bl = status = !LocusProperties.isDubiousOrderLocus(loci[i]) && !this.isDubiousLocus(loci[i]);
            if (status) {
                if (loci[i].getLocusType() == 0) {
                    positions[nm + 1] = loci[i].getPosition().absolute();
                    oidx[nm] = i;
                    String locusName = this.getMarkerName(loci[i].getName());
                    if (!this.locusNames.containsKey(locusName)) {
                        this.locusNames.put(locusName, new Integer(1));
                    } else {
                        Integer locusCount = (Integer)this.locusNames.get(locusName);
                        locusCount = new Integer(locusCount + 1);
                        this.locusNames.put(locusName, locusCount);
                        ++this.nmc;
                    }
                    ++nm;
                } else if (loci[i].getLocusType() == 1 && !(loci[i].getPosition().absolute() < start) && !(loci[i].getPosition().absolute() > end)) {
                    if (qtls == null) {
                        qtls = new ArrayList<IBioLocus>();
                    }
                    qtls.add(loci[i]);
                }
            }
            ++i;
        }
        if (nm > 1) {
            NumericalUtilities.indexx(nm, positions, idx);
        }
        names[0] = this.getMarkerName(loci[oidx[idx[1] - 1]].getName());
        double d = 0.0;
        i = 1;
        while (i < nm) {
            double d1 = positions[idx[i]];
            double d2 = positions[idx[i + 1]];
            mr[i - 1] = MappingFunction.recombination(d2 - d1, mappingFunction, mappingUnit);
            d += MappingFunction.distance(mr[i - 1], mappingFunction, mappingUnit);
            names[i] = this.getMarkerName(loci[oidx[idx[i + 1] - 1]].getName());
            if (!skeleton) {
                ++this.ni;
            }
            ++i;
        }
        Chromosome member = new Chromosome();
        if (group.getParent() != null) {
            member.mapName = group.getParent().getName();
        }
        member.name = group.getName();
        member.nm = nm;
        member.mr = mr;
        member.totd = d;
        member.mrkNames = names;
        member.ct = crossDesign.getCrossType();
        member.cs = crossDesign.getSize();
        member.cg = crossDesign.getGeneration();
        member.skeleton = skeleton;
        member.mfc = mappingFunction;
        member.mut = mappingUnit;
        if (qtls != null) {
            loci = new IBioLocus[qtls.size()];
            qtls.toArray(loci);
            member.attachQTL(loci);
        }
        if (rescale) {
            member.R2r();
        }
        this.clusters.add(member);
    }

    public boolean isDubiousLocus(IBioLocus locus) {
        if (this.dubious == null) {
            return false;
        }
        int i = 0;
        while (i < this.dubious.length) {
            if (this.dubious[i].getName().equals(locus.getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Chromosome[] getClusterMembers() {
        if (this.clusters == null) {
            return null;
        }
        if (this.clusters.size() == 0) {
            return null;
        }
        if (this._nameIdx != null) {
            ArrayList<Chromosome> memberList = new ArrayList<Chromosome>();
            int i = 0;
            while (i < this.clusters.size()) {
                Chromosome chrom = (Chromosome)this.clusters.get(i);
                Chromosome subChrom = chrom.getSubChromosome(this._nameIdx);
                if (subChrom != null) {
                    memberList.add(subChrom);
                }
                ++i;
            }
            if (memberList.size() > 0) {
                Chromosome[] members = new Chromosome[memberList.size()];
                memberList.toArray(members);
                return members;
            }
            return null;
        }
        if (this.clusters != null) {
            Chromosome[] members = new Chromosome[this.clusters.size()];
            this.clusters.toArray(members);
            return members;
        }
        return null;
    }

    public int getMarkerNumber() {
        if (this._nameIdx == null) {
            return 0;
        }
        return this._nameIdx.length;
    }

    public int getMarkerIntervalNumber() {
        return this.ni;
    }

    public void fixCluster() {
        Integer mrkCount;
        if (this.locusNames == null) {
            return;
        }
        if (this.locusNames.size() == 0) {
            return;
        }
        int nmrk = 0;
        Enumeration enu = this.locusNames.keys();
        while (enu.hasMoreElements()) {
            mrkCount = (Integer)this.locusNames.get(enu.nextElement());
            if (mrkCount < this.mrkThresh) continue;
            ++nmrk;
        }
        if (nmrk > 0) {
            enu = this.locusNames.keys();
            this._nameIdx = new String[nmrk];
            int i = 0;
            while (enu.hasMoreElements()) {
                this._nameIdx[i] = (String)enu.nextElement();
                mrkCount = (Integer)this.locusNames.get(this._nameIdx[i]);
                if (mrkCount >= this.mrkThresh) {
                    ++i;
                }
                if (i >= nmrk) break;
            }
        }
    }

    public int getMarkerIndexByName(String mrkName) {
        if (this._nameIdx == null) {
            return -1;
        }
        int i = 0;
        while (i < this._nameIdx.length) {
            if (this._nameIdx[i].equals(mrkName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void mvMarkerIndexToEnd(int i) {
        String tmp = this._nameIdx[i];
        int j = i;
        while (j < this._nameIdx.length - 1) {
            this._nameIdx[j] = this._nameIdx[j + 1];
            ++j;
        }
        this._nameIdx[j] = tmp;
    }

    public String getMarkerNameByIndex(int i) {
        return this._nameIdx[i];
    }

    public int getMarkerOccurence(int i) {
        Integer ii = (Integer)this.locusNames.get(this._nameIdx[i]);
        if (ii != null) {
            return ii;
        }
        return 0;
    }

    public String getMarkerName(String name) {
        if (this.mrkDico == null) {
            return new String(name);
        }
        String s = this.mrkDico.getTerm(name);
        return s != null ? s : name;
    }

    public void setDubiousMarker(IBioLocus[] dubious) {
        this.dubious = dubious;
    }

    public String getName() {
        return this.name;
    }

    public MetaDico getMarkerDico() {
        return this.mrkDico;
    }

    public void setMarkerDico(MetaDico mrkDico) {
        this.mrkDico = mrkDico;
    }

    public double[] getCMrkTotalNumbers() {
        double[] ratios = new double[this.clusters.size()];
        int i = 0;
        while (i < this.clusters.size()) {
            Chromosome cur1 = (Chromosome)this.clusters.get(i);
            int j = i + 1;
            while (j < this.clusters.size()) {
                Chromosome cur2 = (Chromosome)this.clusters.get(j);
                CMarkerSequence cms = CMSAlgorithm.run(cur1, cur2);
                if (cms != null) {
                    int n = i;
                    ratios[n] = ratios[n] + (double)cms.nmc;
                    int n2 = j;
                    ratios[n2] = ratios[n2] + (double)cms.nmc;
                }
                ++j;
            }
            ++i;
        }
        return ratios;
    }

    public boolean isConnected(int nMrk) {
        ClusterGraph graph = new ClusterGraph(this);
        int i = 0;
        while (i < this.clusters.size()) {
            Chromosome cur1 = (Chromosome)this.clusters.get(i);
            int j = i + 1;
            while (j < this.clusters.size()) {
                Chromosome cur2 = (Chromosome)this.clusters.get(j);
                CMarkerSequence cms = CMSAlgorithm.run(cur1, cur2);
                if (cms != null && cms.nmc >= nMrk) {
                    graph.addEdge(cur1, cur2, cms);
                }
                ++j;
            }
            ++i;
        }
        return graph.isConnected(nMrk);
    }

    public void setMrkThresh(int mrkThresh) {
        this.mrkThresh = mrkThresh;
    }

    public ClusterGraph getGraph() {
        Chromosome[] chroms = this.getClusterMembers();
        if (chroms != null) {
            ClusterGraph graph = new ClusterGraph(this);
            int i = 0;
            while (i < chroms.length) {
                int j = i + 1;
                while (j < chroms.length) {
                    CMarkerSequence cms = CMSAlgorithm.run(chroms[i], chroms[j]);
                    if (cms != null) {
                        graph.addEdge(chroms[i], chroms[j], cms);
                    }
                    ++j;
                }
                ++i;
            }
            return graph;
        }
        return null;
    }

    public class ClusterGraph {
        public Hashtable adjTable;
        public ChromCluster cluster;

        public ClusterGraph(ChromCluster cluster) {
            this.cluster = cluster;
            this.adjTable = new Hashtable();
        }

        public boolean isConnected(int nMrk) {
            if (!this.adjTable.keySet().isEmpty()) {
                Chromosome x = (Chromosome)this.adjTable.keySet().iterator().next();
                ArrayList<Chromosome> L = new ArrayList<Chromosome>();
                ArrayList<Chromosome> K = new ArrayList<Chromosome>();
                L.add(x);
                K.add(x);
                do {
                    Chromosome y = (Chromosome)K.get(0);
                    K.remove(0);
                    ArrayList edges = (ArrayList)this.adjTable.get(y);
                    int i = 0;
                    while (i < edges.size()) {
                        Chromosome z;
                        ClusterEdge edge = (ClusterEdge)edges.get(i);
                        if (edge.cms.nmc >= nMrk && !L.contains(z = edge.chrom)) {
                            L.add(z);
                            K.add(z);
                        }
                        ++i;
                    }
                } while (!K.isEmpty());
                return L.size() == this.adjTable.size();
            }
            return false;
        }

        public void addEdge(Chromosome cur1, Chromosome cur2, CMarkerSequence cms) {
            ArrayList adj;
            if (!this.adjTable.containsKey(cur1)) {
                adj = new ArrayList();
                this.adjTable.put(cur1, adj);
            } else {
                adj = (ArrayList)this.adjTable.get(cur1);
            }
            adj.add(new ClusterEdge(cms, cur2));
            if (!this.adjTable.containsKey(cur2)) {
                adj = new ArrayList();
                this.adjTable.put(cur2, adj);
            } else {
                adj = (ArrayList)this.adjTable.get(cur2);
            }
            adj.add(new ClusterEdge(cms, cur1));
        }

        public Hashtable getAdjacentTable() {
            return this.adjTable;
        }

        public void summarize(OutputStream stream) {
            int j;
            double tot;
            PrintWriter writer = new PrintWriter(stream);
            Hashtable<String, String> buffer = new Hashtable<String, String>();
            String[] labels = this.getVLabels();
            writer.println(">CR " + this.cluster.name + " Connected=" + this.isConnected(1));
            writer.println("#");
            writer.println("# Table of the chromosomes");
            writer.println("#");
            buffer = new Hashtable(labels.length);
            ArrayList<String> keys = new ArrayList<String>(labels.length);
            int i = 0;
            double ntot = tot = (double)0;
            while (i < labels.length) {
                Chromosome c = this.getChrom(i);
                keys.add(labels[i]);
                buffer.put(labels[i], new String(String.valueOf(labels[i]) + "\t" + c.nm + "\t" + c.totd / (double)c.nm));
                tot += (double)c.nm;
                ntot += c.totd / (double)c.nm;
                ++i;
            }
            Collections.sort(keys);
            int[] index = new int[keys.size()];
            i = 0;
            while (i < labels.length) {
                writer.println(String.valueOf(i + 1) + "\t" + buffer.get(keys.get(i)));
                j = 0;
                while (j < labels.length) {
                    if (labels[j].equals(keys.get(i))) {
                        index[i] = j;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            writer.println("#");
            writer.println("# Average number of marker per chrom m=" + (tot /= (double)labels.length));
            writer.println("# Average interval marker distance=" + (ntot /= (double)labels.length));
            writer.println("#");
            double[][] values = this.getEValues(1);
            i = 0;
            tot = 0;
            while (i < values.length) {
                j = i + 1;
                while (j < values.length) {
                    if (!Double.isNaN(values[i][j])) {
                        double prop = 2.0 * values[i][j];
                        ntot = this.getChrom((int)i).nm;
                        tot += (prop /= (ntot += (double)this.getChrom((int)j).nm));
                    }
                    ++j;
                }
                ++i;
            }
            writer.println("#");
            writer.println("# Table of the number of common markers");
            writer.println("#");
            writer.println("# Total number of marker M=" + this.cluster.getMarkerNumber());
            writer.println("# Prop of common markers p=" + (tot /= 0.5 * (double)values.length * (double)(values.length - 1)));
            writer.println("#");
            writer.print("Chrom\tIndex");
            j = 0;
            while (j < labels.length) {
                writer.print("\t" + (j + 1));
                ++j;
            }
            writer.println("\tTotal");
            i = 0;
            while (i < labels.length) {
                writer.print(String.valueOf(labels[index[i]]) + "\t" + (i + 1));
                tot = 0.0;
                j = 0;
                while (j <= i) {
                    writer.print("\t");
                    if (!Double.isNaN(values[index[i]][index[j]])) {
                        tot += values[index[i]][index[j]];
                    }
                    ++j;
                }
                j = i + 1;
                while (j < labels.length) {
                    if (!Double.isNaN(values[index[i]][index[j]])) {
                        writer.print("\t" + values[index[i]][index[j]]);
                        tot += values[index[i]][index[j]];
                    } else {
                        writer.print("\t");
                    }
                    ++j;
                }
                writer.println("\t" + tot);
                ++i;
            }
            writer.println();
            writer.println("#");
            writer.println("# Table of the number of common sequences");
            writer.println("#");
            values = this.getEValues(2);
            writer.print("Chrom\tIndex");
            j = 0;
            while (j < labels.length) {
                writer.print("\t" + (j + 1));
                ++j;
            }
            writer.println();
            i = 0;
            while (i < labels.length) {
                writer.print(String.valueOf(labels[index[i]]) + "\t" + (i + 1));
                j = 0;
                while (j <= i) {
                    writer.print("\t");
                    ++j;
                }
                j = i + 1;
                while (j < labels.length) {
                    if (!Double.isNaN(values[index[i]][index[j]])) {
                        writer.print("\t" + values[index[i]][index[j]]);
                    } else {
                        writer.print("\t");
                    }
                    ++j;
                }
                writer.println();
                ++i;
            }
            writer.println();
            writer.println("#");
            writer.println("# Table of proportion of marker implied in common sequences");
            writer.println("# The value can be negative depending on the frame of the  ");
            writer.println("# common sequences");
            writer.println("#");
            values = this.getEValues(3);
            writer.print("Chrom\tIndex");
            j = 0;
            while (j < labels.length) {
                writer.print("\t" + (j + 1));
                ++j;
            }
            writer.println();
            i = 0;
            while (i < labels.length) {
                writer.print(String.valueOf(labels[index[i]]) + "\t" + (i + 1));
                j = 0;
                while (j <= i) {
                    writer.print("\t");
                    ++j;
                }
                j = i + 1;
                while (j < labels.length) {
                    if (!Double.isNaN(values[index[i]][index[j]])) {
                        writer.print("\t" + values[index[i]][index[j]]);
                    } else {
                        writer.print("\t");
                    }
                    ++j;
                }
                writer.println();
                ++i;
            }
            writer.println();
            writer.flush();
        }

        public String[] getVLabels() {
            String[] labels = new String[this.adjTable.size()];
            Enumeration iter = this.adjTable.keys();
            int i = 0;
            while (iter.hasMoreElements()) {
                Chromosome c = (Chromosome)iter.nextElement();
                labels[i++] = c.getMapName();
            }
            return labels;
        }

        private double[][] getEValues(int mode) {
            int j;
            double[][] values = new double[this.adjTable.size()][this.adjTable.size()];
            int i = 0;
            while (i < values.length) {
                j = 0;
                while (j < values.length) {
                    values[i][j] = Double.NaN;
                    ++j;
                }
                ++i;
            }
            j = 0;
            i = 0;
            Enumeration iter = this.adjTable.keys();
            while (iter.hasMoreElements()) {
                Chromosome c = (Chromosome)iter.nextElement();
                ArrayList edges = (ArrayList)this.adjTable.get(c);
                if (edges == null) continue;
                int k = 0;
                while (k < edges.size()) {
                    ClusterEdge edge = (ClusterEdge)edges.get(k);
                    i = this.getVIndex(edge);
                    switch (mode) {
                        case 1: {
                            values[j][i] = edge.cms.nmc;
                            break;
                        }
                        case 2: {
                            if (edge.cms.nmc <= 1) break;
                            values[j][i] = edge.cms.ncs;
                            break;
                        }
                        case 3: {
                            if (edge.cms.nmc <= 1) break;
                            values[j][i] = 0.0;
                            int l = 0;
                            while (l < edge.cms.ncs) {
                                if (edge.cms.frames[l]) {
                                    double[] dArray = values[j];
                                    int n = i;
                                    dArray[n] = dArray[n] + (double)edge.cms.css[l];
                                } else {
                                    double[] dArray = values[j];
                                    int n = i;
                                    dArray[n] = dArray[n] - (double)edge.cms.css[l];
                                }
                                ++l;
                            }
                            double[] dArray = values[j];
                            int n = i;
                            dArray[n] = dArray[n] / (double)edge.cms.nmc;
                        }
                    }
                    ++k;
                }
                ++j;
            }
            return values;
        }

        private int getVIndex(ClusterEdge e) {
            int idx = 0;
            Chromosome c = e.chrom;
            Enumeration iter = this.adjTable.keys();
            while (iter.hasMoreElements()) {
                Chromosome c1 = (Chromosome)iter.nextElement();
                if (c1.getMapName().equals(c.getMapName())) break;
                ++idx;
            }
            return idx;
        }

        private Chromosome getChrom(int idx) {
            int i = 0;
            Enumeration iter = this.adjTable.keys();
            while (iter.hasMoreElements()) {
                Chromosome c = (Chromosome)iter.nextElement();
                if (i == idx) {
                    return c;
                }
                ++i;
            }
            return null;
        }
    }

    public class ClusterEdge {
        public CMarkerSequence cms;
        public Chromosome chrom;

        public ClusterEdge(CMarkerSequence cms, Chromosome chrom) {
            this.cms = cms;
            this.chrom = chrom;
        }
    }
}

