/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import org.metaqtl.EMResult;

public class EMCriteria
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int AIC = 0;
    public static final int AIC3 = 1;
    public static final int ICOMP = 2;
    public static final int BIC = 3;
    public static final int AWE = 4;
    public static final int AICc = 5;
    public static final String AIC_NAME = "AIC";
    public static final String AICc_NAME = "AICc";
    public static final String AIC3_NAME = "AIC3";
    public static final String ICOMP_NAME = "ICOMP";
    public static final String BIC_NAME = "BIC";
    public static final String AWE_NAME = "AWE";
    public double aic = Double.POSITIVE_INFINITY;
    public double aicc = Double.POSITIVE_INFINITY;
    public double aic3 = Double.POSITIVE_INFINITY;
    public double bic = Double.POSITIVE_INFINITY;
    public double mir = Double.POSITIVE_INFINITY;
    public double icomp = Double.POSITIVE_INFINITY;
    public double awe = Double.POSITIVE_INFINITY;

    public double getCriterion(int criterion) {
        switch (criterion) {
            case 0: {
                return this.aic;
            }
            case 5: {
                return this.aicc;
            }
            case 1: {
                return this.aic3;
            }
            case 2: {
                return this.icomp;
            }
            case 3: {
                return this.bic;
            }
            case 4: {
                return this.awe;
            }
        }
        return this.aic;
    }

    public static EMResult getBestResult(EMResult[] clusterings, int criterion) {
        if (clusterings == null) {
            return null;
        }
        int mini = -1;
        double min = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < clusterings.length) {
            if (clusterings[i] != null) {
                double u = clusterings[i].criteria.getCriterion(criterion);
                if (u < min && i == mini + 1) {
                    min = u;
                    mini = i;
                } else if (i > mini + 1) break;
            }
            ++i;
        }
        return clusterings[mini];
    }

    public static EMResult getBestResult(EMResult[] clusterings, int n, int criterion) {
        if (clusterings == null) {
            return null;
        }
        EMResult[] nfirst = new EMResult[Math.min(n, clusterings.length)];
        int i = 0;
        while (i < nfirst.length) {
            nfirst[i] = clusterings[i];
            ++i;
        }
        return EMCriteria.getBestResult(nfirst, criterion);
    }

    public static EMResult getBestResult(EMResult[] clusterings, String criterion) {
        return EMCriteria.getBestResult(clusterings, EMCriteria.getCriterionIdx(criterion));
    }

    public static EMResult getBestResult(EMResult[] clusterings, int n, String criterion) {
        return EMCriteria.getBestResult(clusterings, n, EMCriteria.getCriterionIdx(criterion));
    }

    public static Iterator getCriteria() {
        ArrayList<String> list = new ArrayList<String>(5);
        list.add(AIC_NAME);
        list.add(AICc_NAME);
        list.add(AIC3_NAME);
        list.add(BIC_NAME);
        list.add(AWE_NAME);
        return list.iterator();
    }

    public static int getCriterionIdx(String name) {
        if (name.equalsIgnoreCase(AIC_NAME)) {
            return 0;
        }
        if (name.equalsIgnoreCase(AICc_NAME)) {
            return 5;
        }
        if (name.equalsIgnoreCase(AIC3_NAME)) {
            return 1;
        }
        if (name.equalsIgnoreCase(ICOMP_NAME)) {
            return 2;
        }
        if (name.equalsIgnoreCase(BIC_NAME)) {
            return 3;
        }
        if (name.equalsIgnoreCase(AWE_NAME)) {
            return 4;
        }
        return 0;
    }

    public double getCriterion(String criterion) {
        return this.getCriterion(EMCriteria.getCriterionIdx(criterion));
    }
}

