/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl;

import java.util.Enumeration;
import java.util.Hashtable;
import org.metaqtl.ChromCluster;
import org.metaqtl.MetaDico;
import org.metaqtl.bio.IBioCross;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioLGroup;
import org.metaqtl.bio.IBioLocus;
import org.metaqtl.bio.entity.CrossPopulation;
import org.metaqtl.util.GeneticMapProperties;

public class MapCluster {
    private IBioLocus[] dubious;
    private Hashtable clusters = new Hashtable();
    private MetaDico chrDico;
    private MetaDico mrkDico;

    public void addMap(IBioGenome map, boolean skeleton) {
        int mappingFunct = GeneticMapProperties.getMappingFunction(map);
        int mappingUnit = GeneticMapProperties.getMappingUnit(map);
        boolean rescale = GeneticMapProperties.needToBeRescaled(map);
        CrossPopulation crossDesign = GeneticMapProperties.getCrossDesign(map);
        IBioLGroup[] groups = map.groups();
        int i = 0;
        while (i < groups.length) {
            this.addChromosome(groups[i], crossDesign, mappingFunct, mappingUnit, rescale, skeleton);
            ++i;
        }
    }

    public void addChromosome(IBioLGroup group, IBioCross crossDesign, int mappingFunction, int mappingUnit, boolean rescale, boolean skeleton) {
        String groupName = this.getChromosomeName(group.getName());
        if (this.clusters.containsKey(groupName)) {
            ChromCluster cluster = (ChromCluster)this.clusters.get(groupName);
            cluster.addChromosome(group, crossDesign, mappingFunction, mappingUnit, rescale, skeleton);
        } else {
            ChromCluster cluster = new ChromCluster();
            cluster.setMarkerDico(this.mrkDico);
            cluster.setDubiousMarker(this.dubious);
            cluster.addChromosome(group, crossDesign, mappingFunction, mappingUnit, rescale, skeleton);
            this.clusters.put(groupName, cluster);
        }
    }

    public String getChromosomeName(String name) {
        if (this.chrDico == null) {
            return name;
        }
        return null;
    }

    public ChromCluster[] getClusters() {
        if (this.clusters == null) {
            return null;
        }
        if (this.clusters.size() == 0) {
            return null;
        }
        ChromCluster[] chrClusters = new ChromCluster[this.clusters.size()];
        int i = 0;
        Enumeration enu = this.clusters.keys();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            chrClusters[i] = (ChromCluster)this.clusters.get(name);
            chrClusters[i].name = name;
            ++i;
        }
        return chrClusters;
    }

    public void setDubiousMarker(IBioLocus[] dubious) {
        this.dubious = dubious;
    }

    public MetaDico getMarkerDico() {
        return this.mrkDico;
    }

    public void setMarkerDico(MetaDico mrkDico) {
        this.mrkDico = mrkDico;
    }

    public void addAllMap(IBioGenome[] maps) {
        if (maps == null) {
            return;
        }
        int i = 0;
        while (i < maps.length) {
            this.addMap(maps[i], false);
            ++i;
        }
    }
}

