/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl;

import java.io.Serializable;

public class TreeNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int idx;
    public String label;
    public int card = 0;
    public int[] nidx = null;
    public boolean leaf = false;
    public double dist = 0.0;
    public double height;
    public TreeNode[] children = null;
    public TreeNode parent = null;
    public double x;
    public double y;
    public double xc;

    public TreeNode(int idx) {
        this.idx = idx;
        this.leaf = true;
        this.card = 1;
        this.nidx = new int[1];
        this.nidx[0] = idx;
    }

    public TreeNode(int idx, TreeNode[] children) {
        this.idx = idx;
        if (children != null) {
            this.card = 0;
            int i = 0;
            while (i < children.length) {
                this.card += children[i].card;
                ++i;
            }
            this.nidx = new int[this.card];
            i = 0;
            int k = 0;
            while (i < children.length) {
                int j = 0;
                while (j < children[i].card) {
                    this.nidx[k] = children[i].nidx[j];
                    ++j;
                    ++k;
                }
                ++i;
            }
            this.children = children;
        }
    }

    public TreeNode() {
    }

    public void addChild(TreeNode node) {
        int i;
        TreeNode[] tmp;
        if (node == null) {
            return;
        }
        if (this.children == null) {
            this.children = new TreeNode[1];
            tmp = this.children;
            i = 0;
        } else {
            tmp = new TreeNode[this.children.length + 1];
            i = 0;
            while (i < this.children.length) {
                tmp[i] = this.children[i];
                ++i;
            }
        }
        tmp[i] = node;
        this.children = tmp;
        if (node.card > 0 && node.nidx != null) {
            int[] uidx = new int[this.card + node.card];
            i = 0;
            if (this.card > 0) {
                while (i < this.card) {
                    uidx[i] = this.nidx[i];
                    ++i;
                }
            }
            i = 0;
            while (i < node.card) {
                uidx[i + this.card] = node.nidx[i];
                ++i;
            }
            this.card += node.card;
            this.nidx = uidx;
        }
    }

    public String getName() {
        return this.label;
    }

    public TreeNode[] getChildren() {
        return this.children;
    }

    public int getCard() {
        return this.card;
    }

    public double getHeight() {
        return this.height;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getY() {
        return this.y;
    }

    public double getX() {
        return this.x;
    }

    public double getDist() {
        return this.dist;
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public void setCentroid(double xc) {
        this.xc = xc;
    }

    public double getCentroid(double[] y2, double[] sd) {
        if (this.nidx == null) {
            return 0.0;
        }
        double t = 0.0;
        double s = 0.0;
        int i = 0;
        while (i < this.nidx.length) {
            t += y2[this.nidx[i]] / (sd[this.nidx[i]] * sd[this.nidx[i]]);
            s += 1.0 / (sd[this.nidx[i]] * sd[this.nidx[i]]);
            ++i;
        }
        return t / s;
    }
}

