/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.algo;

import org.metaqtl.Chromosome;
import org.metaqtl.MetaQtlAnalysis;
import org.metaqtl.adapter.ChromosomeAdapter;
import org.metaqtl.algo.MetaAlgorithm;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioOntology;

public abstract class ClustAlgorithm
extends MetaAlgorithm {
    protected MetaQtlAnalysis result;
    protected Chromosome[] chromosomes;
    protected IBioOntology ontology;
    protected String chrName;
    protected int sd_mode = 4;
    protected int missing_sd_mode = 1;

    public ClustAlgorithm(IBioGenome map, IBioOntology ontology) {
        this.init(map, ontology);
    }

    public ClustAlgorithm(IBioGenome map, String name, IBioOntology ontology) {
        this.init(map, ontology);
        if (name != null) {
            this.chrName = new String(name);
        }
    }

    public void setCIMode(int sd_mode) {
        this.sd_mode = sd_mode;
    }

    private void init(IBioGenome map, IBioOntology ontology) {
        if (map == null) {
            return;
        }
        this.chromosomes = ChromosomeAdapter.toChromosomes(map);
        this.ontology = ontology;
        int i = 0;
        while (i < this.chromosomes.length) {
            if (this.chromosomes[i].hasQTL()) {
                ++this.workAmount;
            }
            ++i;
        }
    }

    public void setCIMiss(int missing_sd_mode) {
        this.missing_sd_mode = missing_sd_mode;
    }

    public MetaQtlAnalysis getResult() {
        return this.result;
    }
}

