/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.algo;

import org.metaqtl.EMResult;
import org.metaqtl.MetaQtlData;
import org.metaqtl.MetaQtlResult;
import org.metaqtl.adapter.MetaQtlAnalysisAdapter;
import org.metaqtl.algo.ClustAlgorithm;
import org.metaqtl.algo.EMAlgorithm;
import org.metaqtl.bio.IBioGenome;
import org.metaqtl.bio.IBioOntology;

public class QtlClustAlgorithm
extends ClustAlgorithm {
    private int nmax_cluster = 0;
    private int n_em_start = EMAlgorithm.EM_START;
    private double em_eps = EMAlgorithm.EM_ERR;

    public QtlClustAlgorithm(IBioGenome map, IBioOntology ontology) {
        super(map, ontology);
    }

    public QtlClustAlgorithm(IBioGenome map, String chrom, IBioOntology ontology) {
        super(map, chrom, ontology);
    }

    public void run() {
        int i = 0;
        while (i < this.chromosomes.length) {
            if (this.chromosomes[i].hasQTL()) {
                boolean doClust;
                boolean bl = doClust = this.chrName == null || this.chrName != null && this.chrName.equals(this.chromosomes[i].getName());
                if (doClust) {
                    ++this.workProgress;
                    this.chromosomes[i].computeQtlSD(this.sd_mode);
                    MetaQtlData data = new MetaQtlData(this.chromosomes[i].getQtls());
                    if (this.ontology == null) {
                        data.doTraitGroupClustering();
                    } else {
                        data.doTraitOntologyClustering(this.ontology);
                    }
                    data.manageMissingData(this.missing_sd_mode);
                    if (this.isLoggerEnable()) {
                        this.getLogger().println("Start Clustering on chromosome " + this.chromosomes[i].getName());
                        this.getLogger().flush();
                    }
                    this.chromosomes[i].metaQtlAnalysis = this.doQtlClustering(data);
                }
            }
            ++i;
        }
        this.result = MetaQtlAnalysisAdapter.adapt(this.chromosomes);
    }

    public MetaQtlResult[] doQtlClustering(MetaQtlData data) {
        MetaQtlResult[] results = null;
        if (data == null) {
            return null;
        }
        int ntg = data.getTraitClusterNumber();
        results = new MetaQtlResult[ntg];
        int i = 0;
        while (i < ntg) {
            Double[][] X = data.getDataPoints(i, true);
            if (X != null) {
                String trait = data.getTraitClusterName(i);
                if (this.isLoggerEnable()) {
                    this.getLogger().println("Clustering for trait " + trait);
                    this.getLogger().flush();
                }
                results[i] = this.doDataPointClustering(trait, X[0], X[1]);
                if (results[i] != null) {
                    results[i].setQtlIdx(data.getQtlIdx(i));
                } else if (this.isLoggerEnable()) {
                    this.getLogger().print("[ WARNING ] : ");
                    this.getLogger().println("No result for trait cluster " + trait);
                    this.getLogger().flush();
                }
            }
            ++i;
        }
        return results;
    }

    private MetaQtlResult doDataPointClustering(String trait, Double[] x, Double[] sd) {
        MetaQtlResult result = null;
        EMResult[] emResults = null;
        if (x == null || sd == null) {
            return null;
        }
        if (x.length < 2) {
            return null;
        }
        int n = x.length;
        result = new MetaQtlResult(trait, n);
        result.setX(x);
        result.setSD(sd);
        if (this.nmax_cluster > 0 && this.nmax_cluster < n) {
            n = this.nmax_cluster;
            emResults = new EMResult[n + 1];
        } else {
            emResults = new EMResult[n];
        }
        EMAlgorithm.EM_START = this.n_em_start;
        EMAlgorithm.EM_ERR = this.em_eps;
        int i = 0;
        while (i < n) {
            emResults[i] = EMAlgorithm.doEM(result.x, result.sd, i + 1, null);
            if (emResults[i] != null) {
                emResults[i].computeCriteria();
            }
            if (this.isLoggerEnable()) {
                this.getLogger().println("EM [ rs=" + this.n_em_start + ", eps=" + this.em_eps + " ]");
                this.getLogger().println("Cluster K=" + (i + 1) + " : [done]");
                this.getLogger().flush();
            }
            ++i;
        }
        if (n < x.length) {
            emResults[i] = EMAlgorithm.doEM(result.x, result.sd, x.length, null);
            emResults[i].computeCriteria();
            if (this.isLoggerEnable()) {
                this.getLogger().println("Cluster K=" + x.length + " : [done]");
                this.getLogger().flush();
            }
        }
        result.setClusterings(emResults);
        return result;
    }

    public void setMaxClusterNumber(int nmax) {
        this.nmax_cluster = nmax;
    }

    public int getEMRanStartNumber() {
        return this.n_em_start;
    }

    public void setEMRanStartNumber(int n) {
        this.n_em_start = n;
    }

    public double getEMEps() {
        return this.em_eps;
    }

    public void setEMEps(double epsilon) {
        this.em_eps = epsilon;
    }
}

