/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.algo;

import org.metaqtl.MultiFitResult;
import org.metaqtl.numrec.NumericalUtilities;

public strictfp final class SVDAlgorithm {
    private static double TOL = 1.0E-5;
    private static final int ITMAX = 30;

    public static MultiFitResult SVDMFit(double[][] X, double[] y, double[] w, int m, int n) {
        double sum;
        int j;
        MultiFitResult result = new MultiFitResult(m, n);
        double[][] U = new double[m][n];
        double[][] V = new double[n][n];
        double[] t = new double[n];
        double[] b = new double[m];
        double[] wti = new double[m];
        int i = 0;
        while (i < m) {
            j = 0;
            while (j < n) {
                U[i][j] = X[i][j] * w[i];
                ++j;
            }
            b[i] = y[i] * w[i];
            ++i;
        }
        SVDAlgorithm.SVDecomposition(U, V, t, m, n);
        double tmax = 0.0;
        j = 0;
        while (j < n) {
            if (t[j] > tmax) {
                tmax = t[j];
            }
            ++j;
        }
        double thresh = TOL * tmax;
        j = 0;
        while (j < n) {
            if (t[j] < thresh) {
                t[j] = 0.0;
            }
            ++j;
        }
        result.theta = SVDAlgorithm.SVDBackSub(U, t, V, b, m, n);
        result.chi2 = 0.0;
        i = 0;
        while (i < m) {
            double tmp;
            sum = 0.0;
            j = 0;
            while (j < n) {
                sum += result.theta[j] * X[i][j];
                ++j;
            }
            result.rsd[i] = tmp = (y[i] - sum) * w[i];
            tmp *= tmp;
            result.chi2 += tmp;
            ++i;
        }
        result.dof = m - n;
        result.pvalue = NumericalUtilities.gammp(0.5 * (double)result.dof, 0.5 * result.chi2);
        i = 0;
        while (i < n) {
            wti[i] = 0.0;
            if (t[i] != 0.0) {
                wti[i] = 1.0 / (t[i] * t[i]);
            }
            ++i;
        }
        i = 0;
        while (i < n) {
            j = 0;
            while (j <= i) {
                sum = 0.0;
                int k = 0;
                while (k < n) {
                    sum += V[i][k] * V[j][k] * wti[k];
                    ++k;
                }
                double d = sum;
                result.cov[i][j] = d;
                result.cov[j][i] = d;
                ++j;
            }
            ++i;
        }
        result.m = n;
        result.n = m;
        return result;
    }

    public static double[] SVDBackSub(double[][] U, double[] w, double[][] V, double[] b, int n, int m) {
        double s;
        double[] x = new double[n];
        double[] tmp = new double[n];
        int j = 0;
        while (j < m) {
            s = 0.0;
            if (w[j] != 0.0) {
                int i = 0;
                while (i < n) {
                    s += U[i][j] * b[i];
                    ++i;
                }
                s /= w[j];
            }
            tmp[j] = s;
            ++j;
        }
        j = 0;
        while (j < m) {
            s = 0.0;
            int jj = 0;
            while (jj < m) {
                s += V[j][jj] * tmp[jj];
                ++jj;
            }
            x[j] = s;
            ++j;
        }
        tmp = null;
        return x;
    }

    public static void SVDecomposition(double[][] A, double[][] V, double[] w, int m, int n) {
        int j;
        double h;
        double f;
        int k;
        double s;
        double[] rv1 = new double[m];
        double anorm = 0.0;
        double scale = 0.0;
        double g = 0.0;
        int nm = 0;
        int l = 0;
        int i = 0;
        while (i < n) {
            l = i + 1;
            rv1[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < m) {
                k = i;
                while (k < m) {
                    scale += Math.abs(A[k][i]);
                    ++k;
                }
                if (scale != 0.0) {
                    k = i;
                    while (k < m) {
                        double[] dArray = A[k];
                        int n2 = i;
                        dArray[n2] = dArray[n2] / scale;
                        s += A[k][i] * A[k][i];
                        ++k;
                    }
                    f = A[i][i];
                    g = -NumericalUtilities.SIGN(Math.sqrt(s), f);
                    h = f * g - s;
                    A[i][i] = f - g;
                    j = l;
                    while (j < n) {
                        s = 0.0;
                        k = i;
                        while (k < m) {
                            s += A[k][i] * A[k][j];
                            ++k;
                        }
                        f = s / h;
                        k = i;
                        while (k < m) {
                            double[] dArray = A[k];
                            int n3 = j;
                            dArray[n3] = dArray[n3] + f * A[k][i];
                            ++k;
                        }
                        ++j;
                    }
                    k = i;
                    while (k < m) {
                        A[k][i] = A[k][i] * scale;
                        ++k;
                    }
                }
            }
            w[i] = scale * g;
            scale = 0.0;
            s = 0.0;
            g = 0.0;
            if (i < m && i != n - 1) {
                k = l;
                while (k < n) {
                    scale += Math.abs(A[i][k]);
                    ++k;
                }
                if (scale != 0.0) {
                    k = l;
                    while (k < n) {
                        A[i][k] = A[i][k] / scale;
                        s += A[i][k] * A[i][k];
                        ++k;
                    }
                    f = A[i][l];
                    g = -NumericalUtilities.SIGN(Math.sqrt(s), f);
                    h = f * g - s;
                    A[i][l] = f - g;
                    k = l;
                    while (k < n) {
                        rv1[k] = A[i][k] / h;
                        ++k;
                    }
                    j = l;
                    while (j < m) {
                        s = 0.0;
                        k = l;
                        while (k < n) {
                            s += A[j][k] * A[i][k];
                            ++k;
                        }
                        k = l;
                        while (k < n) {
                            A[j][k] = A[j][k] + s * rv1[k];
                            ++k;
                        }
                        ++j;
                    }
                    k = l;
                    while (k < n) {
                        A[i][k] = A[i][k] * scale;
                        ++k;
                    }
                }
            }
            anorm = NumericalUtilities.DMAX(anorm, Math.abs(w[i]) + Math.abs(rv1[i]));
            ++i;
        }
        i = n - 1;
        while (i >= 0) {
            if (i < n - 1) {
                if (g != 0.0) {
                    j = l;
                    while (j < n) {
                        V[j][i] = A[i][j] / A[i][l] / g;
                        ++j;
                    }
                    j = l;
                    while (j < n) {
                        s = 0.0;
                        k = l;
                        while (k < n) {
                            s += A[i][k] * V[k][j];
                            ++k;
                        }
                        k = l;
                        while (k < n) {
                            double[] dArray = V[k];
                            int n4 = j;
                            dArray[n4] = dArray[n4] + V[k][i] * s;
                            ++k;
                        }
                        ++j;
                    }
                }
                j = l;
                while (j < n) {
                    V[j][i] = 0.0;
                    V[i][j] = 0.0;
                    ++j;
                }
            }
            V[i][i] = 1.0;
            g = rv1[i];
            l = i--;
        }
        i = NumericalUtilities.IMIN(m - 1, n - 1);
        while (i >= 0) {
            l = i + 1;
            g = w[i];
            j = l;
            while (j < n) {
                A[i][j] = 0.0;
                ++j;
            }
            if (g != 0.0) {
                g = 1.0 / g;
                j = l;
                while (j < n) {
                    s = 0.0;
                    k = l;
                    while (k < m) {
                        s += A[k][i] * A[k][j];
                        ++k;
                    }
                    f = s / A[i][i] * g;
                    k = i;
                    while (k < m) {
                        double[] dArray = A[k];
                        int n5 = j;
                        dArray[n5] = dArray[n5] + f * A[k][i];
                        ++k;
                    }
                    ++j;
                }
                j = i;
                while (j < m) {
                    double[] dArray = A[j];
                    int n6 = i;
                    dArray[n6] = dArray[n6] * g;
                    ++j;
                }
            } else {
                j = i;
                while (j < m) {
                    A[j][i] = 0.0;
                    ++j;
                }
            }
            double[] dArray = A[i];
            int n7 = i--;
            dArray[n7] = dArray[n7] + 1.0;
        }
        k = n - 1;
        while (k >= 0) {
            int its = 1;
            while (its <= 30) {
                double z;
                double y;
                double c;
                boolean flag = true;
                l = k;
                while (l >= 0) {
                    nm = l - 1;
                    if (Math.abs(rv1[l]) + anorm == anorm) {
                        flag = false;
                        break;
                    }
                    if (Math.abs(w[nm]) + anorm == anorm) break;
                    --l;
                }
                if (flag) {
                    c = 0.0;
                    s = 1.0;
                    i = l;
                    while (i <= k) {
                        f = s * rv1[i];
                        rv1[i] = c * rv1[i];
                        if (Math.abs(f) + anorm == anorm) break;
                        g = w[i];
                        w[i] = h = NumericalUtilities.PYTHAG(f, g);
                        h = 1.0 / h;
                        c = g * h;
                        s = -f * h;
                        j = 0;
                        while (j < m) {
                            y = A[j][nm];
                            z = A[j][i];
                            A[j][nm] = y * c + z * s;
                            A[j][i] = z * c - y * s;
                            ++j;
                        }
                        ++i;
                    }
                }
                z = w[k];
                if (l == k) {
                    if (!(z < 0.0)) break;
                    w[k] = -z;
                    j = 0;
                    while (j < n) {
                        V[j][k] = -V[j][k];
                        ++j;
                    }
                    break;
                }
                if (its == 30) {
                    System.err.println("SVD : Too many iterations\n");
                    return;
                }
                double x = w[l];
                nm = k - 1;
                y = w[nm];
                g = rv1[nm];
                h = rv1[k];
                f = ((y - z) * (y + z) + (g - h) * (g + h)) / (2.0 * h * y);
                g = NumericalUtilities.PYTHAG(f, 1.0);
                f = ((x - z) * (x + z) + h * (y / (f + NumericalUtilities.SIGN(g, f)) - h)) / x;
                s = 1.0;
                c = 1.0;
                j = l;
                while (j <= nm) {
                    i = j + 1;
                    g = rv1[i];
                    y = w[i];
                    h = s * g;
                    g = c * g;
                    rv1[j] = z = NumericalUtilities.PYTHAG(f, h);
                    c = f / z;
                    s = h / z;
                    f = x * c + g * s;
                    g = g * c - x * s;
                    h = y * s;
                    y *= c;
                    int jj = 0;
                    while (jj < n) {
                        x = V[jj][j];
                        z = V[jj][i];
                        V[jj][j] = x * c + z * s;
                        V[jj][i] = z * c - x * s;
                        ++jj;
                    }
                    w[j] = z = NumericalUtilities.PYTHAG(f, h);
                    if (z != 0.0) {
                        z = 1.0 / z;
                        c = f * z;
                        s = h * z;
                    }
                    f = c * g + s * y;
                    x = c * y - s * g;
                    jj = 0;
                    while (jj < m) {
                        y = A[jj][j];
                        z = A[jj][i];
                        A[jj][j] = y * c + z * s;
                        A[jj][i] = z * c - y * s;
                        ++jj;
                    }
                    ++j;
                }
                rv1[l] = 0.0;
                rv1[k] = f;
                w[k] = x;
                ++its;
            }
            --k;
        }
        rv1 = null;
    }
}

