/*
 * Decompiled with CFR 0.152.
 */
package org.metaqtl.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.metaqtl.EMResult;
import org.metaqtl.MetaQtlAnalysis;
import org.metaqtl.MetaQtlResult;
import org.metaqtl.Qtl;
import org.metaqtl.bio.util.NumberFormat;
import org.metaqtl.factory.EMResultFactory;
import org.metaqtl.factory.TreeFactory;

public final class MetaQtlAnalysisFactory {
    static /* synthetic */ Class class$0;

    public static MetaQtlAnalysis read(InputStream stream) throws IOException {
        InputStreamReader reader = new InputStreamReader(stream);
        return MetaQtlAnalysisFactory.read(reader);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MetaQtlAnalysis read(Reader reader) throws IOException {
        Hashtable traitTable;
        String line;
        if (reader == null) {
            return null;
        }
        int qtlIdx = 0;
        MetaQtlResult result = null;
        MetaQtlAnalysis analysis = null;
        String chromName = null;
        String traitName = null;
        BufferedReader buffer = new BufferedReader(reader);
        Hashtable chromTable = new Hashtable();
        Hashtable<String, ArrayList> qtlTable = new Hashtable<String, ArrayList>();
        ArrayList qtlList = null;
        ArrayList<EMResult> emResultList = null;
        int qtlNumber = 0;
        boolean first = false;
        int lineNumber = 1;
        while ((line = buffer.readLine()) != null) {
            if (line.length() < 2) continue;
            block3 : switch (line.charAt(0)) {
                case 'C': {
                    switch (line.charAt(1)) {
                        case 'R': {
                            chromName = line.substring(3).trim();
                            if (!chromTable.containsKey(chromName)) {
                                chromTable.put(chromName, new Hashtable());
                            }
                            if (!qtlTable.containsKey(chromName)) {
                                qtlList = new ArrayList();
                                qtlTable.put(chromName, qtlList);
                                break block3;
                            }
                            qtlList = (ArrayList)qtlTable.get(chromName);
                            break block3;
                        }
                        case 'L': {
                            if (first) {
                                int i = 1;
                                while (i <= qtlNumber) {
                                    qtlIdx = qtlNumber - i;
                                    result.qtlIdx[qtlIdx] = qtlList.size() - i;
                                    result.x[qtlIdx] = ((Qtl)qtlList.get((int)(qtlList.size() - i))).position;
                                    result.sd[qtlIdx] = ((Qtl)qtlList.get((int)(qtlList.size() - i))).sd_position;
                                    ++i;
                                }
                                first = false;
                            }
                            buffer.reset();
                            emResultList.add(EMResultFactory.read(buffer));
                            break block3;
                        }
                    }
                    break;
                }
                case 'Q': {
                    if (qtlList == null) {
                        Class<?> clazz = class$0;
                        if (clazz != null) throw new IOException(String.valueOf(clazz.getName()) + ": Bad file format " + lineNumber);
                        try {
                            clazz = class$0 = Class.forName("org.metaqtl.factory.MetaQtlAnalysisFactory");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        throw new IOException(String.valueOf(clazz.getName()) + ": Bad file format " + lineNumber);
                    }
                    StringTokenizer tokenizer = new StringTokenizer(line.substring(3));
                    if (tokenizer.countTokens() != 4) {
                        Class<?> clazz = class$0;
                        if (clazz != null) throw new IOException(String.valueOf(clazz.getName()) + ": Bad line format " + lineNumber);
                        try {
                            clazz = class$0 = Class.forName("org.metaqtl.factory.MetaQtlAnalysisFactory");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        throw new IOException(String.valueOf(clazz.getName()) + ": Bad line format " + lineNumber);
                    }
                    Qtl qtl = new Qtl();
                    qtl.id = Integer.parseInt(tokenizer.nextToken());
                    qtl.name = tokenizer.nextToken();
                    qtl.position = NumberFormat.parseDouble(tokenizer.nextToken());
                    qtl.sd_position = NumberFormat.parseDouble(tokenizer.nextToken());
                    qtlList.add(qtl);
                    break;
                }
                case 'T': {
                    if (chromName == null) {
                        Class<?> clazz = class$0;
                        if (clazz != null) throw new IOException(String.valueOf(clazz.getName()) + ": Bad file format " + lineNumber);
                        try {
                            clazz = class$0 = Class.forName("org.metaqtl.factory.MetaQtlAnalysisFactory");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        throw new IOException(String.valueOf(clazz.getName()) + ": Bad file format " + lineNumber);
                    }
                    traitTable = (Hashtable)chromTable.get(chromName);
                    StringTokenizer tokenizer = new StringTokenizer(line.substring(3));
                    traitName = tokenizer.nextToken();
                    qtlNumber = Integer.parseInt(tokenizer.nextToken());
                    result = new MetaQtlResult(traitName, qtlNumber);
                    traitTable.put(traitName, result);
                    first = true;
                    emResultList = new ArrayList<EMResult>();
                    break;
                }
                case 'H': {
                    line = line.substring(line.indexOf("HC") + 2);
                    result.tree = TreeFactory.read(line);
                    int i = 0;
                    while (i < qtlNumber) {
                        result.qtlIdx[i] = i;
                        result.x[i] = ((Qtl)qtlList.get((int)i)).position;
                        result.sd[i] = ((Qtl)qtlList.get((int)i)).sd_position;
                        ++i;
                    }
                    break;
                }
                case '-': {
                    if (emResultList.size() > 0) {
                        result.setClusterings(emResultList);
                    }
                    chromName = null;
                    traitName = null;
                    result = null;
                    break;
                }
            }
            buffer.mark(line.length());
            ++lineNumber;
        }
        if (chromTable.size() <= 0) return analysis;
        analysis = new MetaQtlAnalysis(chromTable.size());
        int i = 0;
        Enumeration e = chromTable.keys();
        while (e.hasMoreElements()) {
            analysis.chromNames[i] = (String)e.nextElement();
            traitTable = (Hashtable)chromTable.get(analysis.chromNames[i]);
            qtlList = (ArrayList)qtlTable.get(analysis.chromNames[i]);
            analysis.resultByChrom[i] = new MetaQtlResult[traitTable.size()];
            int j = 0;
            Enumeration e1 = traitTable.keys();
            while (e1.hasMoreElements()) {
                analysis.resultByChrom[i][j] = (MetaQtlResult)traitTable.get(e1.nextElement());
                ++j;
            }
            analysis.qtlByChrom[i] = new Qtl[qtlList.size()];
            j = 0;
            while (j < qtlList.size()) {
                analysis.qtlByChrom[i][j] = (Qtl)qtlList.get(j);
                ++j;
            }
            ++i;
        }
        return analysis;
    }

    public static void write(MetaQtlAnalysis analysis, OutputStream stream) throws IOException {
        if (analysis == null) {
            return;
        }
        if (stream == null) {
            return;
        }
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(stream));
        int nchr = analysis.nchr;
        int i = 0;
        while (i < nchr) {
            MetaQtlResult[] results = analysis.resultByChrom[i];
            int j = 0;
            while (j < results.length) {
                if (results[j] != null) {
                    writer.println("CR " + analysis.chromNames[i].replace(" ", "_"));
                    writer.println("TR " + results[j].trait.replace(" ", "_") + " " + results[j].nqtl);
                    int l = 0;
                    while (l < results[j].nqtl) {
                        writer.println("QT " + l + " " + analysis.qtlByChrom[i][results[j].qtlIdx[l]].getName().replace(" ", "_") + " " + NumberFormat.formatDouble(results[j].x[l]) + " " + NumberFormat.formatDouble(results[j].sd[l]));
                        ++l;
                    }
                    if (results[j].clusterings != null) {
                        MetaQtlAnalysisFactory.writeClustering(results[j], writer);
                    }
                    if (results[j].tree != null) {
                        MetaQtlAnalysisFactory.writeTree(results[j], writer);
                    }
                    writer.println("--");
                    writer.flush();
                }
                ++j;
            }
            ++i;
        }
        writer.flush();
        writer.close();
    }

    private static void writeClustering(MetaQtlResult result, PrintWriter writer) {
        int l = 0;
        while (l < result.nmqc) {
            EMResult cluster = result.clusterings[l];
            if (cluster != null) {
                EMResultFactory.write(cluster, writer);
            }
            ++l;
        }
    }

    private static void writeTree(MetaQtlResult result, PrintWriter writer) {
        writer.print("HC ");
        TreeFactory.write(result.tree, writer);
        writer.println();
        writer.flush();
    }
}

